package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CHEMICAL_CONN_BOND category would not, in
 *  general, be used in a macromolecular CIF. See instead the
 *  ENTITY data items.
 *  
 *  Data items in the CHEMICAL_CONN_ATOM and CHEMICAL_CONN_BOND
 *  categories record details about the two-dimensional (2D)
 *  chemical structure of the molecular species. They allow a
 *  2D chemical diagram to be reconstructed for use in a
 *  publication or in a database search for structural and
 *  substructural relationships.
 *  
 *  The CHEMICAL_CONN_BOND data items specify the connections
 *  between the atoms in the CHEMICAL_CONN_ATOM list and the nature
 *  of the chemical bond between these atoms.
 *  
 * <pre>
 *  Example 1 - based on data set DPTD of Yamin, Suwandi, Fun, Sivakumar &
 *  bin Shawkataly [Acta Cryst. (1996), C52, 951-953].
 *  <PDBx:chemical_conn_bondCategory>
 *  <PDBx:chemical_conn_bond atom_1="4" atom_2="1">
 *  <PDBx:type>doub</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="4" atom_2="3">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="4" atom_2="2">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="5" atom_2="3">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="6" atom_2="5">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="7" atom_2="6">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="8" atom_2="7">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="8" atom_2="3">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="10" atom_2="2">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="12" atom_2="9">
 *  <PDBx:type>doub</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="12" atom_2="11">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="12" atom_2="10">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="13" atom_2="11">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="14" atom_2="13">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="15" atom_2="14">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="16" atom_2="15">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="16" atom_2="11">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="17" atom_2="5">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="18" atom_2="5">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="19" atom_2="6">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="20" atom_2="6">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="21" atom_2="7">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="22" atom_2="7">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="23" atom_2="8">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="24" atom_2="8">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="25" atom_2="13">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="26" atom_2="13">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="27" atom_2="14">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="28" atom_2="14">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="29" atom_2="15">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="30" atom_2="15">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="31" atom_2="16">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  <PDBx:chemical_conn_bond atom_1="32" atom_2="16">
 *  <PDBx:type>sing</PDBx:type>
 *  </PDBx:chemical_conn_bond>
 *  </PDBx:chemical_conn_bondCategory>
 * </pre>
 */
public class Chemical_conn_bond extends org.pdb.beans.Chemical_conn_bond implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "chemical_conn_bond";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Chemical_conn_bond()
	{
	}

	/** Full constructor */
	public Chemical_conn_bond(
		Datablock datablock,
		java.lang.Integer atom_1,
		java.lang.Integer atom_2,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.atom_1 = atom_1;
		this.atom_2 = atom_2;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Chemical_conn_bond");
		sb.append("\n");
		if (atom_1 != null)
		{
			sb.append("atom_1 = ");
			sb.append(atom_1);
			sb.append('\n');
		}
		if (atom_2 != null)
		{
			sb.append("atom_2 = ");
			sb.append(atom_2);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_1 = null;
		atom_2 = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Chemical_conn_bond)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:chemical_conn_bond>\n");
			if (atom_1 != null) ow.write(indent + " <PDBx:atom_1>" + atom_1 + "</PDBx:atom_1>\n");
			if (atom_2 != null) ow.write(indent + " <PDBx:atom_2>" + atom_2 + "</PDBx:atom_2>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:chemical_conn_bond>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
