package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CITATION_AUTHOR category record details
 *  about the authors associated with the citations in the
 *  CITATION list.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:citation_authorCategory>
 *  <PDBx:citation_author citation_id="primary" ordinal="1" name="Fitzgerald, P.M.D."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="2" name="McKeever, B.M."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="3" name="Van Middlesworth, J.F."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="4" name="Springer, J.P."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="5" name="Heimbach, J.C."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="6" name="Leu, C.-T."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="7" name="Herber, W.K."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="8" name="Dixon, R.A.F."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="primary" ordinal="9" name="Darke, P.L."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="1" name="Navia, M.A."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="2" name="Fitzgerald, P.M.D."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="3" name="McKeever, B.M."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="4" name="Leu, C.-T."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="5" name="Heimbach, J.C."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="6" name="Herber, W.K."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="7" name="Sigal, I.S."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="8" name="Darke, P.L."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="2" ordinal="9" name="Springer, J.P."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="1" name="McKeever, B.M."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="2" name="Navia, M.A."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="3" name="Fitzgerald, P.M.D."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="4" name="Springer, J.P."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="5" name="Leu, C.-T."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="6" name="Heimbach, J.C."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="7" name="Herber, W.K."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="8" name="Sigal, I.S."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="3" ordinal="9" name="Darke, P.L."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="1" name="Darke, P.L."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="2" name="Leu, C.-T."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="3" name="Davis, L.J."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="4" name="Heimbach, J.C."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="5" name="Diehl, R.E."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="6" name="Hill, W.S."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="7" name="Dixon, R.A.F."></PDBx:citation_author>
 *  <PDBx:citation_author citation_id="4" ordinal="8" name="Sigal, I.S."></PDBx:citation_author>
 *  </PDBx:citation_authorCategory>
 * </pre>
 */
public class Citation_author extends org.pdb.beans.Citation_author implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "citation_author";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Citation_author()
	{
	}

	/** Full constructor */
	public Citation_author(
		Datablock datablock,
		java.lang.String citation_id,
		java.lang.String name,
		java.lang.Integer ordinal)
	{
		this.datablock = datablock;
		this.citation_id = citation_id;
		this.name = name;
		this.ordinal = ordinal;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Citation_author");
		sb.append("\n");
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (ordinal != null)
		{
			sb.append("ordinal = ");
			sb.append(ordinal);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		citation_id = null;
		name = null;
		ordinal = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Citation_author)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:citation_author>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (ordinal != null) ow.write(indent + " <PDBx:ordinal>" + ordinal + "</PDBx:ordinal>\n");
			ow.write(indent + "</PDBx:citation_author>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
