package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the CITATION_EDITOR category record details
 *  about the editors associated with the books or book chapters
 *  cited in the CITATION list.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:citation_editorCategory>
 *  <PDBx:citation_editor citation_id="5" name="McKeever, B.M."></PDBx:citation_editor>
 *  <PDBx:citation_editor citation_id="5" name="Navia, M.A."></PDBx:citation_editor>
 *  <PDBx:citation_editor citation_id="5" name="Fitzgerald, P.M.D."></PDBx:citation_editor>
 *  <PDBx:citation_editor citation_id="5" name="Springer, J.P."></PDBx:citation_editor>
 *  </PDBx:citation_editorCategory>
 * </pre>
 */
public class Citation_editor extends org.pdb.beans.Citation_editor implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "citation_editor";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Citation_editor()
	{
	}

	/** Full constructor */
	public Citation_editor(
		Datablock datablock,
		java.lang.String citation_id,
		java.lang.String name,
		java.lang.Integer ordinal)
	{
		this.datablock = datablock;
		this.citation_id = citation_id;
		this.name = name;
		this.ordinal = ordinal;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Citation_editor");
		sb.append("\n");
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (ordinal != null)
		{
			sb.append("ordinal = ");
			sb.append(ordinal);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		citation_id = null;
		name = null;
		ordinal = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Citation_editor)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:citation_editor>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (ordinal != null) ow.write(indent + " <PDBx:ordinal>" + ordinal + "</PDBx:ordinal>\n");
			ow.write(indent + "</PDBx:citation_editor>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
