package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the COMPUTING category record details about the
 *  computer programs used in the crystal structure analysis.
 *  
 *  Data items in this category would not, in general, be used in
 *  a macromolecular CIF.  The category SOFTWARE, which allows
 *  a more detailed description of computer programs and
 *  their attributes to be given, would be used instead.
 *  
 * <pre>
 *  Example 1 - Rodr\'iguez-Romera, Ruiz-P\'erez & Solans [Acta
 *  Cryst. (1996), C52, 1415-1417].
 *  <PDBx:computingCategory>
 *  <PDBx:computing>
 *  <PDBx:data_collection>CAD-4 (Enraf-Nonius, 1989)</PDBx:data_collection>
 *  <PDBx:cell_refinement>CAD-4 (Enraf-Nonius, 1989)</PDBx:cell_refinement>
 *  <PDBx:data_reduction>CFEO (Solans, 1978)</PDBx:data_reduction>
 *  <PDBx:structure_solution>SHELXS86 (Sheldrick, 1990)</PDBx:structure_solution>
 *  <PDBx:structure_refinement>SHELXL93 (Sheldrick, 1993)</PDBx:structure_refinement>
 *  <PDBx:molecular_graphics>ORTEPII (Johnson, 1976)</PDBx:molecular_graphics>
 *  <PDBx:publication_material>PARST (Nardelli, 1983)</PDBx:publication_material>
 *  </PDBx:computing>
 *  </PDBx:computingCategory>
 * </pre>
 */
public class Computing extends org.pdb.beans.Computing implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "computing";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Computing()
	{
	}

	/** Full constructor */
	public Computing(
		Datablock datablock,
		java.lang.String cell_refinement,
		java.lang.String data_collection,
		java.lang.String data_reduction,
		java.lang.String entry_id,
		java.lang.String molecular_graphics,
		java.lang.String pdbx_data_reduction_ds,
		java.lang.String pdbx_data_reduction_ii,
		java.lang.String pdbx_structure_refinement_method,
		java.lang.String publication_material,
		java.lang.String structure_refinement,
		java.lang.String structure_solution)
	{
		this.datablock = datablock;
		this.cell_refinement = cell_refinement;
		this.data_collection = data_collection;
		this.data_reduction = data_reduction;
		this.entry_id = entry_id;
		this.molecular_graphics = molecular_graphics;
		this.pdbx_data_reduction_ds = pdbx_data_reduction_ds;
		this.pdbx_data_reduction_ii = pdbx_data_reduction_ii;
		this.pdbx_structure_refinement_method = pdbx_structure_refinement_method;
		this.publication_material = publication_material;
		this.structure_refinement = structure_refinement;
		this.structure_solution = structure_solution;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Computing");
		sb.append("\n");
		if (cell_refinement != null)
		{
			sb.append("cell_refinement = ");
			sb.append(cell_refinement);
			sb.append('\n');
		}
		if (data_collection != null)
		{
			sb.append("data_collection = ");
			sb.append(data_collection);
			sb.append('\n');
		}
		if (data_reduction != null)
		{
			sb.append("data_reduction = ");
			sb.append(data_reduction);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (molecular_graphics != null)
		{
			sb.append("molecular_graphics = ");
			sb.append(molecular_graphics);
			sb.append('\n');
		}
		if (pdbx_data_reduction_ds != null)
		{
			sb.append("pdbx_data_reduction_ds = ");
			sb.append(pdbx_data_reduction_ds);
			sb.append('\n');
		}
		if (pdbx_data_reduction_ii != null)
		{
			sb.append("pdbx_data_reduction_ii = ");
			sb.append(pdbx_data_reduction_ii);
			sb.append('\n');
		}
		if (pdbx_structure_refinement_method != null)
		{
			sb.append("pdbx_structure_refinement_method = ");
			sb.append(pdbx_structure_refinement_method);
			sb.append('\n');
		}
		if (publication_material != null)
		{
			sb.append("publication_material = ");
			sb.append(publication_material);
			sb.append('\n');
		}
		if (structure_refinement != null)
		{
			sb.append("structure_refinement = ");
			sb.append(structure_refinement);
			sb.append('\n');
		}
		if (structure_solution != null)
		{
			sb.append("structure_solution = ");
			sb.append(structure_solution);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		cell_refinement = null;
		data_collection = null;
		data_reduction = null;
		entry_id = null;
		molecular_graphics = null;
		pdbx_data_reduction_ds = null;
		pdbx_data_reduction_ii = null;
		pdbx_structure_refinement_method = null;
		publication_material = null;
		structure_refinement = null;
		structure_solution = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Computing)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:computing>\n");
			if (cell_refinement != null) ow.write(indent + " <PDBx:cell_refinement>" + cell_refinement + "</PDBx:cell_refinement>\n");
			if (data_collection != null) ow.write(indent + " <PDBx:data_collection>" + data_collection + "</PDBx:data_collection>\n");
			if (data_reduction != null) ow.write(indent + " <PDBx:data_reduction>" + data_reduction + "</PDBx:data_reduction>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (molecular_graphics != null) ow.write(indent + " <PDBx:molecular_graphics>" + molecular_graphics + "</PDBx:molecular_graphics>\n");
			if (pdbx_data_reduction_ds != null) ow.write(indent + " <PDBx:pdbx_data_reduction_ds>" + pdbx_data_reduction_ds + "</PDBx:pdbx_data_reduction_ds>\n");
			if (pdbx_data_reduction_ii != null) ow.write(indent + " <PDBx:pdbx_data_reduction_ii>" + pdbx_data_reduction_ii + "</PDBx:pdbx_data_reduction_ii>\n");
			if (pdbx_structure_refinement_method != null) ow.write(indent + " <PDBx:pdbx_structure_refinement_method>" + pdbx_structure_refinement_method + "</PDBx:pdbx_structure_refinement_method>\n");
			if (publication_material != null) ow.write(indent + " <PDBx:publication_material>" + publication_material + "</PDBx:publication_material>\n");
			if (structure_refinement != null) ow.write(indent + " <PDBx:structure_refinement>" + structure_refinement + "</PDBx:structure_refinement>\n");
			if (structure_solution != null) ow.write(indent + " <PDBx:structure_solution>" + structure_solution + "</PDBx:structure_solution>\n");
			ow.write(indent + "</PDBx:computing>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
