package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DATABASE_PDB_REV category record details
 *  about the history of the data block as archived by the Protein
 *  Data Bank (PDB).
 *  
 *  These data items are assigned by the PDB database managers and
 *  should only appear in a data block if they originate from that
 *  source.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:database_PDB_revCategory>
 *  <PDBx:database_PDB_rev num="1">
 *  <PDBx:author_name>Fitzgerald, Paula M.D</PDBx:author_name>
 *  <PDBx:date>1991-10-15</PDBx:date>
 *  <PDBx:date_original>1990-04-30</PDBx:date_original>
 *  <PDBx:status>full release</PDBx:status>
 *  <PDBx:mod_type>0</PDBx:mod_type>
 *  </PDBx:database_PDB_rev>
 *  </PDBx:database_PDB_revCategory>
 * </pre>
 */
public class Database_PDB_rev extends org.pdb.beans.Database_PDB_rev implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "database_PDB_rev";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Database_PDB_rev()
	{
	}

	/** Full constructor */
	public Database_PDB_rev(
		Datablock datablock,
		java.lang.String author_name,
		java.util.Date date,
		java.util.Date date_original,
		java.lang.Integer mod_type,
		java.lang.Integer num,
		java.lang.String replaced_by,
		java.lang.String replaces,
		java.lang.String status)
	{
		this.datablock = datablock;
		this.author_name = author_name;
		this.date = date;
		this.date_original = date_original;
		this.mod_type = mod_type;
		this.num = num;
		this.replaced_by = replaced_by;
		this.replaces = replaces;
		this.status = status;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Database_PDB_rev");
		sb.append("\n");
		if (author_name != null)
		{
			sb.append("author_name = ");
			sb.append(author_name);
			sb.append('\n');
		}
		if (date != null)
		{
			sb.append("date = ");
			sb.append(date);
			sb.append('\n');
		}
		if (date_original != null)
		{
			sb.append("date_original = ");
			sb.append(date_original);
			sb.append('\n');
		}
		if (mod_type != null)
		{
			sb.append("mod_type = ");
			sb.append(mod_type);
			sb.append('\n');
		}
		if (num != null)
		{
			sb.append("num = ");
			sb.append(num);
			sb.append('\n');
		}
		if (replaced_by != null)
		{
			sb.append("replaced_by = ");
			sb.append(replaced_by);
			sb.append('\n');
		}
		if (replaces != null)
		{
			sb.append("replaces = ");
			sb.append(replaces);
			sb.append('\n');
		}
		if (status != null)
		{
			sb.append("status = ");
			sb.append(status);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		author_name = null;
		date = null;
		date_original = null;
		mod_type = null;
		num = null;
		replaced_by = null;
		replaces = null;
		status = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Database_PDB_rev)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:database_PDB_rev>\n");
			if (author_name != null) ow.write(indent + " <PDBx:author_name>" + author_name + "</PDBx:author_name>\n");
			if (date != null) ow.write(indent + " <PDBx:date>" + date + "</PDBx:date>\n");
			if (date_original != null) ow.write(indent + " <PDBx:date_original>" + date_original + "</PDBx:date_original>\n");
			if (mod_type != null) ow.write(indent + " <PDBx:mod_type>" + mod_type + "</PDBx:mod_type>\n");
			if (num != null) ow.write(indent + " <PDBx:num>" + num + "</PDBx:num>\n");
			if (replaced_by != null) ow.write(indent + " <PDBx:replaced_by>" + replaced_by + "</PDBx:replaced_by>\n");
			if (replaces != null) ow.write(indent + " <PDBx:replaces>" + replaces + "</PDBx:replaces>\n");
			if (status != null) ow.write(indent + " <PDBx:status>" + status + "</PDBx:status>\n");
			ow.write(indent + "</PDBx:database_PDB_rev>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
