package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN category record details about the
 *  diffraction data and their measurement.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrnCategory>
 *  <PDBx:diffrn id="Set1">
 *  <PDBx:ambient_temp>293(3).</PDBx:ambient_temp>
 *  <PDBx:ambient_environment> Mother liquor from the reservoir of the vapor diffusion experiment, mounted in room air</PDBx:ambient_environment>
 *  <PDBx:crystal_support> 0.7 mm glass capillary, sealed with dental wax</PDBx:crystal_support>
 *  <PDBx:crystal_treatment> Equilibrated in rotating anode radiation enclosure for
 *  18 hours prior to beginning of data collection</PDBx:crystal_treatment>
 *  </PDBx:diffrn>
 *  </PDBx:diffrnCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer [(1991).
 *  Acta Cryst. C47, 2276-2277].
 *  <PDBx:diffrnCategory>
 *  <PDBx:diffrn id="d1">
 *  <PDBx:details> \q scan width (1.0 + 0.14tan\q)\&#37;, \q scan rate 1.2\&#37; per
 *  min. Background counts for 5 sec on each side every scan.</PDBx:details>
 *  <PDBx:ambient_temp>293.</PDBx:ambient_temp>
 *  </PDBx:diffrn>
 *  </PDBx:diffrnCategory>
 * </pre>
 */
public class Diffrn extends org.pdb.beans.Diffrn implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn()
	{
	}

	/** Full constructor */
	public Diffrn(
		Datablock datablock,
		java.lang.String ambient_environment,
		java.lang.Float ambient_pressure,
		java.lang.Float ambient_pressure_esd,
		java.lang.Float ambient_pressure_gt,
		java.lang.Float ambient_pressure_lt,
		java.lang.Float ambient_temp,
		java.lang.String ambient_temp_details,
		java.lang.Float ambient_temp_esd,
		java.lang.Float ambient_temp_gt,
		java.lang.Float ambient_temp_lt,
		java.lang.String crystal_id,
		java.lang.String crystal_support,
		java.lang.String crystal_treatment,
		java.lang.String details,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.ambient_environment = ambient_environment;
		this.ambient_pressure = ambient_pressure;
		this.ambient_pressure_esd = ambient_pressure_esd;
		this.ambient_pressure_gt = ambient_pressure_gt;
		this.ambient_pressure_lt = ambient_pressure_lt;
		this.ambient_temp = ambient_temp;
		this.ambient_temp_details = ambient_temp_details;
		this.ambient_temp_esd = ambient_temp_esd;
		this.ambient_temp_gt = ambient_temp_gt;
		this.ambient_temp_lt = ambient_temp_lt;
		this.crystal_id = crystal_id;
		this.crystal_support = crystal_support;
		this.crystal_treatment = crystal_treatment;
		this.details = details;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn");
		sb.append("\n");
		if (ambient_environment != null)
		{
			sb.append("ambient_environment = ");
			sb.append(ambient_environment);
			sb.append('\n');
		}
		if (ambient_pressure != null)
		{
			sb.append("ambient_pressure = ");
			sb.append(ambient_pressure);
			sb.append('\n');
		}
		if (ambient_pressure_esd != null)
		{
			sb.append("ambient_pressure_esd = ");
			sb.append(ambient_pressure_esd);
			sb.append('\n');
		}
		if (ambient_pressure_gt != null)
		{
			sb.append("ambient_pressure_gt = ");
			sb.append(ambient_pressure_gt);
			sb.append('\n');
		}
		if (ambient_pressure_lt != null)
		{
			sb.append("ambient_pressure_lt = ");
			sb.append(ambient_pressure_lt);
			sb.append('\n');
		}
		if (ambient_temp != null)
		{
			sb.append("ambient_temp = ");
			sb.append(ambient_temp);
			sb.append('\n');
		}
		if (ambient_temp_details != null)
		{
			sb.append("ambient_temp_details = ");
			sb.append(ambient_temp_details);
			sb.append('\n');
		}
		if (ambient_temp_esd != null)
		{
			sb.append("ambient_temp_esd = ");
			sb.append(ambient_temp_esd);
			sb.append('\n');
		}
		if (ambient_temp_gt != null)
		{
			sb.append("ambient_temp_gt = ");
			sb.append(ambient_temp_gt);
			sb.append('\n');
		}
		if (ambient_temp_lt != null)
		{
			sb.append("ambient_temp_lt = ");
			sb.append(ambient_temp_lt);
			sb.append('\n');
		}
		if (crystal_id != null)
		{
			sb.append("crystal_id = ");
			sb.append(crystal_id);
			sb.append('\n');
		}
		if (crystal_support != null)
		{
			sb.append("crystal_support = ");
			sb.append(crystal_support);
			sb.append('\n');
		}
		if (crystal_treatment != null)
		{
			sb.append("crystal_treatment = ");
			sb.append(crystal_treatment);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		ambient_environment = null;
		ambient_pressure = null;
		ambient_pressure_esd = null;
		ambient_pressure_gt = null;
		ambient_pressure_lt = null;
		ambient_temp = null;
		ambient_temp_details = null;
		ambient_temp_esd = null;
		ambient_temp_gt = null;
		ambient_temp_lt = null;
		crystal_id = null;
		crystal_support = null;
		crystal_treatment = null;
		details = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn>\n");
			if (ambient_environment != null) ow.write(indent + " <PDBx:ambient_environment>" + ambient_environment + "</PDBx:ambient_environment>\n");
			if (ambient_pressure != null) ow.write(indent + " <PDBx:ambient_pressure>" + ambient_pressure + "</PDBx:ambient_pressure>\n");
			if (ambient_pressure_esd != null) ow.write(indent + " <PDBx:ambient_pressure_esd>" + ambient_pressure_esd + "</PDBx:ambient_pressure_esd>\n");
			if (ambient_pressure_gt != null) ow.write(indent + " <PDBx:ambient_pressure_gt>" + ambient_pressure_gt + "</PDBx:ambient_pressure_gt>\n");
			if (ambient_pressure_lt != null) ow.write(indent + " <PDBx:ambient_pressure_lt>" + ambient_pressure_lt + "</PDBx:ambient_pressure_lt>\n");
			if (ambient_temp != null) ow.write(indent + " <PDBx:ambient_temp>" + ambient_temp + "</PDBx:ambient_temp>\n");
			if (ambient_temp_details != null) ow.write(indent + " <PDBx:ambient_temp_details>" + ambient_temp_details + "</PDBx:ambient_temp_details>\n");
			if (ambient_temp_esd != null) ow.write(indent + " <PDBx:ambient_temp_esd>" + ambient_temp_esd + "</PDBx:ambient_temp_esd>\n");
			if (ambient_temp_gt != null) ow.write(indent + " <PDBx:ambient_temp_gt>" + ambient_temp_gt + "</PDBx:ambient_temp_gt>\n");
			if (ambient_temp_lt != null) ow.write(indent + " <PDBx:ambient_temp_lt>" + ambient_temp_lt + "</PDBx:ambient_temp_lt>\n");
			if (crystal_id != null) ow.write(indent + " <PDBx:crystal_id>" + crystal_id + "</PDBx:crystal_id>\n");
			if (crystal_support != null) ow.write(indent + " <PDBx:crystal_support>" + crystal_support + "</PDBx:crystal_support>\n");
			if (crystal_treatment != null) ow.write(indent + " <PDBx:crystal_treatment>" + crystal_treatment + "</PDBx:crystal_treatment>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:diffrn>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
