package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_DETECTOR category describe the
 *  detector used to measure the scattered radiation, including
 *  any analyser and post-sample collimation.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrn_detectorCategory>
 *  <PDBx:diffrn_detector diffrn_id="d1">
 *  <PDBx:detector>multiwire</PDBx:detector>
 *  <PDBx:type>Siemens</PDBx:type>
 *  </PDBx:diffrn_detector>
 *  </PDBx:diffrn_detectorCategory>
 * </pre>
 */
public class Diffrn_detector extends org.pdb.beans.Diffrn_detector implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_detector";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_detector()
	{
	}

	/** Full constructor */
	public Diffrn_detector(
		Datablock datablock,
		java.lang.Float area_resol_mean,
		java.lang.String details,
		java.lang.String detector,
		java.lang.String diffrn_id,
		java.lang.Float dtime,
		java.lang.String pdbx_collection_date,
		java.lang.Float pdbx_collection_time_total,
		java.lang.Integer pdbx_frames_total,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.area_resol_mean = area_resol_mean;
		this.details = details;
		this.detector = detector;
		this.diffrn_id = diffrn_id;
		this.dtime = dtime;
		this.pdbx_collection_date = pdbx_collection_date;
		this.pdbx_collection_time_total = pdbx_collection_time_total;
		this.pdbx_frames_total = pdbx_frames_total;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_detector");
		sb.append("\n");
		if (area_resol_mean != null)
		{
			sb.append("area_resol_mean = ");
			sb.append(area_resol_mean);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (detector != null)
		{
			sb.append("detector = ");
			sb.append(detector);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (dtime != null)
		{
			sb.append("dtime = ");
			sb.append(dtime);
			sb.append('\n');
		}
		if (pdbx_collection_date != null)
		{
			sb.append("pdbx_collection_date = ");
			sb.append(pdbx_collection_date);
			sb.append('\n');
		}
		if (pdbx_collection_time_total != null)
		{
			sb.append("pdbx_collection_time_total = ");
			sb.append(pdbx_collection_time_total);
			sb.append('\n');
		}
		if (pdbx_frames_total != null)
		{
			sb.append("pdbx_frames_total = ");
			sb.append(pdbx_frames_total);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		area_resol_mean = null;
		details = null;
		detector = null;
		diffrn_id = null;
		dtime = null;
		pdbx_collection_date = null;
		pdbx_collection_time_total = null;
		pdbx_frames_total = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_detector)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_detector>\n");
			if (area_resol_mean != null) ow.write(indent + " <PDBx:area_resol_mean>" + area_resol_mean + "</PDBx:area_resol_mean>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (detector != null) ow.write(indent + " <PDBx:detector>" + detector + "</PDBx:detector>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (dtime != null) ow.write(indent + " <PDBx:dtime>" + dtime + "</PDBx:dtime>\n");
			if (pdbx_collection_date != null) ow.write(indent + " <PDBx:pdbx_collection_date>" + pdbx_collection_date + "</PDBx:pdbx_collection_date>\n");
			if (pdbx_collection_time_total != null) ow.write(indent + " <PDBx:pdbx_collection_time_total>" + pdbx_collection_time_total + "</PDBx:pdbx_collection_time_total>\n");
			if (pdbx_frames_total != null) ow.write(indent + " <PDBx:pdbx_frames_total>" + pdbx_frames_total + "</PDBx:pdbx_frames_total>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:diffrn_detector>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
