package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_ORIENT_MATRIX category record details
 *  about the orientation matrix used in the measurement of the
 *  diffraction data.
 *  
 * <pre>
 *  Example 1 - based on CAD-4 diffractometer data obtained for
 *  Yb(S-C5H4N)2(THF)4.
 *  <PDBx:diffrn_orient_matrixCategory>
 *  <PDBx:diffrn_orient_matrix diffrn_id="set1">
 *  <PDBx:type> reciprocal axis matrix, multiplies hkl vector to generate
 *  diffractometer xyz vector and diffractometer angles</PDBx:type>
 *  <PDBx:UB11>-0.071479</PDBx:UB11>
 *  <PDBx:UB12>0.020208</PDBx:UB12>
 *  <PDBx:UB13>0.039076</PDBx:UB13>
 *  <PDBx:UB21>0.035372</PDBx:UB21>
 *  <PDBx:UB22>0.056209</PDBx:UB22>
 *  <PDBx:UB23>0.078324</PDBx:UB23>
 *  <PDBx:UB31>-0.007470</PDBx:UB31>
 *  <PDBx:UB32>0.067854</PDBx:UB32>
 *  <PDBx:UB33>-0.017832</PDBx:UB33>
 *  </PDBx:diffrn_orient_matrix>
 *  </PDBx:diffrn_orient_matrixCategory>
 * </pre>
 */
public class Diffrn_orient_matrix extends org.pdb.beans.Diffrn_orient_matrix implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_orient_matrix";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_orient_matrix()
	{
	}

	/** Full constructor */
	public Diffrn_orient_matrix(
		Datablock datablock,
		java.lang.Float UB11,
		java.lang.Float UB12,
		java.lang.Float UB13,
		java.lang.Float UB21,
		java.lang.Float UB22,
		java.lang.Float UB23,
		java.lang.Float UB31,
		java.lang.Float UB32,
		java.lang.Float UB33,
		java.lang.String diffrn_id,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.UB11 = UB11;
		this.UB12 = UB12;
		this.UB13 = UB13;
		this.UB21 = UB21;
		this.UB22 = UB22;
		this.UB23 = UB23;
		this.UB31 = UB31;
		this.UB32 = UB32;
		this.UB33 = UB33;
		this.diffrn_id = diffrn_id;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_orient_matrix");
		sb.append("\n");
		if (UB11 != null)
		{
			sb.append("UB11 = ");
			sb.append(UB11);
			sb.append('\n');
		}
		if (UB12 != null)
		{
			sb.append("UB12 = ");
			sb.append(UB12);
			sb.append('\n');
		}
		if (UB13 != null)
		{
			sb.append("UB13 = ");
			sb.append(UB13);
			sb.append('\n');
		}
		if (UB21 != null)
		{
			sb.append("UB21 = ");
			sb.append(UB21);
			sb.append('\n');
		}
		if (UB22 != null)
		{
			sb.append("UB22 = ");
			sb.append(UB22);
			sb.append('\n');
		}
		if (UB23 != null)
		{
			sb.append("UB23 = ");
			sb.append(UB23);
			sb.append('\n');
		}
		if (UB31 != null)
		{
			sb.append("UB31 = ");
			sb.append(UB31);
			sb.append('\n');
		}
		if (UB32 != null)
		{
			sb.append("UB32 = ");
			sb.append(UB32);
			sb.append('\n');
		}
		if (UB33 != null)
		{
			sb.append("UB33 = ");
			sb.append(UB33);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		UB11 = null;
		UB12 = null;
		UB13 = null;
		UB21 = null;
		UB22 = null;
		UB23 = null;
		UB31 = null;
		UB32 = null;
		UB33 = null;
		diffrn_id = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_orient_matrix)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_orient_matrix>\n");
			if (UB11 != null) ow.write(indent + " <PDBx:UB11>" + UB11 + "</PDBx:UB11>\n");
			if (UB12 != null) ow.write(indent + " <PDBx:UB12>" + UB12 + "</PDBx:UB12>\n");
			if (UB13 != null) ow.write(indent + " <PDBx:UB13>" + UB13 + "</PDBx:UB13>\n");
			if (UB21 != null) ow.write(indent + " <PDBx:UB21>" + UB21 + "</PDBx:UB21>\n");
			if (UB22 != null) ow.write(indent + " <PDBx:UB22>" + UB22 + "</PDBx:UB22>\n");
			if (UB23 != null) ow.write(indent + " <PDBx:UB23>" + UB23 + "</PDBx:UB23>\n");
			if (UB31 != null) ow.write(indent + " <PDBx:UB31>" + UB31 + "</PDBx:UB31>\n");
			if (UB32 != null) ow.write(indent + " <PDBx:UB32>" + UB32 + "</PDBx:UB32>\n");
			if (UB33 != null) ow.write(indent + " <PDBx:UB33>" + UB33 + "</PDBx:UB33>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:diffrn_orient_matrix>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
