package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_ORIENT_REFLN category record details
 *  about the reflections that define the orientation matrix used in
 *  the measurement of the diffraction intensities.
 *  
 * <pre>
 *  Example 1 - based on CAD-4 diffractometer data obtained for
 *  Yb(S-C5H4N)2(THF)4.
 *  <PDBx:diffrn_orient_reflnCategory>
 *  <PDBx:diffrn_orient_refln diffrn_id="myset1" index_h="2" index_k="0" index_l="2">
 *  <PDBx:angle_chi>-28.45</PDBx:angle_chi>
 *  <PDBx:angle_kappa>-11.32</PDBx:angle_kappa>
 *  <PDBx:angle_omega>5.33</PDBx:angle_omega>
 *  <PDBx:angle_phi>101.78</PDBx:angle_phi>
 *  <PDBx:angle_psi>0.00</PDBx:angle_psi>
 *  <PDBx:angle_theta>10.66</PDBx:angle_theta>
 *  </PDBx:diffrn_orient_refln>
 *  </PDBx:diffrn_orient_reflnCategory>
 * </pre>
 */
public class Diffrn_orient_refln extends org.pdb.beans.Diffrn_orient_refln implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_orient_refln";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_orient_refln()
	{
	}

	/** Full constructor */
	public Diffrn_orient_refln(
		Datablock datablock,
		java.lang.Float angle_chi,
		java.lang.Float angle_kappa,
		java.lang.Float angle_omega,
		java.lang.Float angle_phi,
		java.lang.Float angle_psi,
		java.lang.Float angle_theta,
		java.lang.String diffrn_id,
		java.lang.Integer index_h,
		java.lang.Integer index_k,
		java.lang.Integer index_l)
	{
		this.datablock = datablock;
		this.angle_chi = angle_chi;
		this.angle_kappa = angle_kappa;
		this.angle_omega = angle_omega;
		this.angle_phi = angle_phi;
		this.angle_psi = angle_psi;
		this.angle_theta = angle_theta;
		this.diffrn_id = diffrn_id;
		this.index_h = index_h;
		this.index_k = index_k;
		this.index_l = index_l;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_orient_refln");
		sb.append("\n");
		if (angle_chi != null)
		{
			sb.append("angle_chi = ");
			sb.append(angle_chi);
			sb.append('\n');
		}
		if (angle_kappa != null)
		{
			sb.append("angle_kappa = ");
			sb.append(angle_kappa);
			sb.append('\n');
		}
		if (angle_omega != null)
		{
			sb.append("angle_omega = ");
			sb.append(angle_omega);
			sb.append('\n');
		}
		if (angle_phi != null)
		{
			sb.append("angle_phi = ");
			sb.append(angle_phi);
			sb.append('\n');
		}
		if (angle_psi != null)
		{
			sb.append("angle_psi = ");
			sb.append(angle_psi);
			sb.append('\n');
		}
		if (angle_theta != null)
		{
			sb.append("angle_theta = ");
			sb.append(angle_theta);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (index_h != null)
		{
			sb.append("index_h = ");
			sb.append(index_h);
			sb.append('\n');
		}
		if (index_k != null)
		{
			sb.append("index_k = ");
			sb.append(index_k);
			sb.append('\n');
		}
		if (index_l != null)
		{
			sb.append("index_l = ");
			sb.append(index_l);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		angle_chi = null;
		angle_kappa = null;
		angle_omega = null;
		angle_phi = null;
		angle_psi = null;
		angle_theta = null;
		diffrn_id = null;
		index_h = null;
		index_k = null;
		index_l = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_orient_refln)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_orient_refln>\n");
			if (angle_chi != null) ow.write(indent + " <PDBx:angle_chi>" + angle_chi + "</PDBx:angle_chi>\n");
			if (angle_kappa != null) ow.write(indent + " <PDBx:angle_kappa>" + angle_kappa + "</PDBx:angle_kappa>\n");
			if (angle_omega != null) ow.write(indent + " <PDBx:angle_omega>" + angle_omega + "</PDBx:angle_omega>\n");
			if (angle_phi != null) ow.write(indent + " <PDBx:angle_phi>" + angle_phi + "</PDBx:angle_phi>\n");
			if (angle_psi != null) ow.write(indent + " <PDBx:angle_psi>" + angle_psi + "</PDBx:angle_psi>\n");
			if (angle_theta != null) ow.write(indent + " <PDBx:angle_theta>" + angle_theta + "</PDBx:angle_theta>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (index_h != null) ow.write(indent + " <PDBx:index_h>" + index_h + "</PDBx:index_h>\n");
			if (index_k != null) ow.write(indent + " <PDBx:index_k>" + index_k + "</PDBx:index_k>\n");
			if (index_l != null) ow.write(indent + " <PDBx:index_l>" + index_l + "</PDBx:index_l>\n");
			ow.write(indent + "</PDBx:diffrn_orient_refln>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
