package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_RADIATION category describe
 *  the radiation used in measuring the diffraction intensities,
 *  its collimation and monochromatization before the sample.
 *  
 *  Post-sample treatment of the beam is described by data
 *  items in the DIFFRN_DETECTOR category.
 *  
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrn_radiationCategory>
 *  <PDBx:diffrn_radiation diffrn_id="set1">
 *  <PDBx:collimation>0.3 mm double pinhole</PDBx:collimation>
 *  <PDBx:monochromator>graphite</PDBx:monochromator>
 *  <PDBx:type>Cu K\a</PDBx:type>
 *  <PDBx:wavelength_id>1</PDBx:wavelength_id>
 *  </PDBx:diffrn_radiation>
 *  </PDBx:diffrn_radiationCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:diffrn_radiationCategory>
 *  <PDBx:diffrn_radiation>
 *  <PDBx:wavelength_id>1</PDBx:wavelength_id>
 *  <PDBx:type>Cu K\a</PDBx:type>
 *  <PDBx:monochromator>graphite</PDBx:monochromator>
 *  </PDBx:diffrn_radiation>
 *  </PDBx:diffrn_radiationCategory>
 * </pre>
 */
public class Diffrn_radiation extends org.pdb.beans.Diffrn_radiation implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_radiation";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_radiation()
	{
	}

	/** Full constructor */
	public Diffrn_radiation(
		Datablock datablock,
		java.lang.String collimation,
		java.lang.String diffrn_id,
		java.lang.Float filter_edge,
		java.lang.Float inhomogeneity,
		java.lang.String monochromator,
		java.lang.String pdbx_analyzer,
		java.lang.String pdbx_diffrn_protocol,
		java.lang.String pdbx_monochromatic_or_laue_m_l,
		java.lang.String pdbx_wavelength,
		java.lang.String pdbx_wavelength_list,
		java.lang.Float polarisn_norm,
		java.lang.Float polarisn_ratio,
		java.lang.String probe,
		java.lang.String type,
		java.lang.String wavelength_id,
		java.lang.String xray_symbol)
	{
		this.datablock = datablock;
		this.collimation = collimation;
		this.diffrn_id = diffrn_id;
		this.filter_edge = filter_edge;
		this.inhomogeneity = inhomogeneity;
		this.monochromator = monochromator;
		this.pdbx_analyzer = pdbx_analyzer;
		this.pdbx_diffrn_protocol = pdbx_diffrn_protocol;
		this.pdbx_monochromatic_or_laue_m_l = pdbx_monochromatic_or_laue_m_l;
		this.pdbx_wavelength = pdbx_wavelength;
		this.pdbx_wavelength_list = pdbx_wavelength_list;
		this.polarisn_norm = polarisn_norm;
		this.polarisn_ratio = polarisn_ratio;
		this.probe = probe;
		this.type = type;
		this.wavelength_id = wavelength_id;
		this.xray_symbol = xray_symbol;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_radiation");
		sb.append("\n");
		if (collimation != null)
		{
			sb.append("collimation = ");
			sb.append(collimation);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (filter_edge != null)
		{
			sb.append("filter_edge = ");
			sb.append(filter_edge);
			sb.append('\n');
		}
		if (inhomogeneity != null)
		{
			sb.append("inhomogeneity = ");
			sb.append(inhomogeneity);
			sb.append('\n');
		}
		if (monochromator != null)
		{
			sb.append("monochromator = ");
			sb.append(monochromator);
			sb.append('\n');
		}
		if (pdbx_analyzer != null)
		{
			sb.append("pdbx_analyzer = ");
			sb.append(pdbx_analyzer);
			sb.append('\n');
		}
		if (pdbx_diffrn_protocol != null)
		{
			sb.append("pdbx_diffrn_protocol = ");
			sb.append(pdbx_diffrn_protocol);
			sb.append('\n');
		}
		if (pdbx_monochromatic_or_laue_m_l != null)
		{
			sb.append("pdbx_monochromatic_or_laue_m_l = ");
			sb.append(pdbx_monochromatic_or_laue_m_l);
			sb.append('\n');
		}
		if (pdbx_wavelength != null)
		{
			sb.append("pdbx_wavelength = ");
			sb.append(pdbx_wavelength);
			sb.append('\n');
		}
		if (pdbx_wavelength_list != null)
		{
			sb.append("pdbx_wavelength_list = ");
			sb.append(pdbx_wavelength_list);
			sb.append('\n');
		}
		if (polarisn_norm != null)
		{
			sb.append("polarisn_norm = ");
			sb.append(polarisn_norm);
			sb.append('\n');
		}
		if (polarisn_ratio != null)
		{
			sb.append("polarisn_ratio = ");
			sb.append(polarisn_ratio);
			sb.append('\n');
		}
		if (probe != null)
		{
			sb.append("probe = ");
			sb.append(probe);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		if (wavelength_id != null)
		{
			sb.append("wavelength_id = ");
			sb.append(wavelength_id);
			sb.append('\n');
		}
		if (xray_symbol != null)
		{
			sb.append("xray_symbol = ");
			sb.append(xray_symbol);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		collimation = null;
		diffrn_id = null;
		filter_edge = null;
		inhomogeneity = null;
		monochromator = null;
		pdbx_analyzer = null;
		pdbx_diffrn_protocol = null;
		pdbx_monochromatic_or_laue_m_l = null;
		pdbx_wavelength = null;
		pdbx_wavelength_list = null;
		polarisn_norm = null;
		polarisn_ratio = null;
		probe = null;
		type = null;
		wavelength_id = null;
		xray_symbol = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_radiation)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_radiation>\n");
			if (collimation != null) ow.write(indent + " <PDBx:collimation>" + collimation + "</PDBx:collimation>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (filter_edge != null) ow.write(indent + " <PDBx:filter_edge>" + filter_edge + "</PDBx:filter_edge>\n");
			if (inhomogeneity != null) ow.write(indent + " <PDBx:inhomogeneity>" + inhomogeneity + "</PDBx:inhomogeneity>\n");
			if (monochromator != null) ow.write(indent + " <PDBx:monochromator>" + monochromator + "</PDBx:monochromator>\n");
			if (pdbx_analyzer != null) ow.write(indent + " <PDBx:pdbx_analyzer>" + pdbx_analyzer + "</PDBx:pdbx_analyzer>\n");
			if (pdbx_diffrn_protocol != null) ow.write(indent + " <PDBx:pdbx_diffrn_protocol>" + pdbx_diffrn_protocol + "</PDBx:pdbx_diffrn_protocol>\n");
			if (pdbx_monochromatic_or_laue_m_l != null) ow.write(indent + " <PDBx:pdbx_monochromatic_or_laue_m_l>" + pdbx_monochromatic_or_laue_m_l + "</PDBx:pdbx_monochromatic_or_laue_m_l>\n");
			if (pdbx_wavelength != null) ow.write(indent + " <PDBx:pdbx_wavelength>" + pdbx_wavelength + "</PDBx:pdbx_wavelength>\n");
			if (pdbx_wavelength_list != null) ow.write(indent + " <PDBx:pdbx_wavelength_list>" + pdbx_wavelength_list + "</PDBx:pdbx_wavelength_list>\n");
			if (polarisn_norm != null) ow.write(indent + " <PDBx:polarisn_norm>" + polarisn_norm + "</PDBx:polarisn_norm>\n");
			if (polarisn_ratio != null) ow.write(indent + " <PDBx:polarisn_ratio>" + polarisn_ratio + "</PDBx:polarisn_ratio>\n");
			if (probe != null) ow.write(indent + " <PDBx:probe>" + probe + "</PDBx:probe>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			if (wavelength_id != null) ow.write(indent + " <PDBx:wavelength_id>" + wavelength_id + "</PDBx:wavelength_id>\n");
			if (xray_symbol != null) ow.write(indent + " <PDBx:xray_symbol>" + xray_symbol + "</PDBx:xray_symbol>\n");
			ow.write(indent + "</PDBx:diffrn_radiation>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
