package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_RADIATION_WAVELENGTH category
 *  describe the wavelength of the radiation used to measure the
 *  diffraction intensities. Items may be looped to identify
 *  and assign weights to distinct components of a
 *  polychromatic beam.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrn_radiation_wavelengthCategory>
 *  <PDBx:diffrn_radiation_wavelength id="1">
 *  <PDBx:wavelength>1.54</PDBx:wavelength>
 *  <PDBx:wt>1.0</PDBx:wt>
 *  </PDBx:diffrn_radiation_wavelength>
 *  </PDBx:diffrn_radiation_wavelengthCategory>
 * </pre>
 */
public class Diffrn_radiation_wavelength extends org.pdb.beans.Diffrn_radiation_wavelength implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_radiation_wavelength";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_radiation_wavelength()
	{
	}

	/** Full constructor */
	public Diffrn_radiation_wavelength(
		Datablock datablock,
		java.lang.String id_,
		java.lang.Float wavelength,
		java.lang.Float wt)
	{
		this.datablock = datablock;
		this.id_ = id_;
		this.wavelength = wavelength;
		this.wt = wt;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_radiation_wavelength");
		sb.append("\n");
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (wavelength != null)
		{
			sb.append("wavelength = ");
			sb.append(wavelength);
			sb.append('\n');
		}
		if (wt != null)
		{
			sb.append("wt = ");
			sb.append(wt);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		id_ = null;
		wavelength = null;
		wt = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_radiation_wavelength)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_radiation_wavelength>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (wavelength != null) ow.write(indent + " <PDBx:wavelength>" + wavelength + "</PDBx:wavelength>\n");
			if (wt != null) ow.write(indent + " <PDBx:wt>" + wt + "</PDBx:wt>\n");
			ow.write(indent + "</PDBx:diffrn_radiation_wavelength>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
