package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_REFLNS_CLASS category record details
 *  about the classes of reflections measured in the diffraction
 *  experiment.
 *  
 * <pre>
 *  Example 1 - example corresponding to the one-dimensional incommensurately
 *  modulated structure of K~2~SeO~4~. Each reflection class is
 *  defined by the number m=sum|m~i~|, where the m~i~ are the
 *  integer coefficients that, in addition to h,k,l, index the
 *  corresponding diffraction vector in the basis defined for
 *  the reciprocal lattice.
 *  <PDBx:diffrn_reflns_classCategory>
 *  <PDBx:diffrn_reflns_class code="Main">
 *  <PDBx:number>1580</PDBx:number>
 *  <PDBx:d_res_high>0.551</PDBx:d_res_high>
 *  <PDBx:d_res_low>6.136</PDBx:d_res_low>
 *  <PDBx:av_R_eq>0.015</PDBx:av_R_eq>
 *  <PDBx:description>m=0; main reflections</PDBx:description>
 *  </PDBx:diffrn_reflns_class>
 *  <PDBx:diffrn_reflns_class code="Sat1">
 *  <PDBx:number>1045</PDBx:number>
 *  <PDBx:d_res_high>0.551</PDBx:d_res_high>
 *  <PDBx:d_res_low>6.136</PDBx:d_res_low>
 *  <PDBx:av_R_eq>0.010</PDBx:av_R_eq>
 *  <PDBx:description>m=1; first-order satellites</PDBx:description>
 *  </PDBx:diffrn_reflns_class>
 *  </PDBx:diffrn_reflns_classCategory>
 * </pre>
 */
public class Diffrn_reflns_class extends org.pdb.beans.Diffrn_reflns_class implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_reflns_class";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_reflns_class()
	{
	}

	/** Full constructor */
	public Diffrn_reflns_class(
		Datablock datablock,
		java.lang.Float av_R_eq,
		java.lang.Float av_sgI_over_I,
		java.lang.Float av_uI_over_I,
		java.lang.String code,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.String description,
		java.lang.Integer number)
	{
		this.datablock = datablock;
		this.av_R_eq = av_R_eq;
		this.av_sgI_over_I = av_sgI_over_I;
		this.av_uI_over_I = av_uI_over_I;
		this.code = code;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.description = description;
		this.number = number;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_reflns_class");
		sb.append("\n");
		if (av_R_eq != null)
		{
			sb.append("av_R_eq = ");
			sb.append(av_R_eq);
			sb.append('\n');
		}
		if (av_sgI_over_I != null)
		{
			sb.append("av_sgI_over_I = ");
			sb.append(av_sgI_over_I);
			sb.append('\n');
		}
		if (av_uI_over_I != null)
		{
			sb.append("av_uI_over_I = ");
			sb.append(av_uI_over_I);
			sb.append('\n');
		}
		if (code != null)
		{
			sb.append("code = ");
			sb.append(code);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (description != null)
		{
			sb.append("description = ");
			sb.append(description);
			sb.append('\n');
		}
		if (number != null)
		{
			sb.append("number = ");
			sb.append(number);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		av_R_eq = null;
		av_sgI_over_I = null;
		av_uI_over_I = null;
		code = null;
		d_res_high = null;
		d_res_low = null;
		description = null;
		number = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_reflns_class)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_reflns_class>\n");
			if (av_R_eq != null) ow.write(indent + " <PDBx:av_R_eq>" + av_R_eq + "</PDBx:av_R_eq>\n");
			if (av_sgI_over_I != null) ow.write(indent + " <PDBx:av_sgI_over_I>" + av_sgI_over_I + "</PDBx:av_sgI_over_I>\n");
			if (av_uI_over_I != null) ow.write(indent + " <PDBx:av_uI_over_I>" + av_uI_over_I + "</PDBx:av_uI_over_I>\n");
			if (code != null) ow.write(indent + " <PDBx:code>" + code + "</PDBx:code>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (description != null) ow.write(indent + " <PDBx:description>" + description + "</PDBx:description>\n");
			if (number != null) ow.write(indent + " <PDBx:number>" + number + "</PDBx:number>\n");
			ow.write(indent + "</PDBx:diffrn_reflns_class>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
