package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_SOURCE category record details of
 *  the source of radiation used in the diffraction experiment.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:diffrn_sourceCategory>
 *  <PDBx:diffrn_source diffrn_id="s1">
 *  <PDBx:source>rotating anode</PDBx:source>
 *  <PDBx:type>Rigaku RU-200</PDBx:type>
 *  <PDBx:power>50.</PDBx:power>
 *  <PDBx:current>180.</PDBx:current>
 *  <PDBx:size>8mm x 0.4 mm broad-focus</PDBx:size>
 *  </PDBx:diffrn_source>
 *  </PDBx:diffrn_sourceCategory>
 * </pre>
 */
public class Diffrn_source extends org.pdb.beans.Diffrn_source implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_source";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_source()
	{
	}

	/** Full constructor */
	public Diffrn_source(
		Datablock datablock,
		java.lang.Float current,
		java.lang.String details,
		java.lang.String diffrn_id,
		java.lang.String pdbx_synchrotron_beamline,
		java.lang.String pdbx_synchrotron_site,
		java.lang.String pdbx_wavelength,
		java.lang.String pdbx_wavelength_list,
		java.lang.Float power,
		java.lang.String size,
		java.lang.String source,
		java.lang.Float take_off_angle,
		java.lang.String target,
		java.lang.String type,
		java.lang.Float voltage)
	{
		this.datablock = datablock;
		this.current = current;
		this.details = details;
		this.diffrn_id = diffrn_id;
		this.pdbx_synchrotron_beamline = pdbx_synchrotron_beamline;
		this.pdbx_synchrotron_site = pdbx_synchrotron_site;
		this.pdbx_wavelength = pdbx_wavelength;
		this.pdbx_wavelength_list = pdbx_wavelength_list;
		this.power = power;
		this.size = size;
		this.source = source;
		this.take_off_angle = take_off_angle;
		this.target = target;
		this.type = type;
		this.voltage = voltage;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_source");
		sb.append("\n");
		if (current != null)
		{
			sb.append("current = ");
			sb.append(current);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (pdbx_synchrotron_beamline != null)
		{
			sb.append("pdbx_synchrotron_beamline = ");
			sb.append(pdbx_synchrotron_beamline);
			sb.append('\n');
		}
		if (pdbx_synchrotron_site != null)
		{
			sb.append("pdbx_synchrotron_site = ");
			sb.append(pdbx_synchrotron_site);
			sb.append('\n');
		}
		if (pdbx_wavelength != null)
		{
			sb.append("pdbx_wavelength = ");
			sb.append(pdbx_wavelength);
			sb.append('\n');
		}
		if (pdbx_wavelength_list != null)
		{
			sb.append("pdbx_wavelength_list = ");
			sb.append(pdbx_wavelength_list);
			sb.append('\n');
		}
		if (power != null)
		{
			sb.append("power = ");
			sb.append(power);
			sb.append('\n');
		}
		if (size != null)
		{
			sb.append("size = ");
			sb.append(size);
			sb.append('\n');
		}
		if (source != null)
		{
			sb.append("source = ");
			sb.append(source);
			sb.append('\n');
		}
		if (take_off_angle != null)
		{
			sb.append("take-off_angle = ");
			sb.append(take_off_angle);
			sb.append('\n');
		}
		if (target != null)
		{
			sb.append("target = ");
			sb.append(target);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		if (voltage != null)
		{
			sb.append("voltage = ");
			sb.append(voltage);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		current = null;
		details = null;
		diffrn_id = null;
		pdbx_synchrotron_beamline = null;
		pdbx_synchrotron_site = null;
		pdbx_wavelength = null;
		pdbx_wavelength_list = null;
		power = null;
		size = null;
		source = null;
		take_off_angle = null;
		target = null;
		type = null;
		voltage = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_source)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_source>\n");
			if (current != null) ow.write(indent + " <PDBx:current>" + current + "</PDBx:current>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (pdbx_synchrotron_beamline != null) ow.write(indent + " <PDBx:pdbx_synchrotron_beamline>" + pdbx_synchrotron_beamline + "</PDBx:pdbx_synchrotron_beamline>\n");
			if (pdbx_synchrotron_site != null) ow.write(indent + " <PDBx:pdbx_synchrotron_site>" + pdbx_synchrotron_site + "</PDBx:pdbx_synchrotron_site>\n");
			if (pdbx_wavelength != null) ow.write(indent + " <PDBx:pdbx_wavelength>" + pdbx_wavelength + "</PDBx:pdbx_wavelength>\n");
			if (pdbx_wavelength_list != null) ow.write(indent + " <PDBx:pdbx_wavelength_list>" + pdbx_wavelength_list + "</PDBx:pdbx_wavelength_list>\n");
			if (power != null) ow.write(indent + " <PDBx:power>" + power + "</PDBx:power>\n");
			if (size != null) ow.write(indent + " <PDBx:size>" + size + "</PDBx:size>\n");
			if (source != null) ow.write(indent + " <PDBx:source>" + source + "</PDBx:source>\n");
			if (take_off_angle != null) ow.write(indent + " <PDBx:take-off_angle>" + take_off_angle + "</PDBx:take-off_angle>\n");
			if (target != null) ow.write(indent + " <PDBx:target>" + target + "</PDBx:target>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			if (voltage != null) ow.write(indent + " <PDBx:voltage>" + voltage + "</PDBx:voltage>\n");
			ow.write(indent + "</PDBx:diffrn_source>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
