package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the DIFFRN_STANDARDS category record details
 *  about the set of standard reflections used to monitor intensity
 *  stability during the measurement of diffraction intensities.
 *  
 *  Note that these records describe properties common to the set of
 *  standard reflections, not the standard reflections themselves.
 *  
 * <pre>
 *  Example 1 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:diffrn_standardsCategory>
 *  <PDBx:diffrn_standards diffrn_id="s1">
 *  <PDBx:number>3</PDBx:number>
 *  <PDBx:interval_time>120.</PDBx:interval_time>
 *  <PDBx:decay_>0.</PDBx:decay_>
 *  </PDBx:diffrn_standards>
 *  </PDBx:diffrn_standardsCategory>
 * </pre>
 */
public class Diffrn_standards extends org.pdb.beans.Diffrn_standards implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "diffrn_standards";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Diffrn_standards()
	{
	}

	/** Full constructor */
	public Diffrn_standards(
		Datablock datablock,
		java.lang.Float decay_,
		java.lang.String diffrn_id,
		java.lang.Integer interval_count,
		java.lang.Float interval_time,
		java.lang.Integer number,
		java.lang.Float scale_sigma,
		java.lang.Float scale_u)
	{
		this.datablock = datablock;
		this.decay_ = decay_;
		this.diffrn_id = diffrn_id;
		this.interval_count = interval_count;
		this.interval_time = interval_time;
		this.number = number;
		this.scale_sigma = scale_sigma;
		this.scale_u = scale_u;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Diffrn_standards");
		sb.append("\n");
		if (decay_ != null)
		{
			sb.append("decay_ = ");
			sb.append(decay_);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (interval_count != null)
		{
			sb.append("interval_count = ");
			sb.append(interval_count);
			sb.append('\n');
		}
		if (interval_time != null)
		{
			sb.append("interval_time = ");
			sb.append(interval_time);
			sb.append('\n');
		}
		if (number != null)
		{
			sb.append("number = ");
			sb.append(number);
			sb.append('\n');
		}
		if (scale_sigma != null)
		{
			sb.append("scale_sigma = ");
			sb.append(scale_sigma);
			sb.append('\n');
		}
		if (scale_u != null)
		{
			sb.append("scale_u = ");
			sb.append(scale_u);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		decay_ = null;
		diffrn_id = null;
		interval_count = null;
		interval_time = null;
		number = null;
		scale_sigma = null;
		scale_u = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Diffrn_standards)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:diffrn_standards>\n");
			if (decay_ != null) ow.write(indent + " <PDBx:decay_>" + decay_ + "</PDBx:decay_>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (interval_count != null) ow.write(indent + " <PDBx:interval_count>" + interval_count + "</PDBx:interval_count>\n");
			if (interval_time != null) ow.write(indent + " <PDBx:interval_time>" + interval_time + "</PDBx:interval_time>\n");
			if (number != null) ow.write(indent + " <PDBx:number>" + number + "</PDBx:number>\n");
			if (scale_sigma != null) ow.write(indent + " <PDBx:scale_sigma>" + scale_sigma + "</PDBx:scale_sigma>\n");
			if (scale_u != null) ow.write(indent + " <PDBx:scale_u>" + scale_u + "</PDBx:scale_u>\n");
			ow.write(indent + "</PDBx:diffrn_standards>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
