package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the 3D_FITTING_LIST category
 *  lists the methods of fitting atomic coordinates from a PDB file
 *  into a 3d-em volume map file
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_3d_fitting_listCategory>
 *  <PDBx:em_3d_fitting_list id="1">
 *  <PDBx:pdb_entry_id>1VCQ</PDBx:pdb_entry_id>
 *  </PDBx:em_3d_fitting_list>
 *  </PDBx:em_3d_fitting_listCategory>
 * </pre>
 */
public class Em_3d_fitting_list extends org.pdb.beans.Em_3d_fitting_list implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_3d_fitting_list";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_3d_fitting_list()
	{
	}

	/** Full constructor */
	public Em_3d_fitting_list(
		Datablock datablock,
		java.lang.String _3d_fitting_id,
		java.lang.String id_,
		java.lang.String pdb_chain_id,
		java.lang.String pdb_entry_id)
	{
		this.datablock = datablock;
		this._3d_fitting_id = _3d_fitting_id;
		this.id_ = id_;
		this.pdb_chain_id = pdb_chain_id;
		this.pdb_entry_id = pdb_entry_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_3d_fitting_list");
		sb.append("\n");
		if (_3d_fitting_id != null)
		{
			sb.append("_3d_fitting_id = ");
			sb.append(_3d_fitting_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdb_chain_id != null)
		{
			sb.append("pdb_chain_id = ");
			sb.append(pdb_chain_id);
			sb.append('\n');
		}
		if (pdb_entry_id != null)
		{
			sb.append("pdb_entry_id = ");
			sb.append(pdb_entry_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		_3d_fitting_id = null;
		id_ = null;
		pdb_chain_id = null;
		pdb_entry_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_3d_fitting_list)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_3d_fitting_list>\n");
			if (_3d_fitting_id != null) ow.write(indent + " <PDBx:_3d_fitting_id>" + _3d_fitting_id + "</PDBx:_3d_fitting_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdb_chain_id != null) ow.write(indent + " <PDBx:pdb_chain_id>" + pdb_chain_id + "</PDBx:pdb_chain_id>\n");
			if (pdb_entry_id != null) ow.write(indent + " <PDBx:pdb_entry_id>" + pdb_entry_id + "</PDBx:pdb_entry_id>\n");
			ow.write(indent + "</PDBx:em_3d_fitting_list>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
