package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_DETECTOR category record details
 *  of the image detector type.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_detectorCategory>
 *  <PDBx:em_detector entry_id="1DYL" id="1">
 *  <PDBx:type>KODAK SO163 FILM</PDBx:type>
 *  </PDBx:em_detector>
 *  </PDBx:em_detectorCategory>
 * </pre>
 */
public class Em_detector extends org.pdb.beans.Em_detector implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_detector";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_detector()
	{
	}

	/** Full constructor */
	public Em_detector(
		Datablock datablock,
		java.lang.String details,
		java.lang.Float detective_quantum_efficiency,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.details = details;
		this.detective_quantum_efficiency = detective_quantum_efficiency;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_detector");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (detective_quantum_efficiency != null)
		{
			sb.append("detective_quantum_efficiency = ");
			sb.append(detective_quantum_efficiency);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		detective_quantum_efficiency = null;
		entry_id = null;
		id_ = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_detector)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_detector>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (detective_quantum_efficiency != null) ow.write(indent + " <PDBx:detective_quantum_efficiency>" + detective_quantum_efficiency + "</PDBx:detective_quantum_efficiency>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:em_detector>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
