package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_ELECTRON_DIFFRACTION category
 *  record details about the electron diffraction data
 *  from the electron crystallography experiment.
 * <pre>
 *  Example 1 - based on PDB entry 1TUB and laboratory records for the
 *  structure corresponding to PDB entry 1TUB
 *  <PDBx:em_electron_diffractionCategory>
 *  <PDBx:em_electron_diffraction entry_id="1TUB" id="1">
 *  <PDBx:num_structure_factors>12000</PDBx:num_structure_factors>
 *  <PDBx:details xsi:nil="true" />
 *  </PDBx:em_electron_diffraction>
 *  </PDBx:em_electron_diffractionCategory>
 * </pre>
 */
public class Em_electron_diffraction extends org.pdb.beans.Em_electron_diffraction implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_electron_diffraction";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_electron_diffraction()
	{
	}

	/** Full constructor */
	public Em_electron_diffraction(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.Integer num_diff_patterns,
		java.lang.Integer num_structure_factors)
	{
		this.datablock = datablock;
		this.details = details;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.num_diff_patterns = num_diff_patterns;
		this.num_structure_factors = num_structure_factors;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_electron_diffraction");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (num_diff_patterns != null)
		{
			sb.append("num_diff_patterns = ");
			sb.append(num_diff_patterns);
			sb.append('\n');
		}
		if (num_structure_factors != null)
		{
			sb.append("num_structure_factors = ");
			sb.append(num_structure_factors);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entry_id = null;
		id_ = null;
		num_diff_patterns = null;
		num_structure_factors = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_electron_diffraction)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_electron_diffraction>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (num_diff_patterns != null) ow.write(indent + " <PDBx:num_diff_patterns>" + num_diff_patterns + "</PDBx:num_diff_patterns>\n");
			if (num_structure_factors != null) ow.write(indent + " <PDBx:num_structure_factors>" + num_structure_factors + "</PDBx:num_structure_factors>\n");
			ow.write(indent + "</PDBx:em_electron_diffraction>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
