package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  data items in the em_electron_diffraction_pattern category
 *  record details about the pattern information
 *  from the electron diffraction experiment.
 * <pre>
 *  example 1 - based on pdb entry 1tub and laboratory records for the
 *  structure corresponding to pdb entry 1tub
 *  <PDBx:em_electron_diffraction_patternCategory>
 *  <PDBx:em_electron_diffraction_pattern entry_id="1TUB" id="1">
 *  <PDBx:num_patterns_by_tilt_angle>1</PDBx:num_patterns_by_tilt_angle>
 *  <PDBx:num_images_by_tilt_angle>4</PDBx:num_images_by_tilt_angle>
 *  </PDBx:em_electron_diffraction_pattern>
 *  </PDBx:em_electron_diffraction_patternCategory>
 * </pre>
 */
public class Em_electron_diffraction_pattern extends org.pdb.beans.Em_electron_diffraction_pattern implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_electron_diffraction_pattern";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_electron_diffraction_pattern()
	{
	}

	/** Full constructor */
	public Em_electron_diffraction_pattern(
		Datablock datablock,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.Integer num_images_by_tilt_angle,
		java.lang.Integer num_patterns_by_tilt_angle,
		java.lang.Integer tilt_angle)
	{
		this.datablock = datablock;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.num_images_by_tilt_angle = num_images_by_tilt_angle;
		this.num_patterns_by_tilt_angle = num_patterns_by_tilt_angle;
		this.tilt_angle = tilt_angle;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_electron_diffraction_pattern");
		sb.append("\n");
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (num_images_by_tilt_angle != null)
		{
			sb.append("num_images_by_tilt_angle = ");
			sb.append(num_images_by_tilt_angle);
			sb.append('\n');
		}
		if (num_patterns_by_tilt_angle != null)
		{
			sb.append("num_patterns_by_tilt_angle = ");
			sb.append(num_patterns_by_tilt_angle);
			sb.append('\n');
		}
		if (tilt_angle != null)
		{
			sb.append("tilt_angle = ");
			sb.append(tilt_angle);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entry_id = null;
		id_ = null;
		num_images_by_tilt_angle = null;
		num_patterns_by_tilt_angle = null;
		tilt_angle = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_electron_diffraction_pattern)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_electron_diffraction_pattern>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (num_images_by_tilt_angle != null) ow.write(indent + " <PDBx:num_images_by_tilt_angle>" + num_images_by_tilt_angle + "</PDBx:num_images_by_tilt_angle>\n");
			if (num_patterns_by_tilt_angle != null) ow.write(indent + " <PDBx:num_patterns_by_tilt_angle>" + num_patterns_by_tilt_angle + "</PDBx:num_patterns_by_tilt_angle>\n");
			if (tilt_angle != null) ow.write(indent + " <PDBx:tilt_angle>" + tilt_angle + "</PDBx:tilt_angle>\n");
			ow.write(indent + "</PDBx:em_electron_diffraction_pattern>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
