package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_ENTITY_ASSEMBLY category
 *  record details about each component of
 *  the complex.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_entity_assemblyCategory>
 *  <PDBx:em_entity_assembly id="1" assembly_id="1">
 *  <PDBx:type>VIRUS</PDBx:type>
 *  </PDBx:em_entity_assembly>
 *  </PDBx:em_entity_assemblyCategory>
 * </pre>
 */
public class Em_entity_assembly extends org.pdb.beans.Em_entity_assembly implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_entity_assembly";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_entity_assembly()
	{
	}

	/** Full constructor */
	public Em_entity_assembly(
		Datablock datablock,
		java.lang.String assembly_id,
		java.lang.String details,
		java.lang.String ebi_cell,
		java.lang.String ebi_cellular_location,
		java.lang.String ebi_engineered,
		java.lang.String ebi_expression_system,
		java.lang.String ebi_expression_system_plasmid,
		java.lang.String ebi_organelle,
		java.lang.String ebi_organism_common,
		java.lang.String ebi_organism_scientific,
		java.lang.String ebi_strain,
		java.lang.String ebi_tissue,
		java.lang.String go_id,
		java.lang.String id_,
		java.lang.String ipr_id,
		java.lang.String name,
		java.lang.String synonym,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.assembly_id = assembly_id;
		this.details = details;
		this.ebi_cell = ebi_cell;
		this.ebi_cellular_location = ebi_cellular_location;
		this.ebi_engineered = ebi_engineered;
		this.ebi_expression_system = ebi_expression_system;
		this.ebi_expression_system_plasmid = ebi_expression_system_plasmid;
		this.ebi_organelle = ebi_organelle;
		this.ebi_organism_common = ebi_organism_common;
		this.ebi_organism_scientific = ebi_organism_scientific;
		this.ebi_strain = ebi_strain;
		this.ebi_tissue = ebi_tissue;
		this.go_id = go_id;
		this.id_ = id_;
		this.ipr_id = ipr_id;
		this.name = name;
		this.synonym = synonym;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_entity_assembly");
		sb.append("\n");
		if (assembly_id != null)
		{
			sb.append("assembly_id = ");
			sb.append(assembly_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (ebi_cell != null)
		{
			sb.append("ebi_cell = ");
			sb.append(ebi_cell);
			sb.append('\n');
		}
		if (ebi_cellular_location != null)
		{
			sb.append("ebi_cellular_location = ");
			sb.append(ebi_cellular_location);
			sb.append('\n');
		}
		if (ebi_engineered != null)
		{
			sb.append("ebi_engineered = ");
			sb.append(ebi_engineered);
			sb.append('\n');
		}
		if (ebi_expression_system != null)
		{
			sb.append("ebi_expression_system = ");
			sb.append(ebi_expression_system);
			sb.append('\n');
		}
		if (ebi_expression_system_plasmid != null)
		{
			sb.append("ebi_expression_system_plasmid = ");
			sb.append(ebi_expression_system_plasmid);
			sb.append('\n');
		}
		if (ebi_organelle != null)
		{
			sb.append("ebi_organelle = ");
			sb.append(ebi_organelle);
			sb.append('\n');
		}
		if (ebi_organism_common != null)
		{
			sb.append("ebi_organism_common = ");
			sb.append(ebi_organism_common);
			sb.append('\n');
		}
		if (ebi_organism_scientific != null)
		{
			sb.append("ebi_organism_scientific = ");
			sb.append(ebi_organism_scientific);
			sb.append('\n');
		}
		if (ebi_strain != null)
		{
			sb.append("ebi_strain = ");
			sb.append(ebi_strain);
			sb.append('\n');
		}
		if (ebi_tissue != null)
		{
			sb.append("ebi_tissue = ");
			sb.append(ebi_tissue);
			sb.append('\n');
		}
		if (go_id != null)
		{
			sb.append("go_id = ");
			sb.append(go_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (ipr_id != null)
		{
			sb.append("ipr_id = ");
			sb.append(ipr_id);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (synonym != null)
		{
			sb.append("synonym = ");
			sb.append(synonym);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		assembly_id = null;
		details = null;
		ebi_cell = null;
		ebi_cellular_location = null;
		ebi_engineered = null;
		ebi_expression_system = null;
		ebi_expression_system_plasmid = null;
		ebi_organelle = null;
		ebi_organism_common = null;
		ebi_organism_scientific = null;
		ebi_strain = null;
		ebi_tissue = null;
		go_id = null;
		id_ = null;
		ipr_id = null;
		name = null;
		synonym = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_entity_assembly)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_entity_assembly>\n");
			if (assembly_id != null) ow.write(indent + " <PDBx:assembly_id>" + assembly_id + "</PDBx:assembly_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (ebi_cell != null) ow.write(indent + " <PDBx:ebi_cell>" + ebi_cell + "</PDBx:ebi_cell>\n");
			if (ebi_cellular_location != null) ow.write(indent + " <PDBx:ebi_cellular_location>" + ebi_cellular_location + "</PDBx:ebi_cellular_location>\n");
			if (ebi_engineered != null) ow.write(indent + " <PDBx:ebi_engineered>" + ebi_engineered + "</PDBx:ebi_engineered>\n");
			if (ebi_expression_system != null) ow.write(indent + " <PDBx:ebi_expression_system>" + ebi_expression_system + "</PDBx:ebi_expression_system>\n");
			if (ebi_expression_system_plasmid != null) ow.write(indent + " <PDBx:ebi_expression_system_plasmid>" + ebi_expression_system_plasmid + "</PDBx:ebi_expression_system_plasmid>\n");
			if (ebi_organelle != null) ow.write(indent + " <PDBx:ebi_organelle>" + ebi_organelle + "</PDBx:ebi_organelle>\n");
			if (ebi_organism_common != null) ow.write(indent + " <PDBx:ebi_organism_common>" + ebi_organism_common + "</PDBx:ebi_organism_common>\n");
			if (ebi_organism_scientific != null) ow.write(indent + " <PDBx:ebi_organism_scientific>" + ebi_organism_scientific + "</PDBx:ebi_organism_scientific>\n");
			if (ebi_strain != null) ow.write(indent + " <PDBx:ebi_strain>" + ebi_strain + "</PDBx:ebi_strain>\n");
			if (ebi_tissue != null) ow.write(indent + " <PDBx:ebi_tissue>" + ebi_tissue + "</PDBx:ebi_tissue>\n");
			if (go_id != null) ow.write(indent + " <PDBx:go_id>" + go_id + "</PDBx:go_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (ipr_id != null) ow.write(indent + " <PDBx:ipr_id>" + ipr_id + "</PDBx:ipr_id>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (synonym != null) ow.write(indent + " <PDBx:synonym>" + synonym + "</PDBx:synonym>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:em_entity_assembly>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
