package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_IMAGE_SCANS category record details
 *  of the image scanning device (microdensitometer)
 *  and parameters for digitization of the image.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_image_scansCategory>
 *  <PDBx:em_image_scans entry_id="1DYL" id="2">
 *  <PDBx:number_digital_images>48</PDBx:number_digital_images>
 *  <PDBx:citation_id>1</PDBx:citation_id>
 *  </PDBx:em_image_scans>
 *  </PDBx:em_image_scansCategory>
 * </pre>
 */
public class Em_image_scans extends org.pdb.beans.Em_image_scans implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_image_scans";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_image_scans()
	{
	}

	/** Full constructor */
	public Em_image_scans(
		Datablock datablock,
		java.lang.String citation_id,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.Integer number_digital_images,
		java.lang.Float od_range,
		java.lang.Integer quant_bit_size,
		java.lang.Float sampling_size,
		java.lang.String scanner_model)
	{
		this.datablock = datablock;
		this.citation_id = citation_id;
		this.details = details;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.number_digital_images = number_digital_images;
		this.od_range = od_range;
		this.quant_bit_size = quant_bit_size;
		this.sampling_size = sampling_size;
		this.scanner_model = scanner_model;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_image_scans");
		sb.append("\n");
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (number_digital_images != null)
		{
			sb.append("number_digital_images = ");
			sb.append(number_digital_images);
			sb.append('\n');
		}
		if (od_range != null)
		{
			sb.append("od_range = ");
			sb.append(od_range);
			sb.append('\n');
		}
		if (quant_bit_size != null)
		{
			sb.append("quant_bit_size = ");
			sb.append(quant_bit_size);
			sb.append('\n');
		}
		if (sampling_size != null)
		{
			sb.append("sampling_size = ");
			sb.append(sampling_size);
			sb.append('\n');
		}
		if (scanner_model != null)
		{
			sb.append("scanner_model = ");
			sb.append(scanner_model);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		citation_id = null;
		details = null;
		entry_id = null;
		id_ = null;
		number_digital_images = null;
		od_range = null;
		quant_bit_size = null;
		sampling_size = null;
		scanner_model = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_image_scans)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_image_scans>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (number_digital_images != null) ow.write(indent + " <PDBx:number_digital_images>" + number_digital_images + "</PDBx:number_digital_images>\n");
			if (od_range != null) ow.write(indent + " <PDBx:od_range>" + od_range + "</PDBx:od_range>\n");
			if (quant_bit_size != null) ow.write(indent + " <PDBx:quant_bit_size>" + quant_bit_size + "</PDBx:quant_bit_size>\n");
			if (sampling_size != null) ow.write(indent + " <PDBx:sampling_size>" + sampling_size + "</PDBx:sampling_size>\n");
			if (scanner_model != null) ow.write(indent + " <PDBx:scanner_model>" + scanner_model + "</PDBx:scanner_model>\n");
			ow.write(indent + "</PDBx:em_image_scans>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
