package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_IMAGING category record details about
 *  the parameters used in imaging the sample in the electron microscope.
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_imagingCategory>
 *  <PDBx:em_imaging entry_id="1DYL" id="1">
 *  <PDBx:sample_support_id>1</PDBx:sample_support_id>
 *  <PDBx:microscope_model>FEI/PHILIPS CM200 FEG</PDBx:microscope_model>
 *  <PDBx:specimen_holder_type>cryotransfer</PDBx:specimen_holder_type>
 *  <PDBx:specimen_holder_model>gatan 626-0300</PDBx:specimen_holder_model>
 *  <PDBx:date>1998-15-06</PDBx:date>
 *  <PDBx:accelerating_voltage>200</PDBx:accelerating_voltage>
 *  <PDBx:illumination_mode>bright field</PDBx:illumination_mode>
 *  <PDBx:mode>low dose</PDBx:mode>
 *  <PDBx:nominal_cs>2.0</PDBx:nominal_cs>
 *  <PDBx:nominal_defocus_min>975.</PDBx:nominal_defocus_min>
 *  <PDBx:nominal_defocus_max>7600.</PDBx:nominal_defocus_max>
 *  <PDBx:tilt_angle_min>0.</PDBx:tilt_angle_min>
 *  <PDBx:tilt_angle_max>0.</PDBx:tilt_angle_max>
 *  <PDBx:nominal_magnification>50000</PDBx:nominal_magnification>
 *  <PDBx:electron_source>FEG</PDBx:electron_source>
 *  <PDBx:citation_id>1</PDBx:citation_id>
 *  <PDBx:temperature>95.</PDBx:temperature>
 *  </PDBx:em_imaging>
 *  </PDBx:em_imagingCategory>
 * </pre>
 */
public class Em_imaging extends org.pdb.beans.Em_imaging implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_imaging";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_imaging()
	{
	}

	/** Full constructor */
	public Em_imaging(
		Datablock datablock,
		java.lang.Float accelerating_voltage,
		java.lang.Integer calibrated_magnification,
		java.lang.String citation_id,
		java.lang.String date,
		java.lang.String details,
		java.lang.Float detector_distance,
		java.lang.String detector_id,
		java.lang.Float electron_dose,
		java.lang.String electron_source,
		java.lang.String energy_filter,
		java.lang.Float energy_window,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.String illumination_mode,
		java.lang.String microscope_model,
		java.lang.String mode,
		java.lang.Float nominal_cs,
		java.lang.Float nominal_defocus_max,
		java.lang.Float nominal_defocus_min,
		java.lang.Integer nominal_magnification,
		java.lang.Float recording_temperature_maximum,
		java.lang.Float recording_temperature_minimum,
		java.lang.String sample_support_id,
		java.lang.String scans_id,
		java.lang.String specimen_holder_model,
		java.lang.String specimen_holder_type,
		java.lang.Float temperature,
		java.lang.Float tilt_angle_max,
		java.lang.Float tilt_angle_min)
	{
		this.datablock = datablock;
		this.accelerating_voltage = accelerating_voltage;
		this.calibrated_magnification = calibrated_magnification;
		this.citation_id = citation_id;
		this.date = date;
		this.details = details;
		this.detector_distance = detector_distance;
		this.detector_id = detector_id;
		this.electron_dose = electron_dose;
		this.electron_source = electron_source;
		this.energy_filter = energy_filter;
		this.energy_window = energy_window;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.illumination_mode = illumination_mode;
		this.microscope_model = microscope_model;
		this.mode = mode;
		this.nominal_cs = nominal_cs;
		this.nominal_defocus_max = nominal_defocus_max;
		this.nominal_defocus_min = nominal_defocus_min;
		this.nominal_magnification = nominal_magnification;
		this.recording_temperature_maximum = recording_temperature_maximum;
		this.recording_temperature_minimum = recording_temperature_minimum;
		this.sample_support_id = sample_support_id;
		this.scans_id = scans_id;
		this.specimen_holder_model = specimen_holder_model;
		this.specimen_holder_type = specimen_holder_type;
		this.temperature = temperature;
		this.tilt_angle_max = tilt_angle_max;
		this.tilt_angle_min = tilt_angle_min;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_imaging");
		sb.append("\n");
		if (accelerating_voltage != null)
		{
			sb.append("accelerating_voltage = ");
			sb.append(accelerating_voltage);
			sb.append('\n');
		}
		if (calibrated_magnification != null)
		{
			sb.append("calibrated_magnification = ");
			sb.append(calibrated_magnification);
			sb.append('\n');
		}
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (date != null)
		{
			sb.append("date = ");
			sb.append(date);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (detector_distance != null)
		{
			sb.append("detector_distance = ");
			sb.append(detector_distance);
			sb.append('\n');
		}
		if (detector_id != null)
		{
			sb.append("detector_id = ");
			sb.append(detector_id);
			sb.append('\n');
		}
		if (electron_dose != null)
		{
			sb.append("electron_dose = ");
			sb.append(electron_dose);
			sb.append('\n');
		}
		if (electron_source != null)
		{
			sb.append("electron_source = ");
			sb.append(electron_source);
			sb.append('\n');
		}
		if (energy_filter != null)
		{
			sb.append("energy_filter = ");
			sb.append(energy_filter);
			sb.append('\n');
		}
		if (energy_window != null)
		{
			sb.append("energy_window = ");
			sb.append(energy_window);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (illumination_mode != null)
		{
			sb.append("illumination_mode = ");
			sb.append(illumination_mode);
			sb.append('\n');
		}
		if (microscope_model != null)
		{
			sb.append("microscope_model = ");
			sb.append(microscope_model);
			sb.append('\n');
		}
		if (mode != null)
		{
			sb.append("mode = ");
			sb.append(mode);
			sb.append('\n');
		}
		if (nominal_cs != null)
		{
			sb.append("nominal_cs = ");
			sb.append(nominal_cs);
			sb.append('\n');
		}
		if (nominal_defocus_max != null)
		{
			sb.append("nominal_defocus_max = ");
			sb.append(nominal_defocus_max);
			sb.append('\n');
		}
		if (nominal_defocus_min != null)
		{
			sb.append("nominal_defocus_min = ");
			sb.append(nominal_defocus_min);
			sb.append('\n');
		}
		if (nominal_magnification != null)
		{
			sb.append("nominal_magnification = ");
			sb.append(nominal_magnification);
			sb.append('\n');
		}
		if (recording_temperature_maximum != null)
		{
			sb.append("recording_temperature_maximum = ");
			sb.append(recording_temperature_maximum);
			sb.append('\n');
		}
		if (recording_temperature_minimum != null)
		{
			sb.append("recording_temperature_minimum = ");
			sb.append(recording_temperature_minimum);
			sb.append('\n');
		}
		if (sample_support_id != null)
		{
			sb.append("sample_support_id = ");
			sb.append(sample_support_id);
			sb.append('\n');
		}
		if (scans_id != null)
		{
			sb.append("scans_id = ");
			sb.append(scans_id);
			sb.append('\n');
		}
		if (specimen_holder_model != null)
		{
			sb.append("specimen_holder_model = ");
			sb.append(specimen_holder_model);
			sb.append('\n');
		}
		if (specimen_holder_type != null)
		{
			sb.append("specimen_holder_type = ");
			sb.append(specimen_holder_type);
			sb.append('\n');
		}
		if (temperature != null)
		{
			sb.append("temperature = ");
			sb.append(temperature);
			sb.append('\n');
		}
		if (tilt_angle_max != null)
		{
			sb.append("tilt_angle_max = ");
			sb.append(tilt_angle_max);
			sb.append('\n');
		}
		if (tilt_angle_min != null)
		{
			sb.append("tilt_angle_min = ");
			sb.append(tilt_angle_min);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		accelerating_voltage = null;
		calibrated_magnification = null;
		citation_id = null;
		date = null;
		details = null;
		detector_distance = null;
		detector_id = null;
		electron_dose = null;
		electron_source = null;
		energy_filter = null;
		energy_window = null;
		entry_id = null;
		id_ = null;
		illumination_mode = null;
		microscope_model = null;
		mode = null;
		nominal_cs = null;
		nominal_defocus_max = null;
		nominal_defocus_min = null;
		nominal_magnification = null;
		recording_temperature_maximum = null;
		recording_temperature_minimum = null;
		sample_support_id = null;
		scans_id = null;
		specimen_holder_model = null;
		specimen_holder_type = null;
		temperature = null;
		tilt_angle_max = null;
		tilt_angle_min = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_imaging)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_imaging>\n");
			if (accelerating_voltage != null) ow.write(indent + " <PDBx:accelerating_voltage>" + accelerating_voltage + "</PDBx:accelerating_voltage>\n");
			if (calibrated_magnification != null) ow.write(indent + " <PDBx:calibrated_magnification>" + calibrated_magnification + "</PDBx:calibrated_magnification>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (date != null) ow.write(indent + " <PDBx:date>" + date + "</PDBx:date>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (detector_distance != null) ow.write(indent + " <PDBx:detector_distance>" + detector_distance + "</PDBx:detector_distance>\n");
			if (detector_id != null) ow.write(indent + " <PDBx:detector_id>" + detector_id + "</PDBx:detector_id>\n");
			if (electron_dose != null) ow.write(indent + " <PDBx:electron_dose>" + electron_dose + "</PDBx:electron_dose>\n");
			if (electron_source != null) ow.write(indent + " <PDBx:electron_source>" + electron_source + "</PDBx:electron_source>\n");
			if (energy_filter != null) ow.write(indent + " <PDBx:energy_filter>" + energy_filter + "</PDBx:energy_filter>\n");
			if (energy_window != null) ow.write(indent + " <PDBx:energy_window>" + energy_window + "</PDBx:energy_window>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (illumination_mode != null) ow.write(indent + " <PDBx:illumination_mode>" + illumination_mode + "</PDBx:illumination_mode>\n");
			if (microscope_model != null) ow.write(indent + " <PDBx:microscope_model>" + microscope_model + "</PDBx:microscope_model>\n");
			if (mode != null) ow.write(indent + " <PDBx:mode>" + mode + "</PDBx:mode>\n");
			if (nominal_cs != null) ow.write(indent + " <PDBx:nominal_cs>" + nominal_cs + "</PDBx:nominal_cs>\n");
			if (nominal_defocus_max != null) ow.write(indent + " <PDBx:nominal_defocus_max>" + nominal_defocus_max + "</PDBx:nominal_defocus_max>\n");
			if (nominal_defocus_min != null) ow.write(indent + " <PDBx:nominal_defocus_min>" + nominal_defocus_min + "</PDBx:nominal_defocus_min>\n");
			if (nominal_magnification != null) ow.write(indent + " <PDBx:nominal_magnification>" + nominal_magnification + "</PDBx:nominal_magnification>\n");
			if (recording_temperature_maximum != null) ow.write(indent + " <PDBx:recording_temperature_maximum>" + recording_temperature_maximum + "</PDBx:recording_temperature_maximum>\n");
			if (recording_temperature_minimum != null) ow.write(indent + " <PDBx:recording_temperature_minimum>" + recording_temperature_minimum + "</PDBx:recording_temperature_minimum>\n");
			if (sample_support_id != null) ow.write(indent + " <PDBx:sample_support_id>" + sample_support_id + "</PDBx:sample_support_id>\n");
			if (scans_id != null) ow.write(indent + " <PDBx:scans_id>" + scans_id + "</PDBx:scans_id>\n");
			if (specimen_holder_model != null) ow.write(indent + " <PDBx:specimen_holder_model>" + specimen_holder_model + "</PDBx:specimen_holder_model>\n");
			if (specimen_holder_type != null) ow.write(indent + " <PDBx:specimen_holder_type>" + specimen_holder_type + "</PDBx:specimen_holder_type>\n");
			if (temperature != null) ow.write(indent + " <PDBx:temperature>" + temperature + "</PDBx:temperature>\n");
			if (tilt_angle_max != null) ow.write(indent + " <PDBx:tilt_angle_max>" + tilt_angle_max + "</PDBx:tilt_angle_max>\n");
			if (tilt_angle_min != null) ow.write(indent + " <PDBx:tilt_angle_min>" + tilt_angle_min + "</PDBx:tilt_angle_min>\n");
			ow.write(indent + "</PDBx:em_imaging>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
