package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EM_SAMPLE_SUPPORT category record details
 *  of the electron microscope grid type, grid support film and pretreatment
 *  of whole before sample is applied
 * <pre>
 *  Example 1 - based on PDB entry 1DYL and laboratory records for the
 *  structure corresponding to PDB entry 1DYL
 *  <PDBx:em_sample_supportCategory>
 *  <PDBx:em_sample_support id="1">
 *  <PDBx:film_material>HOLEY CARBON</PDBx:film_material>
 *  <PDBx:grid_material>COPPER</PDBx:grid_material>
 *  <PDBx:grid_mesh_size>400</PDBx:grid_mesh_size>
 *  <PDBx:grid_type>MESH</PDBx:grid_type>
 *  <PDBx:pretreatment>GLOW DISCHARGE</PDBx:pretreatment>
 *  <PDBx:citation_id>2</PDBx:citation_id>
 *  </PDBx:em_sample_support>
 *  </PDBx:em_sample_supportCategory>
 * </pre>
 */
public class Em_sample_support extends org.pdb.beans.Em_sample_support implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "em_sample_support";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Em_sample_support()
	{
	}

	/** Full constructor */
	public Em_sample_support(
		Datablock datablock,
		java.lang.String citation_id,
		java.lang.String details,
		java.lang.String film_material,
		java.lang.String grid_material,
		java.lang.Integer grid_mesh_size,
		java.lang.String grid_type,
		java.lang.String id_,
		java.lang.String method,
		java.lang.String pretreatment)
	{
		this.datablock = datablock;
		this.citation_id = citation_id;
		this.details = details;
		this.film_material = film_material;
		this.grid_material = grid_material;
		this.grid_mesh_size = grid_mesh_size;
		this.grid_type = grid_type;
		this.id_ = id_;
		this.method = method;
		this.pretreatment = pretreatment;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Em_sample_support");
		sb.append("\n");
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (film_material != null)
		{
			sb.append("film_material = ");
			sb.append(film_material);
			sb.append('\n');
		}
		if (grid_material != null)
		{
			sb.append("grid_material = ");
			sb.append(grid_material);
			sb.append('\n');
		}
		if (grid_mesh_size != null)
		{
			sb.append("grid_mesh_size = ");
			sb.append(grid_mesh_size);
			sb.append('\n');
		}
		if (grid_type != null)
		{
			sb.append("grid_type = ");
			sb.append(grid_type);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (pretreatment != null)
		{
			sb.append("pretreatment = ");
			sb.append(pretreatment);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		citation_id = null;
		details = null;
		film_material = null;
		grid_material = null;
		grid_mesh_size = null;
		grid_type = null;
		id_ = null;
		method = null;
		pretreatment = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Em_sample_support)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:em_sample_support>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (film_material != null) ow.write(indent + " <PDBx:film_material>" + film_material + "</PDBx:film_material>\n");
			if (grid_material != null) ow.write(indent + " <PDBx:grid_material>" + grid_material + "</PDBx:grid_material>\n");
			if (grid_mesh_size != null) ow.write(indent + " <PDBx:grid_mesh_size>" + grid_mesh_size + "</PDBx:grid_mesh_size>\n");
			if (grid_type != null) ow.write(indent + " <PDBx:grid_type>" + grid_type + "</PDBx:grid_type>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (pretreatment != null) ow.write(indent + " <PDBx:pretreatment>" + pretreatment + "</PDBx:pretreatment>\n");
			ow.write(indent + "</PDBx:em_sample_support>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
