package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ENTITY_NAME_COM category record the common name
 *  or names associated with the entity. In some cases, the entity
 *  name may not be the same as the name of the biological structure.
 *  For example, haemoglobin alpha chain would be the entity common
 *  name, not haemoglobin.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_name_comCategory>
 *  <PDBx:entity_name_com entity_id="1" name="HIV-1 protease monomer"></PDBx:entity_name_com>
 *  <PDBx:entity_name_com entity_id="1" name="HIV-1 PR monomer"></PDBx:entity_name_com>
 *  <PDBx:entity_name_com entity_id="2" name="acetyl-pepstatin"></PDBx:entity_name_com>
 *  <PDBx:entity_name_com entity_id="2" name="acetyl-Ile-Val-Asp-Statine-Ala-Ile-Statine"></PDBx:entity_name_com>
 *  <PDBx:entity_name_com entity_id="3" name="water"></PDBx:entity_name_com>
 *  </PDBx:entity_name_comCategory>
 * </pre>
 */
public class Entity_name_com extends org.pdb.beans.Entity_name_com implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entity_name_com";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entity_name_com()
	{
	}

	/** Full constructor */
	public Entity_name_com(
		Datablock datablock,
		java.lang.String entity_id,
		java.lang.String name)
	{
		this.datablock = datablock;
		this.entity_id = entity_id;
		this.name = name;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entity_name_com");
		sb.append("\n");
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entity_id = null;
		name = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entity_name_com)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entity_name_com>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			ow.write(indent + "</PDBx:entity_name_com>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
