package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ENTITY_NAME_SYS category record the systematic
 *  name or names associated with the entity and the system that
 *  was used to construct the systematic name. In some cases, the
 *  entity name may not be the same as the name of the biological
 *  structure.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_name_sysCategory>
 *  <PDBx:entity_name_sys entity_id="1" name="EC 3.4.23.16"></PDBx:entity_name_sys>
 *  <PDBx:entity_name_sys entity_id="2" name="acetyl-Ile-Val-Asp-Sta-Ala-Ile-Sta"></PDBx:entity_name_sys>
 *  <PDBx:entity_name_sys entity_id="3" name="water"></PDBx:entity_name_sys>
 *  </PDBx:entity_name_sysCategory>
 * </pre>
 */
public class Entity_name_sys extends org.pdb.beans.Entity_name_sys implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entity_name_sys";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entity_name_sys()
	{
	}

	/** Full constructor */
	public Entity_name_sys(
		Datablock datablock,
		java.lang.String entity_id,
		java.lang.String name,
		java.lang.String system)
	{
		this.datablock = datablock;
		this.entity_id = entity_id;
		this.name = name;
		this.system = system;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entity_name_sys");
		sb.append("\n");
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (system != null)
		{
			sb.append("system = ");
			sb.append(system);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entity_id = null;
		name = null;
		system = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entity_name_sys)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entity_name_sys>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (system != null) ow.write(indent + " <PDBx:system>" + system + "</PDBx:system>\n");
			ow.write(indent + "</PDBx:entity_name_sys>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
