package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ENTITY_POLY category record details about the
 *  polymer, such as the type of the polymer, the number of
 *  monomers and whether it has nonstandard features.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_polyCategory>
 *  <PDBx:entity_poly entity_id="1">
 *  <PDBx:type>polypeptide(L)</PDBx:type>
 *  <PDBx:nstd_chirality>no</PDBx:nstd_chirality>
 *  <PDBx:nstd_linkage>no</PDBx:nstd_linkage>
 *  <PDBx:nstd_monomer>no</PDBx:nstd_monomer>
 *  </PDBx:entity_poly>
 *  </PDBx:entity_polyCategory>
 * </pre>
 */
public class Entity_poly extends org.pdb.beans.Entity_poly implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entity_poly";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entity_poly()
	{
	}

	/** Full constructor */
	public Entity_poly(
		Datablock datablock,
		java.lang.String entity_id,
		java.lang.String nstd_chirality,
		java.lang.String nstd_linkage,
		java.lang.String nstd_monomer,
		java.lang.Integer number_of_monomers,
		java.lang.String pdbx_seq_one_letter_code,
		java.lang.String pdbx_seq_one_letter_code_can,
		java.lang.String pdbx_strand_id,
		java.lang.String pdbx_target_identifier,
		java.lang.String type,
		java.lang.String type_details)
	{
		this.datablock = datablock;
		this.entity_id = entity_id;
		this.nstd_chirality = nstd_chirality;
		this.nstd_linkage = nstd_linkage;
		this.nstd_monomer = nstd_monomer;
		this.number_of_monomers = number_of_monomers;
		this.pdbx_seq_one_letter_code = org.pdb.ormapping.util.Field.removeCrLf(pdbx_seq_one_letter_code);
		this.pdbx_seq_one_letter_code_can = org.pdb.ormapping.util.Field.removeCrLf(pdbx_seq_one_letter_code_can);
		this.pdbx_strand_id = pdbx_strand_id;
		this.pdbx_target_identifier = pdbx_target_identifier;
		this.type = type;
		this.type_details = type_details;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entity_poly");
		sb.append("\n");
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (nstd_chirality != null)
		{
			sb.append("nstd_chirality = ");
			sb.append(nstd_chirality);
			sb.append('\n');
		}
		if (nstd_linkage != null)
		{
			sb.append("nstd_linkage = ");
			sb.append(nstd_linkage);
			sb.append('\n');
		}
		if (nstd_monomer != null)
		{
			sb.append("nstd_monomer = ");
			sb.append(nstd_monomer);
			sb.append('\n');
		}
		if (number_of_monomers != null)
		{
			sb.append("number_of_monomers = ");
			sb.append(number_of_monomers);
			sb.append('\n');
		}
		if (pdbx_seq_one_letter_code != null)
		{
			sb.append("pdbx_seq_one_letter_code = ");
			sb.append(pdbx_seq_one_letter_code);
			sb.append('\n');
		}
		if (pdbx_seq_one_letter_code_can != null)
		{
			sb.append("pdbx_seq_one_letter_code_can = ");
			sb.append(pdbx_seq_one_letter_code_can);
			sb.append('\n');
		}
		if (pdbx_strand_id != null)
		{
			sb.append("pdbx_strand_id = ");
			sb.append(pdbx_strand_id);
			sb.append('\n');
		}
		if (pdbx_target_identifier != null)
		{
			sb.append("pdbx_target_identifier = ");
			sb.append(pdbx_target_identifier);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		if (type_details != null)
		{
			sb.append("type_details = ");
			sb.append(type_details);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entity_id = null;
		nstd_chirality = null;
		nstd_linkage = null;
		nstd_monomer = null;
		number_of_monomers = null;
		pdbx_seq_one_letter_code = null;
		pdbx_seq_one_letter_code_can = null;
		pdbx_strand_id = null;
		pdbx_target_identifier = null;
		type = null;
		type_details = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entity_poly)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entity_poly>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (nstd_chirality != null) ow.write(indent + " <PDBx:nstd_chirality>" + nstd_chirality + "</PDBx:nstd_chirality>\n");
			if (nstd_linkage != null) ow.write(indent + " <PDBx:nstd_linkage>" + nstd_linkage + "</PDBx:nstd_linkage>\n");
			if (nstd_monomer != null) ow.write(indent + " <PDBx:nstd_monomer>" + nstd_monomer + "</PDBx:nstd_monomer>\n");
			if (number_of_monomers != null) ow.write(indent + " <PDBx:number_of_monomers>" + number_of_monomers + "</PDBx:number_of_monomers>\n");
			if (pdbx_seq_one_letter_code != null) ow.write(indent + " <PDBx:pdbx_seq_one_letter_code>" + pdbx_seq_one_letter_code + "</PDBx:pdbx_seq_one_letter_code>\n");
			if (pdbx_seq_one_letter_code_can != null) ow.write(indent + " <PDBx:pdbx_seq_one_letter_code_can>" + pdbx_seq_one_letter_code_can + "</PDBx:pdbx_seq_one_letter_code_can>\n");
			if (pdbx_strand_id != null) ow.write(indent + " <PDBx:pdbx_strand_id>" + pdbx_strand_id + "</PDBx:pdbx_strand_id>\n");
			if (pdbx_target_identifier != null) ow.write(indent + " <PDBx:pdbx_target_identifier>" + pdbx_target_identifier + "</PDBx:pdbx_target_identifier>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			if (type_details != null) ow.write(indent + " <PDBx:type_details>" + type_details + "</PDBx:type_details>\n");
			ow.write(indent + "</PDBx:entity_poly>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
