package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ENTITY_POLY_SEQ category specify the sequence
 *  of monomers in a polymer. Allowance is made for the possibility
 *  of microheterogeneity in a sample by allowing a given sequence
 *  number to be correlated with more than one monomer ID. The
 *  corresponding ATOM_SITE entries should reflect this
 *  heterogeneity.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_poly_seqCategory>
 *  <PDBx:entity_poly_seq entity_id="1" num="1" mon_id="PRO"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="2" mon_id="GLN"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="3" mon_id="ILE"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="4" mon_id="THR"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="5" mon_id="LEU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="6" mon_id="TRP"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="7" mon_id="GLN"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="8" mon_id="ARG"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="9" mon_id="PRO"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="10" mon_id="LEU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="11" mon_id="VAL"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="12" mon_id="THR"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="13" mon_id="ILE"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="14" mon_id="LYS"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="15" mon_id="ILE"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="16" mon_id="GLY"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="17" mon_id="GLY"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="18" mon_id="GLN"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="19" mon_id="LEU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="20" mon_id="LYS"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="21" mon_id="GLU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="22" mon_id="ALA"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="23" mon_id="LEU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="24" mon_id="LEU"></PDBx:entity_poly_seq>
 *  <PDBx:entity_poly_seq entity_id="1" num="25" mon_id="ASP"></PDBx:entity_poly_seq>
 *  </PDBx:entity_poly_seqCategory>
 * </pre>
 */
public class Entity_poly_seq extends org.pdb.beans.Entity_poly_seq implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entity_poly_seq";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entity_poly_seq()
	{
	}

	/** Full constructor */
	public Entity_poly_seq(
		Datablock datablock,
		java.lang.String entity_id,
		java.lang.String hetero,
		java.lang.String mon_id,
		java.lang.Integer num)
	{
		this.datablock = datablock;
		this.entity_id = entity_id;
		this.hetero = hetero;
		this.mon_id = mon_id;
		this.num = num;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entity_poly_seq");
		sb.append("\n");
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (hetero != null)
		{
			sb.append("hetero = ");
			sb.append(hetero);
			sb.append('\n');
		}
		if (mon_id != null)
		{
			sb.append("mon_id = ");
			sb.append(mon_id);
			sb.append('\n');
		}
		if (num != null)
		{
			sb.append("num = ");
			sb.append(num);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entity_id = null;
		hetero = null;
		mon_id = null;
		num = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entity_poly_seq)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entity_poly_seq>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (hetero != null) ow.write(indent + " <PDBx:hetero>" + hetero + "</PDBx:hetero>\n");
			if (mon_id != null) ow.write(indent + " <PDBx:mon_id>" + mon_id + "</PDBx:mon_id>\n");
			if (num != null) ow.write(indent + " <PDBx:num>" + num + "</PDBx:num>\n");
			ow.write(indent + "</PDBx:entity_poly_seq>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
