package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ENTITY_SRC_NAT category record details of
 *  the source from which the entity was obtained in cases
 *  where the entity was isolated directly from a natural tissue.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entity_src_natCategory>
 *  <PDBx:entity_src_nat entity_id="2">
 *  <PDBx:common_name>bacteria</PDBx:common_name>
 *  <PDBx:genus>Actinomycetes</PDBx:genus>
 *  <PDBx:species xsi:nil="true" />
 *  <PDBx:details>    Acetyl-pepstatin was isolated by Dr. K. Oda, Osaka
 *  Prefecture University, and provided to us by Dr. Ben
 *  Dunn, University of Florida, and Dr. J. Kay, University
 *  of Wales.</PDBx:details>
 *  </PDBx:entity_src_nat>
 *  </PDBx:entity_src_natCategory>
 * </pre>
 */
public class Entity_src_nat extends org.pdb.beans.Entity_src_nat implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entity_src_nat";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entity_src_nat()
	{
	}

	/** Full constructor */
	public Entity_src_nat(
		Datablock datablock,
		java.lang.String common_name,
		java.lang.String details,
		java.lang.String entity_id,
		java.lang.String genus,
		java.lang.String pdbx_atcc,
		java.lang.String pdbx_cell,
		java.lang.String pdbx_cell_line,
		java.lang.String pdbx_cellular_location,
		java.lang.String pdbx_fragment,
		java.lang.String pdbx_ncbi_taxonomy_id,
		java.lang.String pdbx_organ,
		java.lang.String pdbx_organelle,
		java.lang.String pdbx_organism_scientific,
		java.lang.String pdbx_plasmid_details,
		java.lang.String pdbx_plasmid_name,
		java.lang.String pdbx_secretion,
		java.lang.String pdbx_variant,
		java.lang.String species,
		java.lang.String strain,
		java.lang.String tissue,
		java.lang.String tissue_fraction)
	{
		this.datablock = datablock;
		this.common_name = common_name;
		this.details = details;
		this.entity_id = entity_id;
		this.genus = genus;
		this.pdbx_atcc = pdbx_atcc;
		this.pdbx_cell = pdbx_cell;
		this.pdbx_cell_line = pdbx_cell_line;
		this.pdbx_cellular_location = pdbx_cellular_location;
		this.pdbx_fragment = pdbx_fragment;
		this.pdbx_ncbi_taxonomy_id = pdbx_ncbi_taxonomy_id;
		this.pdbx_organ = pdbx_organ;
		this.pdbx_organelle = pdbx_organelle;
		this.pdbx_organism_scientific = pdbx_organism_scientific;
		this.pdbx_plasmid_details = pdbx_plasmid_details;
		this.pdbx_plasmid_name = pdbx_plasmid_name;
		this.pdbx_secretion = pdbx_secretion;
		this.pdbx_variant = pdbx_variant;
		this.species = species;
		this.strain = strain;
		this.tissue = tissue;
		this.tissue_fraction = tissue_fraction;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entity_src_nat");
		sb.append("\n");
		if (common_name != null)
		{
			sb.append("common_name = ");
			sb.append(common_name);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (genus != null)
		{
			sb.append("genus = ");
			sb.append(genus);
			sb.append('\n');
		}
		if (pdbx_atcc != null)
		{
			sb.append("pdbx_atcc = ");
			sb.append(pdbx_atcc);
			sb.append('\n');
		}
		if (pdbx_cell != null)
		{
			sb.append("pdbx_cell = ");
			sb.append(pdbx_cell);
			sb.append('\n');
		}
		if (pdbx_cell_line != null)
		{
			sb.append("pdbx_cell_line = ");
			sb.append(pdbx_cell_line);
			sb.append('\n');
		}
		if (pdbx_cellular_location != null)
		{
			sb.append("pdbx_cellular_location = ");
			sb.append(pdbx_cellular_location);
			sb.append('\n');
		}
		if (pdbx_fragment != null)
		{
			sb.append("pdbx_fragment = ");
			sb.append(pdbx_fragment);
			sb.append('\n');
		}
		if (pdbx_ncbi_taxonomy_id != null)
		{
			sb.append("pdbx_ncbi_taxonomy_id = ");
			sb.append(pdbx_ncbi_taxonomy_id);
			sb.append('\n');
		}
		if (pdbx_organ != null)
		{
			sb.append("pdbx_organ = ");
			sb.append(pdbx_organ);
			sb.append('\n');
		}
		if (pdbx_organelle != null)
		{
			sb.append("pdbx_organelle = ");
			sb.append(pdbx_organelle);
			sb.append('\n');
		}
		if (pdbx_organism_scientific != null)
		{
			sb.append("pdbx_organism_scientific = ");
			sb.append(pdbx_organism_scientific);
			sb.append('\n');
		}
		if (pdbx_plasmid_details != null)
		{
			sb.append("pdbx_plasmid_details = ");
			sb.append(pdbx_plasmid_details);
			sb.append('\n');
		}
		if (pdbx_plasmid_name != null)
		{
			sb.append("pdbx_plasmid_name = ");
			sb.append(pdbx_plasmid_name);
			sb.append('\n');
		}
		if (pdbx_secretion != null)
		{
			sb.append("pdbx_secretion = ");
			sb.append(pdbx_secretion);
			sb.append('\n');
		}
		if (pdbx_variant != null)
		{
			sb.append("pdbx_variant = ");
			sb.append(pdbx_variant);
			sb.append('\n');
		}
		if (species != null)
		{
			sb.append("species = ");
			sb.append(species);
			sb.append('\n');
		}
		if (strain != null)
		{
			sb.append("strain = ");
			sb.append(strain);
			sb.append('\n');
		}
		if (tissue != null)
		{
			sb.append("tissue = ");
			sb.append(tissue);
			sb.append('\n');
		}
		if (tissue_fraction != null)
		{
			sb.append("tissue_fraction = ");
			sb.append(tissue_fraction);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		common_name = null;
		details = null;
		entity_id = null;
		genus = null;
		pdbx_atcc = null;
		pdbx_cell = null;
		pdbx_cell_line = null;
		pdbx_cellular_location = null;
		pdbx_fragment = null;
		pdbx_ncbi_taxonomy_id = null;
		pdbx_organ = null;
		pdbx_organelle = null;
		pdbx_organism_scientific = null;
		pdbx_plasmid_details = null;
		pdbx_plasmid_name = null;
		pdbx_secretion = null;
		pdbx_variant = null;
		species = null;
		strain = null;
		tissue = null;
		tissue_fraction = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entity_src_nat)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entity_src_nat>\n");
			if (common_name != null) ow.write(indent + " <PDBx:common_name>" + common_name + "</PDBx:common_name>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (genus != null) ow.write(indent + " <PDBx:genus>" + genus + "</PDBx:genus>\n");
			if (pdbx_atcc != null) ow.write(indent + " <PDBx:pdbx_atcc>" + pdbx_atcc + "</PDBx:pdbx_atcc>\n");
			if (pdbx_cell != null) ow.write(indent + " <PDBx:pdbx_cell>" + pdbx_cell + "</PDBx:pdbx_cell>\n");
			if (pdbx_cell_line != null) ow.write(indent + " <PDBx:pdbx_cell_line>" + pdbx_cell_line + "</PDBx:pdbx_cell_line>\n");
			if (pdbx_cellular_location != null) ow.write(indent + " <PDBx:pdbx_cellular_location>" + pdbx_cellular_location + "</PDBx:pdbx_cellular_location>\n");
			if (pdbx_fragment != null) ow.write(indent + " <PDBx:pdbx_fragment>" + pdbx_fragment + "</PDBx:pdbx_fragment>\n");
			if (pdbx_ncbi_taxonomy_id != null) ow.write(indent + " <PDBx:pdbx_ncbi_taxonomy_id>" + pdbx_ncbi_taxonomy_id + "</PDBx:pdbx_ncbi_taxonomy_id>\n");
			if (pdbx_organ != null) ow.write(indent + " <PDBx:pdbx_organ>" + pdbx_organ + "</PDBx:pdbx_organ>\n");
			if (pdbx_organelle != null) ow.write(indent + " <PDBx:pdbx_organelle>" + pdbx_organelle + "</PDBx:pdbx_organelle>\n");
			if (pdbx_organism_scientific != null) ow.write(indent + " <PDBx:pdbx_organism_scientific>" + pdbx_organism_scientific + "</PDBx:pdbx_organism_scientific>\n");
			if (pdbx_plasmid_details != null) ow.write(indent + " <PDBx:pdbx_plasmid_details>" + pdbx_plasmid_details + "</PDBx:pdbx_plasmid_details>\n");
			if (pdbx_plasmid_name != null) ow.write(indent + " <PDBx:pdbx_plasmid_name>" + pdbx_plasmid_name + "</PDBx:pdbx_plasmid_name>\n");
			if (pdbx_secretion != null) ow.write(indent + " <PDBx:pdbx_secretion>" + pdbx_secretion + "</PDBx:pdbx_secretion>\n");
			if (pdbx_variant != null) ow.write(indent + " <PDBx:pdbx_variant>" + pdbx_variant + "</PDBx:pdbx_variant>\n");
			if (species != null) ow.write(indent + " <PDBx:species>" + species + "</PDBx:species>\n");
			if (strain != null) ow.write(indent + " <PDBx:strain>" + strain + "</PDBx:strain>\n");
			if (tissue != null) ow.write(indent + " <PDBx:tissue>" + tissue + "</PDBx:tissue>\n");
			if (tissue_fraction != null) ow.write(indent + " <PDBx:tissue_fraction>" + tissue_fraction + "</PDBx:tissue_fraction>\n");
			ow.write(indent + "</PDBx:entity_src_nat>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
