package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  There is only one item in the ENTRY category,  attribute id in category entry.  This
 *  data item gives a name to this entry and is indirectly a key to
 *  the categories (such as CELL, GEOM, EXPTL) that describe
 *  information pertinent to the entire data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:entryCategory>
 *  <PDBx:entry id="5HVP"></PDBx:entry>
 *  </PDBx:entryCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:entryCategory>
 *  <PDBx:entry id="TOZ"></PDBx:entry>
 *  </PDBx:entryCategory>
 * </pre>
 */
public class Entry extends org.pdb.beans.Entry implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entry";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entry()
	{
	}

	/** Full constructor */
	public Entry(
		Datablock datablock,
		java.lang.String id_,
		java.lang.String pdbx_DOI)
	{
		this.datablock = datablock;
		this.id_ = id_;
		this.pdbx_DOI = pdbx_DOI;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entry");
		sb.append("\n");
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_DOI != null)
		{
			sb.append("pdbx_DOI = ");
			sb.append(pdbx_DOI);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		id_ = null;
		pdbx_DOI = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entry)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entry>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_DOI != null) ow.write(indent + " <PDBx:pdbx_DOI>" + pdbx_DOI + "</PDBx:pdbx_DOI>\n");
			ow.write(indent + "</PDBx:entry>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
