package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the ENTRY_LINK category record the
 *  relationships between the current data block
 *  identified by  attribute id in category entry and other data blocks
 *  within the current file which may be referenced
 *  in the current data block.
 *  
 * <pre>
 *  Example 1 - example file for the one-dimensional incommensurately
 *  modulated structure of K~2~SeO~4~.
 *  <PDBx:entry_linkCategory>
 *  <PDBx:entry_link id="KSE_COM" entry_id="KSE_TEXT">
 *  <PDBx:details>experimental data common to ref./mod. structures</PDBx:details>
 *  </PDBx:entry_link>
 *  <PDBx:entry_link id="KSE_REF" entry_id="KSE_TEXT">
 *  <PDBx:details>reference structure</PDBx:details>
 *  </PDBx:entry_link>
 *  <PDBx:entry_link id="KSE_MOD" entry_id="KSE_TEXT">
 *  <PDBx:details>modulated structure</PDBx:details>
 *  </PDBx:entry_link>
 *  </PDBx:entry_linkCategory>
 * </pre>
 */
public class Entry_link extends org.pdb.beans.Entry_link implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "entry_link";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Entry_link()
	{
	}

	/** Full constructor */
	public Entry_link(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.details = details;
		this.entry_id = entry_id;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Entry_link");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entry_id = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Entry_link)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:entry_link>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:entry_link>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
