package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EXPTL category record details about the
 *  experimental work prior to the intensity measurements and
 *  details about the absorption-correction technique employed.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for Yb(S-C5H4N)2(THF)4.
 *  <PDBx:exptlCategory>
 *  <PDBx:exptl entry_id="datablock1">
 *  <PDBx:absorpt_coefficient_mu>1.22</PDBx:absorpt_coefficient_mu>
 *  <PDBx:absorpt_correction_T_max>0.896</PDBx:absorpt_correction_T_max>
 *  <PDBx:absorpt_correction_T_min>0.802</PDBx:absorpt_correction_T_min>
 *  <PDBx:absorpt_correction_type>integration</PDBx:absorpt_correction_type>
 *  <PDBx:absorpt_process_details> Gaussian grid method from SHELX76
 *  Sheldrick, G. M., &quot;SHELX-76: structure determination and
 *  refinement program&quot;, Cambridge University, UK, 1976</PDBx:absorpt_process_details>
 *  <PDBx:crystals_number>1</PDBx:crystals_number>
 *  <PDBx:details> Enraf-Nonius LT2 liquid nitrogen variable-temperature
 *  device used</PDBx:details>
 *  <PDBx:method>single-crystal x-ray diffraction</PDBx:method>
 *  <PDBx:method_details> graphite monochromatized Cu K(alpha) fixed tube and
 *  Enraf-Nonius CAD4 diffractometer used</PDBx:method_details>
 *  </PDBx:exptl>
 *  </PDBx:exptlCategory>
 * </pre>
 */
public class Exptl extends org.pdb.beans.Exptl implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "exptl";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Exptl()
	{
	}

	/** Full constructor */
	public Exptl(
		Datablock datablock,
		java.lang.Float absorpt_coefficient_mu,
		java.lang.Float absorpt_correction_T_max,
		java.lang.Float absorpt_correction_T_min,
		java.lang.String absorpt_correction_type,
		java.lang.String absorpt_process_details,
		java.lang.Integer crystals_number,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String method,
		java.lang.String method_details)
	{
		this.datablock = datablock;
		this.absorpt_coefficient_mu = absorpt_coefficient_mu;
		this.absorpt_correction_T_max = absorpt_correction_T_max;
		this.absorpt_correction_T_min = absorpt_correction_T_min;
		this.absorpt_correction_type = absorpt_correction_type;
		this.absorpt_process_details = absorpt_process_details;
		this.crystals_number = crystals_number;
		this.details = details;
		this.entry_id = entry_id;
		this.method = method;
		this.method_details = method_details;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Exptl");
		sb.append("\n");
		if (absorpt_coefficient_mu != null)
		{
			sb.append("absorpt_coefficient_mu = ");
			sb.append(absorpt_coefficient_mu);
			sb.append('\n');
		}
		if (absorpt_correction_T_max != null)
		{
			sb.append("absorpt_correction_T_max = ");
			sb.append(absorpt_correction_T_max);
			sb.append('\n');
		}
		if (absorpt_correction_T_min != null)
		{
			sb.append("absorpt_correction_T_min = ");
			sb.append(absorpt_correction_T_min);
			sb.append('\n');
		}
		if (absorpt_correction_type != null)
		{
			sb.append("absorpt_correction_type = ");
			sb.append(absorpt_correction_type);
			sb.append('\n');
		}
		if (absorpt_process_details != null)
		{
			sb.append("absorpt_process_details = ");
			sb.append(absorpt_process_details);
			sb.append('\n');
		}
		if (crystals_number != null)
		{
			sb.append("crystals_number = ");
			sb.append(crystals_number);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (method_details != null)
		{
			sb.append("method_details = ");
			sb.append(method_details);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		absorpt_coefficient_mu = null;
		absorpt_correction_T_max = null;
		absorpt_correction_T_min = null;
		absorpt_correction_type = null;
		absorpt_process_details = null;
		crystals_number = null;
		details = null;
		entry_id = null;
		method = null;
		method_details = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Exptl)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:exptl>\n");
			if (absorpt_coefficient_mu != null) ow.write(indent + " <PDBx:absorpt_coefficient_mu>" + absorpt_coefficient_mu + "</PDBx:absorpt_coefficient_mu>\n");
			if (absorpt_correction_T_max != null) ow.write(indent + " <PDBx:absorpt_correction_T_max>" + absorpt_correction_T_max + "</PDBx:absorpt_correction_T_max>\n");
			if (absorpt_correction_T_min != null) ow.write(indent + " <PDBx:absorpt_correction_T_min>" + absorpt_correction_T_min + "</PDBx:absorpt_correction_T_min>\n");
			if (absorpt_correction_type != null) ow.write(indent + " <PDBx:absorpt_correction_type>" + absorpt_correction_type + "</PDBx:absorpt_correction_type>\n");
			if (absorpt_process_details != null) ow.write(indent + " <PDBx:absorpt_process_details>" + absorpt_process_details + "</PDBx:absorpt_process_details>\n");
			if (crystals_number != null) ow.write(indent + " <PDBx:crystals_number>" + crystals_number + "</PDBx:crystals_number>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (method_details != null) ow.write(indent + " <PDBx:method_details>" + method_details + "</PDBx:method_details>\n");
			ow.write(indent + "</PDBx:exptl>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
