package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EXPTL_CRYSTAL_FACE category record details
 *  of the crystal faces.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for Yb(S-C5H4N)2(THF)4
 *  for the 100 face of crystal xstl1.
 *  <PDBx:exptl_crystal_faceCategory>
 *  <PDBx:exptl_crystal_face crystal_id="xstl1" index_h="1" index_k="0" index_l="0">
 *  <PDBx:diffr_chi>42.56</PDBx:diffr_chi>
 *  <PDBx:diffr_kappa>30.23</PDBx:diffr_kappa>
 *  <PDBx:diffr_phi>-125.56</PDBx:diffr_phi>
 *  <PDBx:diffr_psi>-0.34</PDBx:diffr_psi>
 *  <PDBx:perp_dist>0.025</PDBx:perp_dist>
 *  </PDBx:exptl_crystal_face>
 *  </PDBx:exptl_crystal_faceCategory>
 * </pre>
 */
public class Exptl_crystal_face extends org.pdb.beans.Exptl_crystal_face implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "exptl_crystal_face";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Exptl_crystal_face()
	{
	}

	/** Full constructor */
	public Exptl_crystal_face(
		Datablock datablock,
		java.lang.String crystal_id,
		java.lang.Float diffr_chi,
		java.lang.Float diffr_kappa,
		java.lang.Float diffr_phi,
		java.lang.Float diffr_psi,
		java.lang.Integer index_h,
		java.lang.Integer index_k,
		java.lang.Integer index_l,
		java.lang.Float perp_dist)
	{
		this.datablock = datablock;
		this.crystal_id = crystal_id;
		this.diffr_chi = diffr_chi;
		this.diffr_kappa = diffr_kappa;
		this.diffr_phi = diffr_phi;
		this.diffr_psi = diffr_psi;
		this.index_h = index_h;
		this.index_k = index_k;
		this.index_l = index_l;
		this.perp_dist = perp_dist;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Exptl_crystal_face");
		sb.append("\n");
		if (crystal_id != null)
		{
			sb.append("crystal_id = ");
			sb.append(crystal_id);
			sb.append('\n');
		}
		if (diffr_chi != null)
		{
			sb.append("diffr_chi = ");
			sb.append(diffr_chi);
			sb.append('\n');
		}
		if (diffr_kappa != null)
		{
			sb.append("diffr_kappa = ");
			sb.append(diffr_kappa);
			sb.append('\n');
		}
		if (diffr_phi != null)
		{
			sb.append("diffr_phi = ");
			sb.append(diffr_phi);
			sb.append('\n');
		}
		if (diffr_psi != null)
		{
			sb.append("diffr_psi = ");
			sb.append(diffr_psi);
			sb.append('\n');
		}
		if (index_h != null)
		{
			sb.append("index_h = ");
			sb.append(index_h);
			sb.append('\n');
		}
		if (index_k != null)
		{
			sb.append("index_k = ");
			sb.append(index_k);
			sb.append('\n');
		}
		if (index_l != null)
		{
			sb.append("index_l = ");
			sb.append(index_l);
			sb.append('\n');
		}
		if (perp_dist != null)
		{
			sb.append("perp_dist = ");
			sb.append(perp_dist);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		crystal_id = null;
		diffr_chi = null;
		diffr_kappa = null;
		diffr_phi = null;
		diffr_psi = null;
		index_h = null;
		index_k = null;
		index_l = null;
		perp_dist = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Exptl_crystal_face)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:exptl_crystal_face>\n");
			if (crystal_id != null) ow.write(indent + " <PDBx:crystal_id>" + crystal_id + "</PDBx:crystal_id>\n");
			if (diffr_chi != null) ow.write(indent + " <PDBx:diffr_chi>" + diffr_chi + "</PDBx:diffr_chi>\n");
			if (diffr_kappa != null) ow.write(indent + " <PDBx:diffr_kappa>" + diffr_kappa + "</PDBx:diffr_kappa>\n");
			if (diffr_phi != null) ow.write(indent + " <PDBx:diffr_phi>" + diffr_phi + "</PDBx:diffr_phi>\n");
			if (diffr_psi != null) ow.write(indent + " <PDBx:diffr_psi>" + diffr_psi + "</PDBx:diffr_psi>\n");
			if (index_h != null) ow.write(indent + " <PDBx:index_h>" + index_h + "</PDBx:index_h>\n");
			if (index_k != null) ow.write(indent + " <PDBx:index_k>" + index_k + "</PDBx:index_k>\n");
			if (index_l != null) ow.write(indent + " <PDBx:index_l>" + index_l + "</PDBx:index_l>\n");
			if (perp_dist != null) ow.write(indent + " <PDBx:perp_dist>" + perp_dist + "</PDBx:perp_dist>\n");
			ow.write(indent + "</PDBx:exptl_crystal_face>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
