package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EXPTL_CRYSTAL_GROW category record details
 *  about the conditions and methods used to grow the crystal.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:exptl_crystal_growCategory>
 *  <PDBx:exptl_crystal_grow crystal_id="1">
 *  <PDBx:method>hanging drop</PDBx:method>
 *  <PDBx:apparatus>Linbro plates</PDBx:apparatus>
 *  <PDBx:atmosphere>room air</PDBx:atmosphere>
 *  <PDBx:pH>4.7</PDBx:pH>
 *  <PDBx:temp>18(3).</PDBx:temp>
 *  <PDBx:time>approximately 2 days</PDBx:time>
 *  </PDBx:exptl_crystal_grow>
 *  </PDBx:exptl_crystal_growCategory>
 * </pre>
 */
public class Exptl_crystal_grow extends org.pdb.beans.Exptl_crystal_grow implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "exptl_crystal_grow";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Exptl_crystal_grow()
	{
	}

	/** Full constructor */
	public Exptl_crystal_grow(
		Datablock datablock,
		java.lang.String apparatus,
		java.lang.String atmosphere,
		java.lang.String crystal_id,
		java.lang.String details,
		java.lang.String method,
		java.lang.String method_ref,
		java.lang.Float pH,
		java.lang.String pdbx_details,
		java.lang.String pdbx_pH_range,
		java.lang.Float pressure,
		java.lang.Float pressure_esd,
		java.lang.String seeding,
		java.lang.String seeding_ref,
		java.lang.Float temp,
		java.lang.String temp_details,
		java.lang.Float temp_esd,
		java.lang.String time)
	{
		this.datablock = datablock;
		this.apparatus = apparatus;
		this.atmosphere = atmosphere;
		this.crystal_id = crystal_id;
		this.details = details;
		this.method = method;
		this.method_ref = method_ref;
		this.pH = pH;
		this.pdbx_details = pdbx_details;
		this.pdbx_pH_range = pdbx_pH_range;
		this.pressure = pressure;
		this.pressure_esd = pressure_esd;
		this.seeding = seeding;
		this.seeding_ref = seeding_ref;
		this.temp = temp;
		this.temp_details = temp_details;
		this.temp_esd = temp_esd;
		this.time = time;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Exptl_crystal_grow");
		sb.append("\n");
		if (apparatus != null)
		{
			sb.append("apparatus = ");
			sb.append(apparatus);
			sb.append('\n');
		}
		if (atmosphere != null)
		{
			sb.append("atmosphere = ");
			sb.append(atmosphere);
			sb.append('\n');
		}
		if (crystal_id != null)
		{
			sb.append("crystal_id = ");
			sb.append(crystal_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		if (method_ref != null)
		{
			sb.append("method_ref = ");
			sb.append(method_ref);
			sb.append('\n');
		}
		if (pH != null)
		{
			sb.append("pH = ");
			sb.append(pH);
			sb.append('\n');
		}
		if (pdbx_details != null)
		{
			sb.append("pdbx_details = ");
			sb.append(pdbx_details);
			sb.append('\n');
		}
		if (pdbx_pH_range != null)
		{
			sb.append("pdbx_pH_range = ");
			sb.append(pdbx_pH_range);
			sb.append('\n');
		}
		if (pressure != null)
		{
			sb.append("pressure = ");
			sb.append(pressure);
			sb.append('\n');
		}
		if (pressure_esd != null)
		{
			sb.append("pressure_esd = ");
			sb.append(pressure_esd);
			sb.append('\n');
		}
		if (seeding != null)
		{
			sb.append("seeding = ");
			sb.append(seeding);
			sb.append('\n');
		}
		if (seeding_ref != null)
		{
			sb.append("seeding_ref = ");
			sb.append(seeding_ref);
			sb.append('\n');
		}
		if (temp != null)
		{
			sb.append("temp = ");
			sb.append(temp);
			sb.append('\n');
		}
		if (temp_details != null)
		{
			sb.append("temp_details = ");
			sb.append(temp_details);
			sb.append('\n');
		}
		if (temp_esd != null)
		{
			sb.append("temp_esd = ");
			sb.append(temp_esd);
			sb.append('\n');
		}
		if (time != null)
		{
			sb.append("time = ");
			sb.append(time);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		apparatus = null;
		atmosphere = null;
		crystal_id = null;
		details = null;
		method = null;
		method_ref = null;
		pH = null;
		pdbx_details = null;
		pdbx_pH_range = null;
		pressure = null;
		pressure_esd = null;
		seeding = null;
		seeding_ref = null;
		temp = null;
		temp_details = null;
		temp_esd = null;
		time = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Exptl_crystal_grow)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:exptl_crystal_grow>\n");
			if (apparatus != null) ow.write(indent + " <PDBx:apparatus>" + apparatus + "</PDBx:apparatus>\n");
			if (atmosphere != null) ow.write(indent + " <PDBx:atmosphere>" + atmosphere + "</PDBx:atmosphere>\n");
			if (crystal_id != null) ow.write(indent + " <PDBx:crystal_id>" + crystal_id + "</PDBx:crystal_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			if (method_ref != null) ow.write(indent + " <PDBx:method_ref>" + method_ref + "</PDBx:method_ref>\n");
			if (pH != null) ow.write(indent + " <PDBx:pH>" + pH + "</PDBx:pH>\n");
			if (pdbx_details != null) ow.write(indent + " <PDBx:pdbx_details>" + pdbx_details + "</PDBx:pdbx_details>\n");
			if (pdbx_pH_range != null) ow.write(indent + " <PDBx:pdbx_pH_range>" + pdbx_pH_range + "</PDBx:pdbx_pH_range>\n");
			if (pressure != null) ow.write(indent + " <PDBx:pressure>" + pressure + "</PDBx:pressure>\n");
			if (pressure_esd != null) ow.write(indent + " <PDBx:pressure_esd>" + pressure_esd + "</PDBx:pressure_esd>\n");
			if (seeding != null) ow.write(indent + " <PDBx:seeding>" + seeding + "</PDBx:seeding>\n");
			if (seeding_ref != null) ow.write(indent + " <PDBx:seeding_ref>" + seeding_ref + "</PDBx:seeding_ref>\n");
			if (temp != null) ow.write(indent + " <PDBx:temp>" + temp + "</PDBx:temp>\n");
			if (temp_details != null) ow.write(indent + " <PDBx:temp_details>" + temp_details + "</PDBx:temp_details>\n");
			if (temp_esd != null) ow.write(indent + " <PDBx:temp_esd>" + temp_esd + "</PDBx:temp_esd>\n");
			if (time != null) ow.write(indent + " <PDBx:time>" + time + "</PDBx:time>\n");
			ow.write(indent + "</PDBx:exptl_crystal_grow>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
