package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the EXPTL_CRYSTAL_GROW_COMP category record
 *  details about the components of the solutions that were 'mixed'
 *  (by whatever means) to produce the crystal.
 *  
 *  In general, solution 1 is the solution that contains the
 *  molecule to be crystallized and solution 2 is the solution
 *  that contains the precipitant. However, the number of solutions
 *  required to describe the crystallization protocol is not limited
 *  to 2.
 *  
 *  Details of the crystallization protocol should be given in
 *  attribute details in category exptl_crystal_grow_comp using the solutions
 *  described in EXPTL_CRYSTAL_GROW_COMP.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:exptl_crystal_grow_compCategory>
 *  <PDBx:exptl_crystal_grow_comp crystal_id="1" id="1">
 *  <PDBx:sol_id>1</PDBx:sol_id>
 *  <PDBx:name>HIV-1 protease</PDBx:name>
 *  <PDBx:volume>0.002 ml</PDBx:volume>
 *  <PDBx:conc>6 mg/ml</PDBx:conc>
 *  <PDBx:details> The protein solution was in a buffer containing 25 mM NaCl,
 *  100 mM NaMES/ MES buffer, pH 7.5, 3 mM NaAzide</PDBx:details>
 *  </PDBx:exptl_crystal_grow_comp>
 *  <PDBx:exptl_crystal_grow_comp crystal_id="1" id="2">
 *  <PDBx:sol_id>2</PDBx:sol_id>
 *  <PDBx:name>NaCl</PDBx:name>
 *  <PDBx:volume>0.200 ml</PDBx:volume>
 *  <PDBx:conc>4    M</PDBx:conc>
 *  <PDBx:details>in 3 mM NaAzide</PDBx:details>
 *  </PDBx:exptl_crystal_grow_comp>
 *  <PDBx:exptl_crystal_grow_comp crystal_id="1" id="3">
 *  <PDBx:sol_id>2</PDBx:sol_id>
 *  <PDBx:name>Acetic Acid</PDBx:name>
 *  <PDBx:volume>0.047 ml</PDBx:volume>
 *  <PDBx:conc>100 mM</PDBx:conc>
 *  <PDBx:details>in 3 mM NaAzide</PDBx:details>
 *  </PDBx:exptl_crystal_grow_comp>
 *  <PDBx:exptl_crystal_grow_comp crystal_id="1" id="4">
 *  <PDBx:sol_id>2</PDBx:sol_id>
 *  <PDBx:name>Na Acetate</PDBx:name>
 *  <PDBx:volume>0.053 ml</PDBx:volume>
 *  <PDBx:conc>100 mM</PDBx:conc>
 *  <PDBx:details> in 3 mM NaAzide. Buffer components were mixed to produce a
 *  pH of 4.7 according to a ratio calculated from the pKa. The
 *  actual pH of solution 2 was not measured.</PDBx:details>
 *  </PDBx:exptl_crystal_grow_comp>
 *  <PDBx:exptl_crystal_grow_comp crystal_id="1" id="5">
 *  <PDBx:sol_id>2</PDBx:sol_id>
 *  <PDBx:name>water</PDBx:name>
 *  <PDBx:volume>0.700 ml</PDBx:volume>
 *  <PDBx:conc>neat</PDBx:conc>
 *  <PDBx:details>in 3 mM NaAzide</PDBx:details>
 *  </PDBx:exptl_crystal_grow_comp>
 *  </PDBx:exptl_crystal_grow_compCategory>
 * </pre>
 */
public class Exptl_crystal_grow_comp extends org.pdb.beans.Exptl_crystal_grow_comp implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "exptl_crystal_grow_comp";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Exptl_crystal_grow_comp()
	{
	}

	/** Full constructor */
	public Exptl_crystal_grow_comp(
		Datablock datablock,
		java.lang.String conc,
		java.lang.String crystal_id,
		java.lang.String details,
		java.lang.String id_,
		java.lang.String name,
		java.lang.String sol_id,
		java.lang.String volume)
	{
		this.datablock = datablock;
		this.conc = conc;
		this.crystal_id = crystal_id;
		this.details = details;
		this.id_ = id_;
		this.name = name;
		this.sol_id = sol_id;
		this.volume = volume;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Exptl_crystal_grow_comp");
		sb.append("\n");
		if (conc != null)
		{
			sb.append("conc = ");
			sb.append(conc);
			sb.append('\n');
		}
		if (crystal_id != null)
		{
			sb.append("crystal_id = ");
			sb.append(crystal_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (sol_id != null)
		{
			sb.append("sol_id = ");
			sb.append(sol_id);
			sb.append('\n');
		}
		if (volume != null)
		{
			sb.append("volume = ");
			sb.append(volume);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		conc = null;
		crystal_id = null;
		details = null;
		id_ = null;
		name = null;
		sol_id = null;
		volume = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Exptl_crystal_grow_comp)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:exptl_crystal_grow_comp>\n");
			if (conc != null) ow.write(indent + " <PDBx:conc>" + conc + "</PDBx:conc>\n");
			if (crystal_id != null) ow.write(indent + " <PDBx:crystal_id>" + crystal_id + "</PDBx:crystal_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (sol_id != null) ow.write(indent + " <PDBx:sol_id>" + sol_id + "</PDBx:sol_id>\n");
			if (volume != null) ow.write(indent + " <PDBx:volume>" + volume + "</PDBx:volume>\n");
			ow.write(indent + "</PDBx:exptl_crystal_grow_comp>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
