package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the GEOM_ANGLE category record details about the
 *  bond angles as calculated from the contents
 *  of the ATOM, CELL and SYMMETRY data.
 *  
 * <pre>
 *  Example 1 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:geom_angleCategory>
 *  <PDBx:geom_angle atom_site_id_1="C2" atom_site_id_2="O1" atom_site_id_3="C5" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>111.6</PDBx:value>
 *  <PDBx:value_esd>0.2</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="O1" atom_site_id_2="C2" atom_site_id_3="C3" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>110.9</PDBx:value>
 *  <PDBx:value_esd>0.2</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="O1" atom_site_id_2="C2" atom_site_id_3="O21" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>122.2</PDBx:value>
 *  <PDBx:value_esd>0.3</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="C3" atom_site_id_2="C2" atom_site_id_3="O21" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>127.0</PDBx:value>
 *  <PDBx:value_esd>0.3</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="C2" atom_site_id_2="C3" atom_site_id_3="N4" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>101.3</PDBx:value>
 *  <PDBx:value_esd>0.2</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="C2" atom_site_id_2="C3" atom_site_id_3="C31" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>111.3</PDBx:value>
 *  <PDBx:value_esd>0.2</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="C2" atom_site_id_2="C3" atom_site_id_3="H3" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>107.</PDBx:value>
 *  <PDBx:value_esd>1.</PDBx:value_esd>
 *  <PDBx:publ_flag>no</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  <PDBx:geom_angle atom_site_id_1="N4" atom_site_id_2="C3" atom_site_id_3="C31" site_symmetry_1="1_555" site_symmetry_2="1_555" site_symmetry_3="1_555">
 *  <PDBx:value>116.7</PDBx:value>
 *  <PDBx:value_esd>0.2</PDBx:value_esd>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_angle>
 *  </PDBx:geom_angleCategory>
 * </pre>
 */
public class Geom_angle extends org.pdb.beans.Geom_angle implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "geom_angle";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Geom_angle()
	{
	}

	/** Full constructor */
	public Geom_angle(
		Datablock datablock,
		java.lang.String atom_site_auth_asym_id_1,
		java.lang.String atom_site_auth_asym_id_2,
		java.lang.String atom_site_auth_asym_id_3,
		java.lang.String atom_site_auth_atom_id_1,
		java.lang.String atom_site_auth_atom_id_2,
		java.lang.String atom_site_auth_atom_id_3,
		java.lang.String atom_site_auth_comp_id_1,
		java.lang.String atom_site_auth_comp_id_2,
		java.lang.String atom_site_auth_comp_id_3,
		java.lang.String atom_site_auth_seq_id_1,
		java.lang.String atom_site_auth_seq_id_2,
		java.lang.String atom_site_auth_seq_id_3,
		java.lang.String atom_site_id_1,
		java.lang.String atom_site_id_2,
		java.lang.String atom_site_id_3,
		java.lang.String atom_site_label_alt_id_1,
		java.lang.String atom_site_label_alt_id_2,
		java.lang.String atom_site_label_alt_id_3,
		java.lang.String atom_site_label_asym_id_1,
		java.lang.String atom_site_label_asym_id_2,
		java.lang.String atom_site_label_asym_id_3,
		java.lang.String atom_site_label_atom_id_1,
		java.lang.String atom_site_label_atom_id_2,
		java.lang.String atom_site_label_atom_id_3,
		java.lang.String atom_site_label_comp_id_1,
		java.lang.String atom_site_label_comp_id_2,
		java.lang.String atom_site_label_comp_id_3,
		java.lang.Integer atom_site_label_seq_id_1,
		java.lang.Integer atom_site_label_seq_id_2,
		java.lang.Integer atom_site_label_seq_id_3,
		java.lang.Integer pdbx_PDB_model_num,
		java.lang.String pdbx_atom_site_PDB_ins_code_1,
		java.lang.String pdbx_atom_site_PDB_ins_code_2,
		java.lang.String pdbx_atom_site_PDB_ins_code_3,
		java.lang.String publ_flag,
		java.lang.String site_symmetry_1,
		java.lang.String site_symmetry_2,
		java.lang.String site_symmetry_3,
		java.lang.Float value,
		java.lang.Float value_esd)
	{
		this.datablock = datablock;
		this.atom_site_auth_asym_id_1 = atom_site_auth_asym_id_1;
		this.atom_site_auth_asym_id_2 = atom_site_auth_asym_id_2;
		this.atom_site_auth_asym_id_3 = atom_site_auth_asym_id_3;
		this.atom_site_auth_atom_id_1 = atom_site_auth_atom_id_1;
		this.atom_site_auth_atom_id_2 = atom_site_auth_atom_id_2;
		this.atom_site_auth_atom_id_3 = atom_site_auth_atom_id_3;
		this.atom_site_auth_comp_id_1 = atom_site_auth_comp_id_1;
		this.atom_site_auth_comp_id_2 = atom_site_auth_comp_id_2;
		this.atom_site_auth_comp_id_3 = atom_site_auth_comp_id_3;
		this.atom_site_auth_seq_id_1 = atom_site_auth_seq_id_1;
		this.atom_site_auth_seq_id_2 = atom_site_auth_seq_id_2;
		this.atom_site_auth_seq_id_3 = atom_site_auth_seq_id_3;
		this.atom_site_id_1 = atom_site_id_1;
		this.atom_site_id_2 = atom_site_id_2;
		this.atom_site_id_3 = atom_site_id_3;
		this.atom_site_label_alt_id_1 = atom_site_label_alt_id_1;
		this.atom_site_label_alt_id_2 = atom_site_label_alt_id_2;
		this.atom_site_label_alt_id_3 = atom_site_label_alt_id_3;
		this.atom_site_label_asym_id_1 = atom_site_label_asym_id_1;
		this.atom_site_label_asym_id_2 = atom_site_label_asym_id_2;
		this.atom_site_label_asym_id_3 = atom_site_label_asym_id_3;
		this.atom_site_label_atom_id_1 = atom_site_label_atom_id_1;
		this.atom_site_label_atom_id_2 = atom_site_label_atom_id_2;
		this.atom_site_label_atom_id_3 = atom_site_label_atom_id_3;
		this.atom_site_label_comp_id_1 = atom_site_label_comp_id_1;
		this.atom_site_label_comp_id_2 = atom_site_label_comp_id_2;
		this.atom_site_label_comp_id_3 = atom_site_label_comp_id_3;
		this.atom_site_label_seq_id_1 = atom_site_label_seq_id_1;
		this.atom_site_label_seq_id_2 = atom_site_label_seq_id_2;
		this.atom_site_label_seq_id_3 = atom_site_label_seq_id_3;
		this.pdbx_PDB_model_num = pdbx_PDB_model_num;
		this.pdbx_atom_site_PDB_ins_code_1 = pdbx_atom_site_PDB_ins_code_1;
		this.pdbx_atom_site_PDB_ins_code_2 = pdbx_atom_site_PDB_ins_code_2;
		this.pdbx_atom_site_PDB_ins_code_3 = pdbx_atom_site_PDB_ins_code_3;
		this.publ_flag = publ_flag;
		this.site_symmetry_1 = site_symmetry_1;
		this.site_symmetry_2 = site_symmetry_2;
		this.site_symmetry_3 = site_symmetry_3;
		this.value = value;
		this.value_esd = value_esd;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Geom_angle");
		sb.append("\n");
		if (atom_site_auth_asym_id_1 != null)
		{
			sb.append("atom_site_auth_asym_id_1 = ");
			sb.append(atom_site_auth_asym_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_asym_id_2 != null)
		{
			sb.append("atom_site_auth_asym_id_2 = ");
			sb.append(atom_site_auth_asym_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_asym_id_3 != null)
		{
			sb.append("atom_site_auth_asym_id_3 = ");
			sb.append(atom_site_auth_asym_id_3);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_1 != null)
		{
			sb.append("atom_site_auth_atom_id_1 = ");
			sb.append(atom_site_auth_atom_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_2 != null)
		{
			sb.append("atom_site_auth_atom_id_2 = ");
			sb.append(atom_site_auth_atom_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_3 != null)
		{
			sb.append("atom_site_auth_atom_id_3 = ");
			sb.append(atom_site_auth_atom_id_3);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_1 != null)
		{
			sb.append("atom_site_auth_comp_id_1 = ");
			sb.append(atom_site_auth_comp_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_2 != null)
		{
			sb.append("atom_site_auth_comp_id_2 = ");
			sb.append(atom_site_auth_comp_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_3 != null)
		{
			sb.append("atom_site_auth_comp_id_3 = ");
			sb.append(atom_site_auth_comp_id_3);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_1 != null)
		{
			sb.append("atom_site_auth_seq_id_1 = ");
			sb.append(atom_site_auth_seq_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_2 != null)
		{
			sb.append("atom_site_auth_seq_id_2 = ");
			sb.append(atom_site_auth_seq_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_3 != null)
		{
			sb.append("atom_site_auth_seq_id_3 = ");
			sb.append(atom_site_auth_seq_id_3);
			sb.append('\n');
		}
		if (atom_site_id_1 != null)
		{
			sb.append("atom_site_id_1 = ");
			sb.append(atom_site_id_1);
			sb.append('\n');
		}
		if (atom_site_id_2 != null)
		{
			sb.append("atom_site_id_2 = ");
			sb.append(atom_site_id_2);
			sb.append('\n');
		}
		if (atom_site_id_3 != null)
		{
			sb.append("atom_site_id_3 = ");
			sb.append(atom_site_id_3);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_1 != null)
		{
			sb.append("atom_site_label_alt_id_1 = ");
			sb.append(atom_site_label_alt_id_1);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_2 != null)
		{
			sb.append("atom_site_label_alt_id_2 = ");
			sb.append(atom_site_label_alt_id_2);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_3 != null)
		{
			sb.append("atom_site_label_alt_id_3 = ");
			sb.append(atom_site_label_alt_id_3);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_1 != null)
		{
			sb.append("atom_site_label_asym_id_1 = ");
			sb.append(atom_site_label_asym_id_1);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_2 != null)
		{
			sb.append("atom_site_label_asym_id_2 = ");
			sb.append(atom_site_label_asym_id_2);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_3 != null)
		{
			sb.append("atom_site_label_asym_id_3 = ");
			sb.append(atom_site_label_asym_id_3);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_1 != null)
		{
			sb.append("atom_site_label_atom_id_1 = ");
			sb.append(atom_site_label_atom_id_1);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_2 != null)
		{
			sb.append("atom_site_label_atom_id_2 = ");
			sb.append(atom_site_label_atom_id_2);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_3 != null)
		{
			sb.append("atom_site_label_atom_id_3 = ");
			sb.append(atom_site_label_atom_id_3);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_1 != null)
		{
			sb.append("atom_site_label_comp_id_1 = ");
			sb.append(atom_site_label_comp_id_1);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_2 != null)
		{
			sb.append("atom_site_label_comp_id_2 = ");
			sb.append(atom_site_label_comp_id_2);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_3 != null)
		{
			sb.append("atom_site_label_comp_id_3 = ");
			sb.append(atom_site_label_comp_id_3);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_1 != null)
		{
			sb.append("atom_site_label_seq_id_1 = ");
			sb.append(atom_site_label_seq_id_1);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_2 != null)
		{
			sb.append("atom_site_label_seq_id_2 = ");
			sb.append(atom_site_label_seq_id_2);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_3 != null)
		{
			sb.append("atom_site_label_seq_id_3 = ");
			sb.append(atom_site_label_seq_id_3);
			sb.append('\n');
		}
		if (pdbx_PDB_model_num != null)
		{
			sb.append("pdbx_PDB_model_num = ");
			sb.append(pdbx_PDB_model_num);
			sb.append('\n');
		}
		if (pdbx_atom_site_PDB_ins_code_1 != null)
		{
			sb.append("pdbx_atom_site_PDB_ins_code_1 = ");
			sb.append(pdbx_atom_site_PDB_ins_code_1);
			sb.append('\n');
		}
		if (pdbx_atom_site_PDB_ins_code_2 != null)
		{
			sb.append("pdbx_atom_site_PDB_ins_code_2 = ");
			sb.append(pdbx_atom_site_PDB_ins_code_2);
			sb.append('\n');
		}
		if (pdbx_atom_site_PDB_ins_code_3 != null)
		{
			sb.append("pdbx_atom_site_PDB_ins_code_3 = ");
			sb.append(pdbx_atom_site_PDB_ins_code_3);
			sb.append('\n');
		}
		if (publ_flag != null)
		{
			sb.append("publ_flag = ");
			sb.append(publ_flag);
			sb.append('\n');
		}
		if (site_symmetry_1 != null)
		{
			sb.append("site_symmetry_1 = ");
			sb.append(site_symmetry_1);
			sb.append('\n');
		}
		if (site_symmetry_2 != null)
		{
			sb.append("site_symmetry_2 = ");
			sb.append(site_symmetry_2);
			sb.append('\n');
		}
		if (site_symmetry_3 != null)
		{
			sb.append("site_symmetry_3 = ");
			sb.append(site_symmetry_3);
			sb.append('\n');
		}
		if (value != null)
		{
			sb.append("value = ");
			sb.append(value);
			sb.append('\n');
		}
		if (value_esd != null)
		{
			sb.append("value_esd = ");
			sb.append(value_esd);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_site_auth_asym_id_1 = null;
		atom_site_auth_asym_id_2 = null;
		atom_site_auth_asym_id_3 = null;
		atom_site_auth_atom_id_1 = null;
		atom_site_auth_atom_id_2 = null;
		atom_site_auth_atom_id_3 = null;
		atom_site_auth_comp_id_1 = null;
		atom_site_auth_comp_id_2 = null;
		atom_site_auth_comp_id_3 = null;
		atom_site_auth_seq_id_1 = null;
		atom_site_auth_seq_id_2 = null;
		atom_site_auth_seq_id_3 = null;
		atom_site_id_1 = null;
		atom_site_id_2 = null;
		atom_site_id_3 = null;
		atom_site_label_alt_id_1 = null;
		atom_site_label_alt_id_2 = null;
		atom_site_label_alt_id_3 = null;
		atom_site_label_asym_id_1 = null;
		atom_site_label_asym_id_2 = null;
		atom_site_label_asym_id_3 = null;
		atom_site_label_atom_id_1 = null;
		atom_site_label_atom_id_2 = null;
		atom_site_label_atom_id_3 = null;
		atom_site_label_comp_id_1 = null;
		atom_site_label_comp_id_2 = null;
		atom_site_label_comp_id_3 = null;
		atom_site_label_seq_id_1 = null;
		atom_site_label_seq_id_2 = null;
		atom_site_label_seq_id_3 = null;
		pdbx_PDB_model_num = null;
		pdbx_atom_site_PDB_ins_code_1 = null;
		pdbx_atom_site_PDB_ins_code_2 = null;
		pdbx_atom_site_PDB_ins_code_3 = null;
		publ_flag = null;
		site_symmetry_1 = null;
		site_symmetry_2 = null;
		site_symmetry_3 = null;
		value = null;
		value_esd = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Geom_angle)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:geom_angle>\n");
			if (atom_site_auth_asym_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_1>" + atom_site_auth_asym_id_1 + "</PDBx:atom_site_auth_asym_id_1>\n");
			if (atom_site_auth_asym_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_2>" + atom_site_auth_asym_id_2 + "</PDBx:atom_site_auth_asym_id_2>\n");
			if (atom_site_auth_asym_id_3 != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_3>" + atom_site_auth_asym_id_3 + "</PDBx:atom_site_auth_asym_id_3>\n");
			if (atom_site_auth_atom_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_1>" + atom_site_auth_atom_id_1 + "</PDBx:atom_site_auth_atom_id_1>\n");
			if (atom_site_auth_atom_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_2>" + atom_site_auth_atom_id_2 + "</PDBx:atom_site_auth_atom_id_2>\n");
			if (atom_site_auth_atom_id_3 != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_3>" + atom_site_auth_atom_id_3 + "</PDBx:atom_site_auth_atom_id_3>\n");
			if (atom_site_auth_comp_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_1>" + atom_site_auth_comp_id_1 + "</PDBx:atom_site_auth_comp_id_1>\n");
			if (atom_site_auth_comp_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_2>" + atom_site_auth_comp_id_2 + "</PDBx:atom_site_auth_comp_id_2>\n");
			if (atom_site_auth_comp_id_3 != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_3>" + atom_site_auth_comp_id_3 + "</PDBx:atom_site_auth_comp_id_3>\n");
			if (atom_site_auth_seq_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_1>" + atom_site_auth_seq_id_1 + "</PDBx:atom_site_auth_seq_id_1>\n");
			if (atom_site_auth_seq_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_2>" + atom_site_auth_seq_id_2 + "</PDBx:atom_site_auth_seq_id_2>\n");
			if (atom_site_auth_seq_id_3 != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_3>" + atom_site_auth_seq_id_3 + "</PDBx:atom_site_auth_seq_id_3>\n");
			if (atom_site_id_1 != null) ow.write(indent + " <PDBx:atom_site_id_1>" + atom_site_id_1 + "</PDBx:atom_site_id_1>\n");
			if (atom_site_id_2 != null) ow.write(indent + " <PDBx:atom_site_id_2>" + atom_site_id_2 + "</PDBx:atom_site_id_2>\n");
			if (atom_site_id_3 != null) ow.write(indent + " <PDBx:atom_site_id_3>" + atom_site_id_3 + "</PDBx:atom_site_id_3>\n");
			if (atom_site_label_alt_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_1>" + atom_site_label_alt_id_1 + "</PDBx:atom_site_label_alt_id_1>\n");
			if (atom_site_label_alt_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_2>" + atom_site_label_alt_id_2 + "</PDBx:atom_site_label_alt_id_2>\n");
			if (atom_site_label_alt_id_3 != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_3>" + atom_site_label_alt_id_3 + "</PDBx:atom_site_label_alt_id_3>\n");
			if (atom_site_label_asym_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_1>" + atom_site_label_asym_id_1 + "</PDBx:atom_site_label_asym_id_1>\n");
			if (atom_site_label_asym_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_2>" + atom_site_label_asym_id_2 + "</PDBx:atom_site_label_asym_id_2>\n");
			if (atom_site_label_asym_id_3 != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_3>" + atom_site_label_asym_id_3 + "</PDBx:atom_site_label_asym_id_3>\n");
			if (atom_site_label_atom_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_1>" + atom_site_label_atom_id_1 + "</PDBx:atom_site_label_atom_id_1>\n");
			if (atom_site_label_atom_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_2>" + atom_site_label_atom_id_2 + "</PDBx:atom_site_label_atom_id_2>\n");
			if (atom_site_label_atom_id_3 != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_3>" + atom_site_label_atom_id_3 + "</PDBx:atom_site_label_atom_id_3>\n");
			if (atom_site_label_comp_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_1>" + atom_site_label_comp_id_1 + "</PDBx:atom_site_label_comp_id_1>\n");
			if (atom_site_label_comp_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_2>" + atom_site_label_comp_id_2 + "</PDBx:atom_site_label_comp_id_2>\n");
			if (atom_site_label_comp_id_3 != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_3>" + atom_site_label_comp_id_3 + "</PDBx:atom_site_label_comp_id_3>\n");
			if (atom_site_label_seq_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_1>" + atom_site_label_seq_id_1 + "</PDBx:atom_site_label_seq_id_1>\n");
			if (atom_site_label_seq_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_2>" + atom_site_label_seq_id_2 + "</PDBx:atom_site_label_seq_id_2>\n");
			if (atom_site_label_seq_id_3 != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_3>" + atom_site_label_seq_id_3 + "</PDBx:atom_site_label_seq_id_3>\n");
			if (pdbx_PDB_model_num != null) ow.write(indent + " <PDBx:pdbx_PDB_model_num>" + pdbx_PDB_model_num + "</PDBx:pdbx_PDB_model_num>\n");
			if (pdbx_atom_site_PDB_ins_code_1 != null) ow.write(indent + " <PDBx:pdbx_atom_site_PDB_ins_code_1>" + pdbx_atom_site_PDB_ins_code_1 + "</PDBx:pdbx_atom_site_PDB_ins_code_1>\n");
			if (pdbx_atom_site_PDB_ins_code_2 != null) ow.write(indent + " <PDBx:pdbx_atom_site_PDB_ins_code_2>" + pdbx_atom_site_PDB_ins_code_2 + "</PDBx:pdbx_atom_site_PDB_ins_code_2>\n");
			if (pdbx_atom_site_PDB_ins_code_3 != null) ow.write(indent + " <PDBx:pdbx_atom_site_PDB_ins_code_3>" + pdbx_atom_site_PDB_ins_code_3 + "</PDBx:pdbx_atom_site_PDB_ins_code_3>\n");
			if (publ_flag != null) ow.write(indent + " <PDBx:publ_flag>" + publ_flag + "</PDBx:publ_flag>\n");
			if (site_symmetry_1 != null) ow.write(indent + " <PDBx:site_symmetry_1>" + site_symmetry_1 + "</PDBx:site_symmetry_1>\n");
			if (site_symmetry_2 != null) ow.write(indent + " <PDBx:site_symmetry_2>" + site_symmetry_2 + "</PDBx:site_symmetry_2>\n");
			if (site_symmetry_3 != null) ow.write(indent + " <PDBx:site_symmetry_3>" + site_symmetry_3 + "</PDBx:site_symmetry_3>\n");
			if (value != null) ow.write(indent + " <PDBx:value>" + value + "</PDBx:value>\n");
			if (value_esd != null) ow.write(indent + " <PDBx:value_esd>" + value_esd + "</PDBx:value_esd>\n");
			ow.write(indent + "</PDBx:geom_angle>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
