package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the GEOM_TORSION category record details about
 *  torsion angles as calculated from the
 *  contents of the ATOM, CELL and SYMMETRY data.
 *  
 *  The vector direction  attribute atom_site_id_2 in category geom_torsion to
 *  attribute atom_site_id_3 in category geom_torsion is the viewing direction, and the
 *  torsion angle is the angle of twist required to superimpose the
 *  projection of the vector between site 2 and site 1 onto the
 *  projection of the vector between site 3 and site 4. Clockwise
 *  torsions are positive, anticlockwise torsions are negative.
 *  
 *  Ref: Klyne, W. & Prelog, V. (1960). Experientia, 16, 521-523.
 *  
 * <pre>
 *  Example 1 - based on data set CLPHO6 of Ferguson, Ruhl, McKervey & Browne
 *  [Acta Cryst. (1992), C48, 2262-2264].
 *  <PDBx:geom_torsionCategory>
 *  <PDBx:geom_torsion atom_site_id_1="C(9)" atom_site_id_2="O(2)" atom_site_id_3="C(7)" atom_site_id_4="C(2)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="">
 *  <PDBx:value>71.8</PDBx:value>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  <PDBx:geom_torsion atom_site_id_1="C(7)" atom_site_id_2="O(2)" atom_site_id_3="C(9)" atom_site_id_4="C(10)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="2_666">
 *  <PDBx:value>-168.0</PDBx:value>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  <PDBx:geom_torsion atom_site_id_1="C(10)" atom_site_id_2="O(3)" atom_site_id_3="C(8)" atom_site_id_4="C(6)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="">
 *  <PDBx:value>-167.7</PDBx:value>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  <PDBx:geom_torsion atom_site_id_1="C(8)" atom_site_id_2="O(3)" atom_site_id_3="C(10)" atom_site_id_4="C(9)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="2_666">
 *  <PDBx:value>-69.7</PDBx:value>
 *  <PDBx:publ_flag>yes</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  <PDBx:geom_torsion atom_site_id_1="O(1)" atom_site_id_2="C(1)" atom_site_id_3="C(2)" atom_site_id_4="C(3)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="">
 *  <PDBx:value>-179.5</PDBx:value>
 *  <PDBx:publ_flag>no</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  <PDBx:geom_torsion atom_site_id_1="O(1)" atom_site_id_2="C(1)" atom_site_id_3="C(2)" atom_site_id_4="C(7)" site_symmetry_1="" site_symmetry_2="" site_symmetry_3="" site_symmetry_4="">
 *  <PDBx:value>-0.6</PDBx:value>
 *  <PDBx:publ_flag>no</PDBx:publ_flag>
 *  </PDBx:geom_torsion>
 *  </PDBx:geom_torsionCategory>
 * </pre>
 */
public class Geom_torsion extends org.pdb.beans.Geom_torsion implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "geom_torsion";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Geom_torsion()
	{
	}

	/** Full constructor */
	public Geom_torsion(
		Datablock datablock,
		java.lang.String atom_site_auth_asym_id_1,
		java.lang.String atom_site_auth_asym_id_2,
		java.lang.String atom_site_auth_asym_id_3,
		java.lang.String atom_site_auth_asym_id_4,
		java.lang.String atom_site_auth_atom_id_1,
		java.lang.String atom_site_auth_atom_id_2,
		java.lang.String atom_site_auth_atom_id_3,
		java.lang.String atom_site_auth_atom_id_4,
		java.lang.String atom_site_auth_comp_id_1,
		java.lang.String atom_site_auth_comp_id_2,
		java.lang.String atom_site_auth_comp_id_3,
		java.lang.String atom_site_auth_comp_id_4,
		java.lang.String atom_site_auth_seq_id_1,
		java.lang.String atom_site_auth_seq_id_2,
		java.lang.String atom_site_auth_seq_id_3,
		java.lang.String atom_site_auth_seq_id_4,
		java.lang.String atom_site_id_1,
		java.lang.String atom_site_id_2,
		java.lang.String atom_site_id_3,
		java.lang.String atom_site_id_4,
		java.lang.String atom_site_label_alt_id_1,
		java.lang.String atom_site_label_alt_id_2,
		java.lang.String atom_site_label_alt_id_3,
		java.lang.String atom_site_label_alt_id_4,
		java.lang.String atom_site_label_asym_id_1,
		java.lang.String atom_site_label_asym_id_2,
		java.lang.String atom_site_label_asym_id_3,
		java.lang.String atom_site_label_asym_id_4,
		java.lang.String atom_site_label_atom_id_1,
		java.lang.String atom_site_label_atom_id_2,
		java.lang.String atom_site_label_atom_id_3,
		java.lang.String atom_site_label_atom_id_4,
		java.lang.String atom_site_label_comp_id_1,
		java.lang.String atom_site_label_comp_id_2,
		java.lang.String atom_site_label_comp_id_3,
		java.lang.String atom_site_label_comp_id_4,
		java.lang.Integer atom_site_label_seq_id_1,
		java.lang.Integer atom_site_label_seq_id_2,
		java.lang.Integer atom_site_label_seq_id_3,
		java.lang.Integer atom_site_label_seq_id_4,
		java.lang.Integer pdbx_PDB_model_num,
		java.lang.String pdbx_atom_site_PDB_ins_code_1,
		java.lang.String pdbx_atom_site_PDB_ins_code_2,
		java.lang.String pdbx_atom_site_PDB_ins_code_3,
		java.lang.String pdbx_atom_site_PDB_ins_code_4,
		java.lang.String publ_flag,
		java.lang.String site_symmetry_1,
		java.lang.String site_symmetry_2,
		java.lang.String site_symmetry_3,
		java.lang.String site_symmetry_4,
		java.lang.Float value,
		java.lang.Float value_esd)
	{
		this.datablock = datablock;
		this.atom_site_auth_asym_id_1 = atom_site_auth_asym_id_1;
		this.atom_site_auth_asym_id_2 = atom_site_auth_asym_id_2;
		this.atom_site_auth_asym_id_3 = atom_site_auth_asym_id_3;
		this.atom_site_auth_asym_id_4 = atom_site_auth_asym_id_4;
		this.atom_site_auth_atom_id_1 = atom_site_auth_atom_id_1;
		this.atom_site_auth_atom_id_2 = atom_site_auth_atom_id_2;
		this.atom_site_auth_atom_id_3 = atom_site_auth_atom_id_3;
		this.atom_site_auth_atom_id_4 = atom_site_auth_atom_id_4;
		this.atom_site_auth_comp_id_1 = atom_site_auth_comp_id_1;
		this.atom_site_auth_comp_id_2 = atom_site_auth_comp_id_2;
		this.atom_site_auth_comp_id_3 = atom_site_auth_comp_id_3;
		this.atom_site_auth_comp_id_4 = atom_site_auth_comp_id_4;
		this.atom_site_auth_seq_id_1 = atom_site_auth_seq_id_1;
		this.atom_site_auth_seq_id_2 = atom_site_auth_seq_id_2;
		this.atom_site_auth_seq_id_3 = atom_site_auth_seq_id_3;
		this.atom_site_auth_seq_id_4 = atom_site_auth_seq_id_4;
		this.atom_site_id_1 = atom_site_id_1;
		this.atom_site_id_2 = atom_site_id_2;
		this.atom_site_id_3 = atom_site_id_3;
		this.atom_site_id_4 = atom_site_id_4;
		this.atom_site_label_alt_id_1 = atom_site_label_alt_id_1;
		this.atom_site_label_alt_id_2 = atom_site_label_alt_id_2;
		this.atom_site_label_alt_id_3 = atom_site_label_alt_id_3;
		this.atom_site_label_alt_id_4 = atom_site_label_alt_id_4;
		this.atom_site_label_asym_id_1 = atom_site_label_asym_id_1;
		this.atom_site_label_asym_id_2 = atom_site_label_asym_id_2;
		this.atom_site_label_asym_id_3 = atom_site_label_asym_id_3;
		this.atom_site_label_asym_id_4 = atom_site_label_asym_id_4;
		this.atom_site_label_atom_id_1 = atom_site_label_atom_id_1;
		this.atom_site_label_atom_id_2 = atom_site_label_atom_id_2;
		this.atom_site_label_atom_id_3 = atom_site_label_atom_id_3;
		this.atom_site_label_atom_id_4 = atom_site_label_atom_id_4;
		this.atom_site_label_comp_id_1 = atom_site_label_comp_id_1;
		this.atom_site_label_comp_id_2 = atom_site_label_comp_id_2;
		this.atom_site_label_comp_id_3 = atom_site_label_comp_id_3;
		this.atom_site_label_comp_id_4 = atom_site_label_comp_id_4;
		this.atom_site_label_seq_id_1 = atom_site_label_seq_id_1;
		this.atom_site_label_seq_id_2 = atom_site_label_seq_id_2;
		this.atom_site_label_seq_id_3 = atom_site_label_seq_id_3;
		this.atom_site_label_seq_id_4 = atom_site_label_seq_id_4;
		this.pdbx_PDB_model_num = pdbx_PDB_model_num;
		this.pdbx_atom_site_PDB_ins_code_1 = pdbx_atom_site_PDB_ins_code_1;
		this.pdbx_atom_site_PDB_ins_code_2 = pdbx_atom_site_PDB_ins_code_2;
		this.pdbx_atom_site_PDB_ins_code_3 = pdbx_atom_site_PDB_ins_code_3;
		this.pdbx_atom_site_PDB_ins_code_4 = pdbx_atom_site_PDB_ins_code_4;
		this.publ_flag = publ_flag;
		this.site_symmetry_1 = site_symmetry_1;
		this.site_symmetry_2 = site_symmetry_2;
		this.site_symmetry_3 = site_symmetry_3;
		this.site_symmetry_4 = site_symmetry_4;
		this.value = value;
		this.value_esd = value_esd;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Geom_torsion");
		sb.append("\n");
		if (atom_site_auth_asym_id_1 != null)
		{
			sb.append("atom_site_auth_asym_id_1 = ");
			sb.append(atom_site_auth_asym_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_asym_id_2 != null)
		{
			sb.append("atom_site_auth_asym_id_2 = ");
			sb.append(atom_site_auth_asym_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_asym_id_3 != null)
		{
			sb.append("atom_site_auth_asym_id_3 = ");
			sb.append(atom_site_auth_asym_id_3);
			sb.append('\n');
		}
		if (atom_site_auth_asym_id_4 != null)
		{
			sb.append("atom_site_auth_asym_id_4 = ");
			sb.append(atom_site_auth_asym_id_4);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_1 != null)
		{
			sb.append("atom_site_auth_atom_id_1 = ");
			sb.append(atom_site_auth_atom_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_2 != null)
		{
			sb.append("atom_site_auth_atom_id_2 = ");
			sb.append(atom_site_auth_atom_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_3 != null)
		{
			sb.append("atom_site_auth_atom_id_3 = ");
			sb.append(atom_site_auth_atom_id_3);
			sb.append('\n');
		}
		if (atom_site_auth_atom_id_4 != null)
		{
			sb.append("atom_site_auth_atom_id_4 = ");
			sb.append(atom_site_auth_atom_id_4);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_1 != null)
		{
			sb.append("atom_site_auth_comp_id_1 = ");
			sb.append(atom_site_auth_comp_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_2 != null)
		{
			sb.append("atom_site_auth_comp_id_2 = ");
			sb.append(atom_site_auth_comp_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_3 != null)
		{
			sb.append("atom_site_auth_comp_id_3 = ");
			sb.append(atom_site_auth_comp_id_3);
			sb.append('\n');
		}
		if (atom_site_auth_comp_id_4 != null)
		{
			sb.append("atom_site_auth_comp_id_4 = ");
			sb.append(atom_site_auth_comp_id_4);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_1 != null)
		{
			sb.append("atom_site_auth_seq_id_1 = ");
			sb.append(atom_site_auth_seq_id_1);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_2 != null)
		{
			sb.append("atom_site_auth_seq_id_2 = ");
			sb.append(atom_site_auth_seq_id_2);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_3 != null)
		{
			sb.append("atom_site_auth_seq_id_3 = ");
			sb.append(atom_site_auth_seq_id_3);
			sb.append('\n');
		}
		if (atom_site_auth_seq_id_4 != null)
		{
			sb.append("atom_site_auth_seq_id_4 = ");
			sb.append(atom_site_auth_seq_id_4);
			sb.append('\n');
		}
		if (atom_site_id_1 != null)
		{
			sb.append("atom_site_id_1 = ");
			sb.append(atom_site_id_1);
			sb.append('\n');
		}
		if (atom_site_id_2 != null)
		{
			sb.append("atom_site_id_2 = ");
			sb.append(atom_site_id_2);
			sb.append('\n');
		}
		if (atom_site_id_3 != null)
		{
			sb.append("atom_site_id_3 = ");
			sb.append(atom_site_id_3);
			sb.append('\n');
		}
		if (atom_site_id_4 != null)
		{
			sb.append("atom_site_id_4 = ");
			sb.append(atom_site_id_4);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_1 != null)
		{
			sb.append("atom_site_label_alt_id_1 = ");
			sb.append(atom_site_label_alt_id_1);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_2 != null)
		{
			sb.append("atom_site_label_alt_id_2 = ");
			sb.append(atom_site_label_alt_id_2);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_3 != null)
		{
			sb.append("atom_site_label_alt_id_3 = ");
			sb.append(atom_site_label_alt_id_3);
			sb.append('\n');
		}
		if (atom_site_label_alt_id_4 != null)
		{
			sb.append("atom_site_label_alt_id_4 = ");
			sb.append(atom_site_label_alt_id_4);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_1 != null)
		{
			sb.append("atom_site_label_asym_id_1 = ");
			sb.append(atom_site_label_asym_id_1);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_2 != null)
		{
			sb.append("atom_site_label_asym_id_2 = ");
			sb.append(atom_site_label_asym_id_2);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_3 != null)
		{
			sb.append("atom_site_label_asym_id_3 = ");
			sb.append(atom_site_label_asym_id_3);
			sb.append('\n');
		}
		if (atom_site_label_asym_id_4 != null)
		{
			sb.append("atom_site_label_asym_id_4 = ");
			sb.append(atom_site_label_asym_id_4);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_1 != null)
		{
			sb.append("atom_site_label_atom_id_1 = ");
			sb.append(atom_site_label_atom_id_1);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_2 != null)
		{
			sb.append("atom_site_label_atom_id_2 = ");
			sb.append(atom_site_label_atom_id_2);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_3 != null)
		{
			sb.append("atom_site_label_atom_id_3 = ");
			sb.append(atom_site_label_atom_id_3);
			sb.append('\n');
		}
		if (atom_site_label_atom_id_4 != null)
		{
			sb.append("atom_site_label_atom_id_4 = ");
			sb.append(atom_site_label_atom_id_4);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_1 != null)
		{
			sb.append("atom_site_label_comp_id_1 = ");
			sb.append(atom_site_label_comp_id_1);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_2 != null)
		{
			sb.append("atom_site_label_comp_id_2 = ");
			sb.append(atom_site_label_comp_id_2);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_3 != null)
		{
			sb.append("atom_site_label_comp_id_3 = ");
			sb.append(atom_site_label_comp_id_3);
			sb.append('\n');
		}
		if (atom_site_label_comp_id_4 != null)
		{
			sb.append("atom_site_label_comp_id_4 = ");
			sb.append(atom_site_label_comp_id_4);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_1 != null)
		{
			sb.append("atom_site_label_seq_id_1 = ");
			sb.append(atom_site_label_seq_id_1);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_2 != null)
		{
			sb.append("atom_site_label_seq_id_2 = ");
			sb.append(atom_site_label_seq_id_2);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_3 != null)
		{
			sb.append("atom_site_label_seq_id_3 = ");
			sb.append(atom_site_label_seq_id_3);
			sb.append('\n');
		}
		if (atom_site_label_seq_id_4 != null)
		{
			sb.append("atom_site_label_seq_id_4 = ");
			sb.append(atom_site_label_seq_id_4);
			sb.append('\n');
		}
		if (pdbx_PDB_model_num != null)
		{
			sb.append("pdbx_PDB_model_num = ");
			sb.append(pdbx_PDB_model_num);
			sb.append('\n');
		}
		if (pdbx_atom_site_PDB_ins_code_1 != null)
		{
			sb.append("pdbx_atom_site_PDB_ins_code_1 = ");
			sb.append(pdbx_atom_site_PDB_ins_code_1);
			sb.append('\n');
		}
		if (pdbx_atom_site_PDB_ins_code_2 != null)
		{
			sb.append("pdbx_atom_site_PDB_ins_code_2 = ");
			sb.append(pdbx_atom_site_PDB_ins_code_2);
			sb.append('\n');
		}
		if (pdbx_atom_site_PDB_ins_code_3 != null)
		{
			sb.append("pdbx_atom_site_PDB_ins_code_3 = ");
			sb.append(pdbx_atom_site_PDB_ins_code_3);
			sb.append('\n');
		}
		if (pdbx_atom_site_PDB_ins_code_4 != null)
		{
			sb.append("pdbx_atom_site_PDB_ins_code_4 = ");
			sb.append(pdbx_atom_site_PDB_ins_code_4);
			sb.append('\n');
		}
		if (publ_flag != null)
		{
			sb.append("publ_flag = ");
			sb.append(publ_flag);
			sb.append('\n');
		}
		if (site_symmetry_1 != null)
		{
			sb.append("site_symmetry_1 = ");
			sb.append(site_symmetry_1);
			sb.append('\n');
		}
		if (site_symmetry_2 != null)
		{
			sb.append("site_symmetry_2 = ");
			sb.append(site_symmetry_2);
			sb.append('\n');
		}
		if (site_symmetry_3 != null)
		{
			sb.append("site_symmetry_3 = ");
			sb.append(site_symmetry_3);
			sb.append('\n');
		}
		if (site_symmetry_4 != null)
		{
			sb.append("site_symmetry_4 = ");
			sb.append(site_symmetry_4);
			sb.append('\n');
		}
		if (value != null)
		{
			sb.append("value = ");
			sb.append(value);
			sb.append('\n');
		}
		if (value_esd != null)
		{
			sb.append("value_esd = ");
			sb.append(value_esd);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		atom_site_auth_asym_id_1 = null;
		atom_site_auth_asym_id_2 = null;
		atom_site_auth_asym_id_3 = null;
		atom_site_auth_asym_id_4 = null;
		atom_site_auth_atom_id_1 = null;
		atom_site_auth_atom_id_2 = null;
		atom_site_auth_atom_id_3 = null;
		atom_site_auth_atom_id_4 = null;
		atom_site_auth_comp_id_1 = null;
		atom_site_auth_comp_id_2 = null;
		atom_site_auth_comp_id_3 = null;
		atom_site_auth_comp_id_4 = null;
		atom_site_auth_seq_id_1 = null;
		atom_site_auth_seq_id_2 = null;
		atom_site_auth_seq_id_3 = null;
		atom_site_auth_seq_id_4 = null;
		atom_site_id_1 = null;
		atom_site_id_2 = null;
		atom_site_id_3 = null;
		atom_site_id_4 = null;
		atom_site_label_alt_id_1 = null;
		atom_site_label_alt_id_2 = null;
		atom_site_label_alt_id_3 = null;
		atom_site_label_alt_id_4 = null;
		atom_site_label_asym_id_1 = null;
		atom_site_label_asym_id_2 = null;
		atom_site_label_asym_id_3 = null;
		atom_site_label_asym_id_4 = null;
		atom_site_label_atom_id_1 = null;
		atom_site_label_atom_id_2 = null;
		atom_site_label_atom_id_3 = null;
		atom_site_label_atom_id_4 = null;
		atom_site_label_comp_id_1 = null;
		atom_site_label_comp_id_2 = null;
		atom_site_label_comp_id_3 = null;
		atom_site_label_comp_id_4 = null;
		atom_site_label_seq_id_1 = null;
		atom_site_label_seq_id_2 = null;
		atom_site_label_seq_id_3 = null;
		atom_site_label_seq_id_4 = null;
		pdbx_PDB_model_num = null;
		pdbx_atom_site_PDB_ins_code_1 = null;
		pdbx_atom_site_PDB_ins_code_2 = null;
		pdbx_atom_site_PDB_ins_code_3 = null;
		pdbx_atom_site_PDB_ins_code_4 = null;
		publ_flag = null;
		site_symmetry_1 = null;
		site_symmetry_2 = null;
		site_symmetry_3 = null;
		site_symmetry_4 = null;
		value = null;
		value_esd = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Geom_torsion)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:geom_torsion>\n");
			if (atom_site_auth_asym_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_1>" + atom_site_auth_asym_id_1 + "</PDBx:atom_site_auth_asym_id_1>\n");
			if (atom_site_auth_asym_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_2>" + atom_site_auth_asym_id_2 + "</PDBx:atom_site_auth_asym_id_2>\n");
			if (atom_site_auth_asym_id_3 != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_3>" + atom_site_auth_asym_id_3 + "</PDBx:atom_site_auth_asym_id_3>\n");
			if (atom_site_auth_asym_id_4 != null) ow.write(indent + " <PDBx:atom_site_auth_asym_id_4>" + atom_site_auth_asym_id_4 + "</PDBx:atom_site_auth_asym_id_4>\n");
			if (atom_site_auth_atom_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_1>" + atom_site_auth_atom_id_1 + "</PDBx:atom_site_auth_atom_id_1>\n");
			if (atom_site_auth_atom_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_2>" + atom_site_auth_atom_id_2 + "</PDBx:atom_site_auth_atom_id_2>\n");
			if (atom_site_auth_atom_id_3 != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_3>" + atom_site_auth_atom_id_3 + "</PDBx:atom_site_auth_atom_id_3>\n");
			if (atom_site_auth_atom_id_4 != null) ow.write(indent + " <PDBx:atom_site_auth_atom_id_4>" + atom_site_auth_atom_id_4 + "</PDBx:atom_site_auth_atom_id_4>\n");
			if (atom_site_auth_comp_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_1>" + atom_site_auth_comp_id_1 + "</PDBx:atom_site_auth_comp_id_1>\n");
			if (atom_site_auth_comp_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_2>" + atom_site_auth_comp_id_2 + "</PDBx:atom_site_auth_comp_id_2>\n");
			if (atom_site_auth_comp_id_3 != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_3>" + atom_site_auth_comp_id_3 + "</PDBx:atom_site_auth_comp_id_3>\n");
			if (atom_site_auth_comp_id_4 != null) ow.write(indent + " <PDBx:atom_site_auth_comp_id_4>" + atom_site_auth_comp_id_4 + "</PDBx:atom_site_auth_comp_id_4>\n");
			if (atom_site_auth_seq_id_1 != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_1>" + atom_site_auth_seq_id_1 + "</PDBx:atom_site_auth_seq_id_1>\n");
			if (atom_site_auth_seq_id_2 != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_2>" + atom_site_auth_seq_id_2 + "</PDBx:atom_site_auth_seq_id_2>\n");
			if (atom_site_auth_seq_id_3 != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_3>" + atom_site_auth_seq_id_3 + "</PDBx:atom_site_auth_seq_id_3>\n");
			if (atom_site_auth_seq_id_4 != null) ow.write(indent + " <PDBx:atom_site_auth_seq_id_4>" + atom_site_auth_seq_id_4 + "</PDBx:atom_site_auth_seq_id_4>\n");
			if (atom_site_id_1 != null) ow.write(indent + " <PDBx:atom_site_id_1>" + atom_site_id_1 + "</PDBx:atom_site_id_1>\n");
			if (atom_site_id_2 != null) ow.write(indent + " <PDBx:atom_site_id_2>" + atom_site_id_2 + "</PDBx:atom_site_id_2>\n");
			if (atom_site_id_3 != null) ow.write(indent + " <PDBx:atom_site_id_3>" + atom_site_id_3 + "</PDBx:atom_site_id_3>\n");
			if (atom_site_id_4 != null) ow.write(indent + " <PDBx:atom_site_id_4>" + atom_site_id_4 + "</PDBx:atom_site_id_4>\n");
			if (atom_site_label_alt_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_1>" + atom_site_label_alt_id_1 + "</PDBx:atom_site_label_alt_id_1>\n");
			if (atom_site_label_alt_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_2>" + atom_site_label_alt_id_2 + "</PDBx:atom_site_label_alt_id_2>\n");
			if (atom_site_label_alt_id_3 != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_3>" + atom_site_label_alt_id_3 + "</PDBx:atom_site_label_alt_id_3>\n");
			if (atom_site_label_alt_id_4 != null) ow.write(indent + " <PDBx:atom_site_label_alt_id_4>" + atom_site_label_alt_id_4 + "</PDBx:atom_site_label_alt_id_4>\n");
			if (atom_site_label_asym_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_1>" + atom_site_label_asym_id_1 + "</PDBx:atom_site_label_asym_id_1>\n");
			if (atom_site_label_asym_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_2>" + atom_site_label_asym_id_2 + "</PDBx:atom_site_label_asym_id_2>\n");
			if (atom_site_label_asym_id_3 != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_3>" + atom_site_label_asym_id_3 + "</PDBx:atom_site_label_asym_id_3>\n");
			if (atom_site_label_asym_id_4 != null) ow.write(indent + " <PDBx:atom_site_label_asym_id_4>" + atom_site_label_asym_id_4 + "</PDBx:atom_site_label_asym_id_4>\n");
			if (atom_site_label_atom_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_1>" + atom_site_label_atom_id_1 + "</PDBx:atom_site_label_atom_id_1>\n");
			if (atom_site_label_atom_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_2>" + atom_site_label_atom_id_2 + "</PDBx:atom_site_label_atom_id_2>\n");
			if (atom_site_label_atom_id_3 != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_3>" + atom_site_label_atom_id_3 + "</PDBx:atom_site_label_atom_id_3>\n");
			if (atom_site_label_atom_id_4 != null) ow.write(indent + " <PDBx:atom_site_label_atom_id_4>" + atom_site_label_atom_id_4 + "</PDBx:atom_site_label_atom_id_4>\n");
			if (atom_site_label_comp_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_1>" + atom_site_label_comp_id_1 + "</PDBx:atom_site_label_comp_id_1>\n");
			if (atom_site_label_comp_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_2>" + atom_site_label_comp_id_2 + "</PDBx:atom_site_label_comp_id_2>\n");
			if (atom_site_label_comp_id_3 != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_3>" + atom_site_label_comp_id_3 + "</PDBx:atom_site_label_comp_id_3>\n");
			if (atom_site_label_comp_id_4 != null) ow.write(indent + " <PDBx:atom_site_label_comp_id_4>" + atom_site_label_comp_id_4 + "</PDBx:atom_site_label_comp_id_4>\n");
			if (atom_site_label_seq_id_1 != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_1>" + atom_site_label_seq_id_1 + "</PDBx:atom_site_label_seq_id_1>\n");
			if (atom_site_label_seq_id_2 != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_2>" + atom_site_label_seq_id_2 + "</PDBx:atom_site_label_seq_id_2>\n");
			if (atom_site_label_seq_id_3 != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_3>" + atom_site_label_seq_id_3 + "</PDBx:atom_site_label_seq_id_3>\n");
			if (atom_site_label_seq_id_4 != null) ow.write(indent + " <PDBx:atom_site_label_seq_id_4>" + atom_site_label_seq_id_4 + "</PDBx:atom_site_label_seq_id_4>\n");
			if (pdbx_PDB_model_num != null) ow.write(indent + " <PDBx:pdbx_PDB_model_num>" + pdbx_PDB_model_num + "</PDBx:pdbx_PDB_model_num>\n");
			if (pdbx_atom_site_PDB_ins_code_1 != null) ow.write(indent + " <PDBx:pdbx_atom_site_PDB_ins_code_1>" + pdbx_atom_site_PDB_ins_code_1 + "</PDBx:pdbx_atom_site_PDB_ins_code_1>\n");
			if (pdbx_atom_site_PDB_ins_code_2 != null) ow.write(indent + " <PDBx:pdbx_atom_site_PDB_ins_code_2>" + pdbx_atom_site_PDB_ins_code_2 + "</PDBx:pdbx_atom_site_PDB_ins_code_2>\n");
			if (pdbx_atom_site_PDB_ins_code_3 != null) ow.write(indent + " <PDBx:pdbx_atom_site_PDB_ins_code_3>" + pdbx_atom_site_PDB_ins_code_3 + "</PDBx:pdbx_atom_site_PDB_ins_code_3>\n");
			if (pdbx_atom_site_PDB_ins_code_4 != null) ow.write(indent + " <PDBx:pdbx_atom_site_PDB_ins_code_4>" + pdbx_atom_site_PDB_ins_code_4 + "</PDBx:pdbx_atom_site_PDB_ins_code_4>\n");
			if (publ_flag != null) ow.write(indent + " <PDBx:publ_flag>" + publ_flag + "</PDBx:publ_flag>\n");
			if (site_symmetry_1 != null) ow.write(indent + " <PDBx:site_symmetry_1>" + site_symmetry_1 + "</PDBx:site_symmetry_1>\n");
			if (site_symmetry_2 != null) ow.write(indent + " <PDBx:site_symmetry_2>" + site_symmetry_2 + "</PDBx:site_symmetry_2>\n");
			if (site_symmetry_3 != null) ow.write(indent + " <PDBx:site_symmetry_3>" + site_symmetry_3 + "</PDBx:site_symmetry_3>\n");
			if (site_symmetry_4 != null) ow.write(indent + " <PDBx:site_symmetry_4>" + site_symmetry_4 + "</PDBx:site_symmetry_4>\n");
			if (value != null) ow.write(indent + " <PDBx:value>" + value + "</PDBx:value>\n");
			if (value_esd != null) ow.write(indent + " <PDBx:value_esd>" + value_esd + "</PDBx:value_esd>\n");
			ow.write(indent + "</PDBx:geom_torsion>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
