package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the JOURNAL category record details about the
 *  book-keeping by the journal staff when processing
 *  a data block submitted for publication.
 *  
 *  The creator of a data block will not normally specify these data.
 *  The data names are not defined in the dictionary because they are
 *  for journal use only.
 *  
 * <pre>
 *  Example 1 - based on Acta Cryst. file for entry HL0007 [Willis, Beckwith
 *  & Tozer (1991). Acta Cryst. C47, 2276-2277].
 *  <PDBx:journalCategory>
 *  <PDBx:journal entry_id="TOZ">
 *  <PDBx:date_recd_electronic>1991-04-15</PDBx:date_recd_electronic>
 *  <PDBx:date_from_coeditor>1991-04-18</PDBx:date_from_coeditor>
 *  <PDBx:date_accepted>1991-04-18</PDBx:date_accepted>
 *  <PDBx:date_printers_first>1991-08-07</PDBx:date_printers_first>
 *  <PDBx:date_proofs_out>1991-08-07</PDBx:date_proofs_out>
 *  <PDBx:coeditor_code>HL0007</PDBx:coeditor_code>
 *  <PDBx:techeditor_code>C910963</PDBx:techeditor_code>
 *  <PDBx:coden_ASTM>ACSCEE</PDBx:coden_ASTM>
 *  <PDBx:name_full>Acta Crystallographica Section C</PDBx:name_full>
 *  <PDBx:year>1991</PDBx:year>
 *  <PDBx:volume>47</PDBx:volume>
 *  <PDBx:issue>NOV91</PDBx:issue>
 *  <PDBx:page_first>2276</PDBx:page_first>
 *  <PDBx:page_last>2277</PDBx:page_last>
 *  </PDBx:journal>
 *  </PDBx:journalCategory>
 * </pre>
 */
public class Journal extends org.pdb.beans.Journal implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "journal";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Journal()
	{
	}

	/** Full constructor */
	public Journal(
		Datablock datablock,
		java.lang.String coden_ASTM,
		java.lang.String coden_Cambridge,
		java.lang.String coeditor_address,
		java.lang.String coeditor_code,
		java.lang.String coeditor_email,
		java.lang.String coeditor_fax,
		java.lang.String coeditor_name,
		java.lang.String coeditor_notes,
		java.lang.String coeditor_phone,
		java.lang.String data_validation_number,
		java.util.Date date_accepted,
		java.util.Date date_from_coeditor,
		java.util.Date date_printers_final,
		java.util.Date date_printers_first,
		java.util.Date date_proofs_in,
		java.util.Date date_proofs_out,
		java.util.Date date_recd_copyright,
		java.util.Date date_recd_electronic,
		java.util.Date date_recd_hard_copy,
		java.util.Date date_to_coeditor,
		java.lang.String entry_id,
		java.lang.String issue,
		java.lang.String language,
		java.lang.String name_full,
		java.lang.String page_first,
		java.lang.String page_last,
		java.lang.String paper_category,
		java.lang.String suppl_publ_number,
		java.lang.String suppl_publ_pages,
		java.lang.String techeditor_address,
		java.lang.String techeditor_code,
		java.lang.String techeditor_email,
		java.lang.String techeditor_fax,
		java.lang.String techeditor_name,
		java.lang.String techeditor_notes,
		java.lang.String techeditor_phone,
		java.lang.String volume,
		java.lang.String year)
	{
		this.datablock = datablock;
		this.coden_ASTM = coden_ASTM;
		this.coden_Cambridge = coden_Cambridge;
		this.coeditor_address = coeditor_address;
		this.coeditor_code = coeditor_code;
		this.coeditor_email = coeditor_email;
		this.coeditor_fax = coeditor_fax;
		this.coeditor_name = coeditor_name;
		this.coeditor_notes = coeditor_notes;
		this.coeditor_phone = coeditor_phone;
		this.data_validation_number = data_validation_number;
		this.date_accepted = date_accepted;
		this.date_from_coeditor = date_from_coeditor;
		this.date_printers_final = date_printers_final;
		this.date_printers_first = date_printers_first;
		this.date_proofs_in = date_proofs_in;
		this.date_proofs_out = date_proofs_out;
		this.date_recd_copyright = date_recd_copyright;
		this.date_recd_electronic = date_recd_electronic;
		this.date_recd_hard_copy = date_recd_hard_copy;
		this.date_to_coeditor = date_to_coeditor;
		this.entry_id = entry_id;
		this.issue = issue;
		this.language = language;
		this.name_full = name_full;
		this.page_first = page_first;
		this.page_last = page_last;
		this.paper_category = paper_category;
		this.suppl_publ_number = suppl_publ_number;
		this.suppl_publ_pages = suppl_publ_pages;
		this.techeditor_address = techeditor_address;
		this.techeditor_code = techeditor_code;
		this.techeditor_email = techeditor_email;
		this.techeditor_fax = techeditor_fax;
		this.techeditor_name = techeditor_name;
		this.techeditor_notes = techeditor_notes;
		this.techeditor_phone = techeditor_phone;
		this.volume = volume;
		this.year = year;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Journal");
		sb.append("\n");
		if (coden_ASTM != null)
		{
			sb.append("coden_ASTM = ");
			sb.append(coden_ASTM);
			sb.append('\n');
		}
		if (coden_Cambridge != null)
		{
			sb.append("coden_Cambridge = ");
			sb.append(coden_Cambridge);
			sb.append('\n');
		}
		if (coeditor_address != null)
		{
			sb.append("coeditor_address = ");
			sb.append(coeditor_address);
			sb.append('\n');
		}
		if (coeditor_code != null)
		{
			sb.append("coeditor_code = ");
			sb.append(coeditor_code);
			sb.append('\n');
		}
		if (coeditor_email != null)
		{
			sb.append("coeditor_email = ");
			sb.append(coeditor_email);
			sb.append('\n');
		}
		if (coeditor_fax != null)
		{
			sb.append("coeditor_fax = ");
			sb.append(coeditor_fax);
			sb.append('\n');
		}
		if (coeditor_name != null)
		{
			sb.append("coeditor_name = ");
			sb.append(coeditor_name);
			sb.append('\n');
		}
		if (coeditor_notes != null)
		{
			sb.append("coeditor_notes = ");
			sb.append(coeditor_notes);
			sb.append('\n');
		}
		if (coeditor_phone != null)
		{
			sb.append("coeditor_phone = ");
			sb.append(coeditor_phone);
			sb.append('\n');
		}
		if (data_validation_number != null)
		{
			sb.append("data_validation_number = ");
			sb.append(data_validation_number);
			sb.append('\n');
		}
		if (date_accepted != null)
		{
			sb.append("date_accepted = ");
			sb.append(date_accepted);
			sb.append('\n');
		}
		if (date_from_coeditor != null)
		{
			sb.append("date_from_coeditor = ");
			sb.append(date_from_coeditor);
			sb.append('\n');
		}
		if (date_printers_final != null)
		{
			sb.append("date_printers_final = ");
			sb.append(date_printers_final);
			sb.append('\n');
		}
		if (date_printers_first != null)
		{
			sb.append("date_printers_first = ");
			sb.append(date_printers_first);
			sb.append('\n');
		}
		if (date_proofs_in != null)
		{
			sb.append("date_proofs_in = ");
			sb.append(date_proofs_in);
			sb.append('\n');
		}
		if (date_proofs_out != null)
		{
			sb.append("date_proofs_out = ");
			sb.append(date_proofs_out);
			sb.append('\n');
		}
		if (date_recd_copyright != null)
		{
			sb.append("date_recd_copyright = ");
			sb.append(date_recd_copyright);
			sb.append('\n');
		}
		if (date_recd_electronic != null)
		{
			sb.append("date_recd_electronic = ");
			sb.append(date_recd_electronic);
			sb.append('\n');
		}
		if (date_recd_hard_copy != null)
		{
			sb.append("date_recd_hard_copy = ");
			sb.append(date_recd_hard_copy);
			sb.append('\n');
		}
		if (date_to_coeditor != null)
		{
			sb.append("date_to_coeditor = ");
			sb.append(date_to_coeditor);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (issue != null)
		{
			sb.append("issue = ");
			sb.append(issue);
			sb.append('\n');
		}
		if (language != null)
		{
			sb.append("language = ");
			sb.append(language);
			sb.append('\n');
		}
		if (name_full != null)
		{
			sb.append("name_full = ");
			sb.append(name_full);
			sb.append('\n');
		}
		if (page_first != null)
		{
			sb.append("page_first = ");
			sb.append(page_first);
			sb.append('\n');
		}
		if (page_last != null)
		{
			sb.append("page_last = ");
			sb.append(page_last);
			sb.append('\n');
		}
		if (paper_category != null)
		{
			sb.append("paper_category = ");
			sb.append(paper_category);
			sb.append('\n');
		}
		if (suppl_publ_number != null)
		{
			sb.append("suppl_publ_number = ");
			sb.append(suppl_publ_number);
			sb.append('\n');
		}
		if (suppl_publ_pages != null)
		{
			sb.append("suppl_publ_pages = ");
			sb.append(suppl_publ_pages);
			sb.append('\n');
		}
		if (techeditor_address != null)
		{
			sb.append("techeditor_address = ");
			sb.append(techeditor_address);
			sb.append('\n');
		}
		if (techeditor_code != null)
		{
			sb.append("techeditor_code = ");
			sb.append(techeditor_code);
			sb.append('\n');
		}
		if (techeditor_email != null)
		{
			sb.append("techeditor_email = ");
			sb.append(techeditor_email);
			sb.append('\n');
		}
		if (techeditor_fax != null)
		{
			sb.append("techeditor_fax = ");
			sb.append(techeditor_fax);
			sb.append('\n');
		}
		if (techeditor_name != null)
		{
			sb.append("techeditor_name = ");
			sb.append(techeditor_name);
			sb.append('\n');
		}
		if (techeditor_notes != null)
		{
			sb.append("techeditor_notes = ");
			sb.append(techeditor_notes);
			sb.append('\n');
		}
		if (techeditor_phone != null)
		{
			sb.append("techeditor_phone = ");
			sb.append(techeditor_phone);
			sb.append('\n');
		}
		if (volume != null)
		{
			sb.append("volume = ");
			sb.append(volume);
			sb.append('\n');
		}
		if (year != null)
		{
			sb.append("year = ");
			sb.append(year);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		coden_ASTM = null;
		coden_Cambridge = null;
		coeditor_address = null;
		coeditor_code = null;
		coeditor_email = null;
		coeditor_fax = null;
		coeditor_name = null;
		coeditor_notes = null;
		coeditor_phone = null;
		data_validation_number = null;
		date_accepted = null;
		date_from_coeditor = null;
		date_printers_final = null;
		date_printers_first = null;
		date_proofs_in = null;
		date_proofs_out = null;
		date_recd_copyright = null;
		date_recd_electronic = null;
		date_recd_hard_copy = null;
		date_to_coeditor = null;
		entry_id = null;
		issue = null;
		language = null;
		name_full = null;
		page_first = null;
		page_last = null;
		paper_category = null;
		suppl_publ_number = null;
		suppl_publ_pages = null;
		techeditor_address = null;
		techeditor_code = null;
		techeditor_email = null;
		techeditor_fax = null;
		techeditor_name = null;
		techeditor_notes = null;
		techeditor_phone = null;
		volume = null;
		year = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Journal)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:journal>\n");
			if (coden_ASTM != null) ow.write(indent + " <PDBx:coden_ASTM>" + coden_ASTM + "</PDBx:coden_ASTM>\n");
			if (coden_Cambridge != null) ow.write(indent + " <PDBx:coden_Cambridge>" + coden_Cambridge + "</PDBx:coden_Cambridge>\n");
			if (coeditor_address != null) ow.write(indent + " <PDBx:coeditor_address>" + coeditor_address + "</PDBx:coeditor_address>\n");
			if (coeditor_code != null) ow.write(indent + " <PDBx:coeditor_code>" + coeditor_code + "</PDBx:coeditor_code>\n");
			if (coeditor_email != null) ow.write(indent + " <PDBx:coeditor_email>" + coeditor_email + "</PDBx:coeditor_email>\n");
			if (coeditor_fax != null) ow.write(indent + " <PDBx:coeditor_fax>" + coeditor_fax + "</PDBx:coeditor_fax>\n");
			if (coeditor_name != null) ow.write(indent + " <PDBx:coeditor_name>" + coeditor_name + "</PDBx:coeditor_name>\n");
			if (coeditor_notes != null) ow.write(indent + " <PDBx:coeditor_notes>" + coeditor_notes + "</PDBx:coeditor_notes>\n");
			if (coeditor_phone != null) ow.write(indent + " <PDBx:coeditor_phone>" + coeditor_phone + "</PDBx:coeditor_phone>\n");
			if (data_validation_number != null) ow.write(indent + " <PDBx:data_validation_number>" + data_validation_number + "</PDBx:data_validation_number>\n");
			if (date_accepted != null) ow.write(indent + " <PDBx:date_accepted>" + date_accepted + "</PDBx:date_accepted>\n");
			if (date_from_coeditor != null) ow.write(indent + " <PDBx:date_from_coeditor>" + date_from_coeditor + "</PDBx:date_from_coeditor>\n");
			if (date_printers_final != null) ow.write(indent + " <PDBx:date_printers_final>" + date_printers_final + "</PDBx:date_printers_final>\n");
			if (date_printers_first != null) ow.write(indent + " <PDBx:date_printers_first>" + date_printers_first + "</PDBx:date_printers_first>\n");
			if (date_proofs_in != null) ow.write(indent + " <PDBx:date_proofs_in>" + date_proofs_in + "</PDBx:date_proofs_in>\n");
			if (date_proofs_out != null) ow.write(indent + " <PDBx:date_proofs_out>" + date_proofs_out + "</PDBx:date_proofs_out>\n");
			if (date_recd_copyright != null) ow.write(indent + " <PDBx:date_recd_copyright>" + date_recd_copyright + "</PDBx:date_recd_copyright>\n");
			if (date_recd_electronic != null) ow.write(indent + " <PDBx:date_recd_electronic>" + date_recd_electronic + "</PDBx:date_recd_electronic>\n");
			if (date_recd_hard_copy != null) ow.write(indent + " <PDBx:date_recd_hard_copy>" + date_recd_hard_copy + "</PDBx:date_recd_hard_copy>\n");
			if (date_to_coeditor != null) ow.write(indent + " <PDBx:date_to_coeditor>" + date_to_coeditor + "</PDBx:date_to_coeditor>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (issue != null) ow.write(indent + " <PDBx:issue>" + issue + "</PDBx:issue>\n");
			if (language != null) ow.write(indent + " <PDBx:language>" + language + "</PDBx:language>\n");
			if (name_full != null) ow.write(indent + " <PDBx:name_full>" + name_full + "</PDBx:name_full>\n");
			if (page_first != null) ow.write(indent + " <PDBx:page_first>" + page_first + "</PDBx:page_first>\n");
			if (page_last != null) ow.write(indent + " <PDBx:page_last>" + page_last + "</PDBx:page_last>\n");
			if (paper_category != null) ow.write(indent + " <PDBx:paper_category>" + paper_category + "</PDBx:paper_category>\n");
			if (suppl_publ_number != null) ow.write(indent + " <PDBx:suppl_publ_number>" + suppl_publ_number + "</PDBx:suppl_publ_number>\n");
			if (suppl_publ_pages != null) ow.write(indent + " <PDBx:suppl_publ_pages>" + suppl_publ_pages + "</PDBx:suppl_publ_pages>\n");
			if (techeditor_address != null) ow.write(indent + " <PDBx:techeditor_address>" + techeditor_address + "</PDBx:techeditor_address>\n");
			if (techeditor_code != null) ow.write(indent + " <PDBx:techeditor_code>" + techeditor_code + "</PDBx:techeditor_code>\n");
			if (techeditor_email != null) ow.write(indent + " <PDBx:techeditor_email>" + techeditor_email + "</PDBx:techeditor_email>\n");
			if (techeditor_fax != null) ow.write(indent + " <PDBx:techeditor_fax>" + techeditor_fax + "</PDBx:techeditor_fax>\n");
			if (techeditor_name != null) ow.write(indent + " <PDBx:techeditor_name>" + techeditor_name + "</PDBx:techeditor_name>\n");
			if (techeditor_notes != null) ow.write(indent + " <PDBx:techeditor_notes>" + techeditor_notes + "</PDBx:techeditor_notes>\n");
			if (techeditor_phone != null) ow.write(indent + " <PDBx:techeditor_phone>" + techeditor_phone + "</PDBx:techeditor_phone>\n");
			if (volume != null) ow.write(indent + " <PDBx:volume>" + volume + "</PDBx:volume>\n");
			if (year != null) ow.write(indent + " <PDBx:year>" + year + "</PDBx:year>\n");
			ow.write(indent + "</PDBx:journal>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
