package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the JOURNAL_INDEX category are used to list terms
 *  used to generate the journal indexes.
 *  
 *  The creator of a data block will not normally specify these data
 *  items.
 *  
 * <pre>
 *  Example 1 - based on a paper by Zhu, Reynolds, Klein & Trudell
 *  [Acta Cryst. (1994), C50, 2067-2069].
 *  <PDBx:journal_indexCategory>
 *  <PDBx:journal_index type="S" term="alkaloids">
 *  <PDBx:subterm>(-)-norcocaine</PDBx:subterm>
 *  </PDBx:journal_index>
 *  </PDBx:journal_indexCategory>
 * </pre>
 */
public class Journal_index extends org.pdb.beans.Journal_index implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "journal_index";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Journal_index()
	{
	}

	/** Full constructor */
	public Journal_index(
		Datablock datablock,
		java.lang.String subterm,
		java.lang.String term,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.subterm = subterm;
		this.term = term;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Journal_index");
		sb.append("\n");
		if (subterm != null)
		{
			sb.append("subterm = ");
			sb.append(subterm);
			sb.append('\n');
		}
		if (term != null)
		{
			sb.append("term = ");
			sb.append(term);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		subterm = null;
		term = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Journal_index)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:journal_index>\n");
			if (subterm != null) ow.write(indent + " <PDBx:subterm>" + subterm + "</PDBx:subterm>\n");
			if (term != null) ow.write(indent + " <PDBx:term>" + term + "</PDBx:term>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:journal_index>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
