package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the NDB_STRUCT_NA_BASE_PAIR category record details
 *  of base pairing interactions.
 *  <PDBx:ndb_struct_na_base_pairCategory>
 *  <PDBx:ndb_struct_na_base_pair model_number="1" i_label_comp_id="G" i_label_asym_id="A" i_label_seq_id="1" i_symmetry="1_555" j_label_comp_id="C" j_label_asym_id="A" j_label_seq_id="8" j_symmetry="7_555">
 *  <PDBx:shear>-0.396</PDBx:shear>
 *  <PDBx:stretch>-0.156</PDBx:stretch>
 *  <PDBx:stagger>-0.018</PDBx:stagger>
 *  <PDBx:buckle>-5.523</PDBx:buckle>
 *  <PDBx:propeller>-6.752</PDBx:propeller>
 *  <PDBx:opening>-3.291</PDBx:opening>
 *  </PDBx:ndb_struct_na_base_pair>
 *  <PDBx:ndb_struct_na_base_pair model_number="1" i_label_comp_id="G" i_label_asym_id="A" i_label_seq_id="2" i_symmetry="1_555" j_label_comp_id="C" j_label_asym_id="A" j_label_seq_id="7" j_symmetry="7_555">
 *  <PDBx:shear>-0.094</PDBx:shear>
 *  <PDBx:stretch>-0.220</PDBx:stretch>
 *  <PDBx:stagger>-0.334</PDBx:stagger>
 *  <PDBx:buckle>-4.727</PDBx:buckle>
 *  <PDBx:propeller>-9.765</PDBx:propeller>
 *  <PDBx:opening>2.311</PDBx:opening>
 *  </PDBx:ndb_struct_na_base_pair>
 *  <PDBx:ndb_struct_na_base_pair model_number="1" i_label_comp_id="G" i_label_asym_id="A" i_label_seq_id="3" i_symmetry="1_555" j_label_comp_id="C" j_label_asym_id="A" j_label_seq_id="6" j_symmetry="7_555">
 *  <PDBx:shear>-0.285</PDBx:shear>
 *  <PDBx:stretch>-0.239</PDBx:stretch>
 *  <PDBx:stagger>0.008</PDBx:stagger>
 *  <PDBx:buckle>-6.454</PDBx:buckle>
 *  <PDBx:propeller>-12.575</PDBx:propeller>
 *  <PDBx:opening>-1.181</PDBx:opening>
 *  </PDBx:ndb_struct_na_base_pair>
 *  </PDBx:ndb_struct_na_base_pairCategory>
 */
public class Ndb_struct_na_base_pair extends org.pdb.beans.Ndb_struct_na_base_pair implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "ndb_struct_na_base_pair";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Ndb_struct_na_base_pair()
	{
	}

	/** Full constructor */
	public Ndb_struct_na_base_pair(
		Datablock datablock,
		java.lang.Float buckle,
		java.lang.Integer hbond_type_12,
		java.lang.Integer hbond_type_28,
		java.lang.String i_PDB_ins_code,
		java.lang.String i_auth_asym_id,
		java.lang.String i_auth_seq_id,
		java.lang.String i_label_asym_id,
		java.lang.String i_label_comp_id,
		java.lang.Integer i_label_seq_id,
		java.lang.String i_symmetry,
		java.lang.String j_PDB_ins_code,
		java.lang.String j_auth_asym_id,
		java.lang.String j_auth_seq_id,
		java.lang.String j_label_asym_id,
		java.lang.String j_label_comp_id,
		java.lang.Integer j_label_seq_id,
		java.lang.String j_symmetry,
		java.lang.Integer model_number,
		java.lang.Float opening,
		java.lang.String pair_name,
		java.lang.Integer pair_number,
		java.lang.Float propeller,
		java.lang.Float shear,
		java.lang.Float stagger,
		java.lang.Float stretch)
	{
		this.datablock = datablock;
		this.buckle = buckle;
		this.hbond_type_12 = hbond_type_12;
		this.hbond_type_28 = hbond_type_28;
		this.i_PDB_ins_code = i_PDB_ins_code;
		this.i_auth_asym_id = i_auth_asym_id;
		this.i_auth_seq_id = i_auth_seq_id;
		this.i_label_asym_id = i_label_asym_id;
		this.i_label_comp_id = i_label_comp_id;
		this.i_label_seq_id = i_label_seq_id;
		this.i_symmetry = i_symmetry;
		this.j_PDB_ins_code = j_PDB_ins_code;
		this.j_auth_asym_id = j_auth_asym_id;
		this.j_auth_seq_id = j_auth_seq_id;
		this.j_label_asym_id = j_label_asym_id;
		this.j_label_comp_id = j_label_comp_id;
		this.j_label_seq_id = j_label_seq_id;
		this.j_symmetry = j_symmetry;
		this.model_number = model_number;
		this.opening = opening;
		this.pair_name = pair_name;
		this.pair_number = pair_number;
		this.propeller = propeller;
		this.shear = shear;
		this.stagger = stagger;
		this.stretch = stretch;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Ndb_struct_na_base_pair");
		sb.append("\n");
		if (buckle != null)
		{
			sb.append("buckle = ");
			sb.append(buckle);
			sb.append('\n');
		}
		if (hbond_type_12 != null)
		{
			sb.append("hbond_type_12 = ");
			sb.append(hbond_type_12);
			sb.append('\n');
		}
		if (hbond_type_28 != null)
		{
			sb.append("hbond_type_28 = ");
			sb.append(hbond_type_28);
			sb.append('\n');
		}
		if (i_PDB_ins_code != null)
		{
			sb.append("i_PDB_ins_code = ");
			sb.append(i_PDB_ins_code);
			sb.append('\n');
		}
		if (i_auth_asym_id != null)
		{
			sb.append("i_auth_asym_id = ");
			sb.append(i_auth_asym_id);
			sb.append('\n');
		}
		if (i_auth_seq_id != null)
		{
			sb.append("i_auth_seq_id = ");
			sb.append(i_auth_seq_id);
			sb.append('\n');
		}
		if (i_label_asym_id != null)
		{
			sb.append("i_label_asym_id = ");
			sb.append(i_label_asym_id);
			sb.append('\n');
		}
		if (i_label_comp_id != null)
		{
			sb.append("i_label_comp_id = ");
			sb.append(i_label_comp_id);
			sb.append('\n');
		}
		if (i_label_seq_id != null)
		{
			sb.append("i_label_seq_id = ");
			sb.append(i_label_seq_id);
			sb.append('\n');
		}
		if (i_symmetry != null)
		{
			sb.append("i_symmetry = ");
			sb.append(i_symmetry);
			sb.append('\n');
		}
		if (j_PDB_ins_code != null)
		{
			sb.append("j_PDB_ins_code = ");
			sb.append(j_PDB_ins_code);
			sb.append('\n');
		}
		if (j_auth_asym_id != null)
		{
			sb.append("j_auth_asym_id = ");
			sb.append(j_auth_asym_id);
			sb.append('\n');
		}
		if (j_auth_seq_id != null)
		{
			sb.append("j_auth_seq_id = ");
			sb.append(j_auth_seq_id);
			sb.append('\n');
		}
		if (j_label_asym_id != null)
		{
			sb.append("j_label_asym_id = ");
			sb.append(j_label_asym_id);
			sb.append('\n');
		}
		if (j_label_comp_id != null)
		{
			sb.append("j_label_comp_id = ");
			sb.append(j_label_comp_id);
			sb.append('\n');
		}
		if (j_label_seq_id != null)
		{
			sb.append("j_label_seq_id = ");
			sb.append(j_label_seq_id);
			sb.append('\n');
		}
		if (j_symmetry != null)
		{
			sb.append("j_symmetry = ");
			sb.append(j_symmetry);
			sb.append('\n');
		}
		if (model_number != null)
		{
			sb.append("model_number = ");
			sb.append(model_number);
			sb.append('\n');
		}
		if (opening != null)
		{
			sb.append("opening = ");
			sb.append(opening);
			sb.append('\n');
		}
		if (pair_name != null)
		{
			sb.append("pair_name = ");
			sb.append(pair_name);
			sb.append('\n');
		}
		if (pair_number != null)
		{
			sb.append("pair_number = ");
			sb.append(pair_number);
			sb.append('\n');
		}
		if (propeller != null)
		{
			sb.append("propeller = ");
			sb.append(propeller);
			sb.append('\n');
		}
		if (shear != null)
		{
			sb.append("shear = ");
			sb.append(shear);
			sb.append('\n');
		}
		if (stagger != null)
		{
			sb.append("stagger = ");
			sb.append(stagger);
			sb.append('\n');
		}
		if (stretch != null)
		{
			sb.append("stretch = ");
			sb.append(stretch);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		buckle = null;
		hbond_type_12 = null;
		hbond_type_28 = null;
		i_PDB_ins_code = null;
		i_auth_asym_id = null;
		i_auth_seq_id = null;
		i_label_asym_id = null;
		i_label_comp_id = null;
		i_label_seq_id = null;
		i_symmetry = null;
		j_PDB_ins_code = null;
		j_auth_asym_id = null;
		j_auth_seq_id = null;
		j_label_asym_id = null;
		j_label_comp_id = null;
		j_label_seq_id = null;
		j_symmetry = null;
		model_number = null;
		opening = null;
		pair_name = null;
		pair_number = null;
		propeller = null;
		shear = null;
		stagger = null;
		stretch = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Ndb_struct_na_base_pair)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:ndb_struct_na_base_pair>\n");
			if (buckle != null) ow.write(indent + " <PDBx:buckle>" + buckle + "</PDBx:buckle>\n");
			if (hbond_type_12 != null) ow.write(indent + " <PDBx:hbond_type_12>" + hbond_type_12 + "</PDBx:hbond_type_12>\n");
			if (hbond_type_28 != null) ow.write(indent + " <PDBx:hbond_type_28>" + hbond_type_28 + "</PDBx:hbond_type_28>\n");
			if (i_PDB_ins_code != null) ow.write(indent + " <PDBx:i_PDB_ins_code>" + i_PDB_ins_code + "</PDBx:i_PDB_ins_code>\n");
			if (i_auth_asym_id != null) ow.write(indent + " <PDBx:i_auth_asym_id>" + i_auth_asym_id + "</PDBx:i_auth_asym_id>\n");
			if (i_auth_seq_id != null) ow.write(indent + " <PDBx:i_auth_seq_id>" + i_auth_seq_id + "</PDBx:i_auth_seq_id>\n");
			if (i_label_asym_id != null) ow.write(indent + " <PDBx:i_label_asym_id>" + i_label_asym_id + "</PDBx:i_label_asym_id>\n");
			if (i_label_comp_id != null) ow.write(indent + " <PDBx:i_label_comp_id>" + i_label_comp_id + "</PDBx:i_label_comp_id>\n");
			if (i_label_seq_id != null) ow.write(indent + " <PDBx:i_label_seq_id>" + i_label_seq_id + "</PDBx:i_label_seq_id>\n");
			if (i_symmetry != null) ow.write(indent + " <PDBx:i_symmetry>" + i_symmetry + "</PDBx:i_symmetry>\n");
			if (j_PDB_ins_code != null) ow.write(indent + " <PDBx:j_PDB_ins_code>" + j_PDB_ins_code + "</PDBx:j_PDB_ins_code>\n");
			if (j_auth_asym_id != null) ow.write(indent + " <PDBx:j_auth_asym_id>" + j_auth_asym_id + "</PDBx:j_auth_asym_id>\n");
			if (j_auth_seq_id != null) ow.write(indent + " <PDBx:j_auth_seq_id>" + j_auth_seq_id + "</PDBx:j_auth_seq_id>\n");
			if (j_label_asym_id != null) ow.write(indent + " <PDBx:j_label_asym_id>" + j_label_asym_id + "</PDBx:j_label_asym_id>\n");
			if (j_label_comp_id != null) ow.write(indent + " <PDBx:j_label_comp_id>" + j_label_comp_id + "</PDBx:j_label_comp_id>\n");
			if (j_label_seq_id != null) ow.write(indent + " <PDBx:j_label_seq_id>" + j_label_seq_id + "</PDBx:j_label_seq_id>\n");
			if (j_symmetry != null) ow.write(indent + " <PDBx:j_symmetry>" + j_symmetry + "</PDBx:j_symmetry>\n");
			if (model_number != null) ow.write(indent + " <PDBx:model_number>" + model_number + "</PDBx:model_number>\n");
			if (opening != null) ow.write(indent + " <PDBx:opening>" + opening + "</PDBx:opening>\n");
			if (pair_name != null) ow.write(indent + " <PDBx:pair_name>" + pair_name + "</PDBx:pair_name>\n");
			if (pair_number != null) ow.write(indent + " <PDBx:pair_number>" + pair_number + "</PDBx:pair_number>\n");
			if (propeller != null) ow.write(indent + " <PDBx:propeller>" + propeller + "</PDBx:propeller>\n");
			if (shear != null) ow.write(indent + " <PDBx:shear>" + shear + "</PDBx:shear>\n");
			if (stagger != null) ow.write(indent + " <PDBx:stagger>" + stagger + "</PDBx:stagger>\n");
			if (stretch != null) ow.write(indent + " <PDBx:stretch>" + stretch + "</PDBx:stretch>\n");
			ow.write(indent + "</PDBx:ndb_struct_na_base_pair>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
