package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_AUDIT_AUTHOR category record details about
 *  the author(s) of the data block.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP
 *  <PDBx:pdbx_audit_authorCategory>
 *  <PDBx:pdbx_audit_author ordinal="1">
 *  <PDBx:name>Fitzgerald, Paula M.D.</PDBx:name>
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:pdbx_audit_author>
 *  <PDBx:pdbx_audit_author ordinal="2">
 *  <PDBx:name>McKeever, Brian M.</PDBx:name>
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:pdbx_audit_author>
 *  <PDBx:pdbx_audit_author ordinal="3">
 *  <PDBx:name>Van Middlesworth, J.F.</PDBx:name>
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:pdbx_audit_author>
 *  <PDBx:pdbx_audit_author ordinal="4">
 *  <PDBx:name>Springer, James P.</PDBx:name>
 *  <PDBx:address> Department of Biophysical Chemistry
 *  Merck Research Laboratories
 *  P. O. Box 2000, Ry80M203
 *  Rahway, New Jersey  07065
 *  USA</PDBx:address>
 *  </PDBx:pdbx_audit_author>
 *  </PDBx:pdbx_audit_authorCategory>
 * </pre>
 */
public class Pdbx_audit_author extends org.pdb.beans.Pdbx_audit_author implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_audit_author";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_audit_author()
	{
	}

	/** Full constructor */
	public Pdbx_audit_author(
		Datablock datablock,
		java.lang.String address,
		java.lang.String name,
		java.lang.Integer ordinal)
	{
		this.datablock = datablock;
		this.address = address;
		this.name = name;
		this.ordinal = ordinal;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_audit_author");
		sb.append("\n");
		if (address != null)
		{
			sb.append("address = ");
			sb.append(address);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (ordinal != null)
		{
			sb.append("ordinal = ");
			sb.append(ordinal);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		address = null;
		name = null;
		ordinal = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_audit_author)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_audit_author>\n");
			if (address != null) ow.write(indent + " <PDBx:address>" + address + "</PDBx:address>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (ordinal != null) ow.write(indent + " <PDBx:ordinal>" + ordinal + "</PDBx:ordinal>\n");
			ow.write(indent + "</PDBx:pdbx_audit_author>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
