package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_CHEM_COMP_AUDIT category records
 *  the status and tracking information for this component.
 *  
 * <pre>
 *  Example 1 -
 * </pre>
 */
public class Pdbx_chem_comp_audit extends org.pdb.beans.Pdbx_chem_comp_audit implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_chem_comp_audit";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_chem_comp_audit()
	{
	}

	/** Full constructor */
	public Pdbx_chem_comp_audit(
		Datablock datablock,
		java.lang.String action_type,
		java.lang.String annotator,
		java.lang.String comp_id,
		java.util.Date date)
	{
		this.datablock = datablock;
		this.action_type = action_type;
		this.annotator = annotator;
		this.comp_id = comp_id;
		this.date = date;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_chem_comp_audit");
		sb.append("\n");
		if (action_type != null)
		{
			sb.append("action_type = ");
			sb.append(action_type);
			sb.append('\n');
		}
		if (annotator != null)
		{
			sb.append("annotator = ");
			sb.append(annotator);
			sb.append('\n');
		}
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (date != null)
		{
			sb.append("date = ");
			sb.append(date);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		action_type = null;
		annotator = null;
		comp_id = null;
		date = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_chem_comp_audit)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_chem_comp_audit>\n");
			if (action_type != null) ow.write(indent + " <PDBx:action_type>" + action_type + "</PDBx:action_type>\n");
			if (annotator != null) ow.write(indent + " <PDBx:annotator>" + annotator + "</PDBx:annotator>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (date != null) ow.write(indent + " <PDBx:date>" + date + "</PDBx:date>\n");
			ow.write(indent + "</PDBx:pdbx_chem_comp_audit>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
