package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_CONSTRUCT_FEATURE category may be used to
 *  specify various properties of a nucleic acid sequence used during
 *  protein production.
 *  
 * <pre>
 *  Example 1 - vector pUC28
 *  <PDBx:pdbx_construct_featureCategory>
 *  <PDBx:pdbx_construct_feature id="1" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:details>pKK84-1 ClaI 5260bp 5247..5247 ptac11 TaqI-TaqI 192bp, -35 trp promoter -&gt; pEA300 5452bp</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="2" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:details>pKK84-1 1..5246 5246bp ClaI = AT^CGAT TaqI =  T^CGA cgact...</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="3" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:start_seq>5247</PDBx:start_seq>
 *  <PDBx:end_seq>5436</PDBx:end_seq>
 *  <PDBx:details>ptac11 190bp ...cat TaqI =  T^CGA ClaI = AT^CGAT</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="4" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:start_seq>5437</PDBx:start_seq>
 *  <PDBx:end_seq>5450</PDBx:end_seq>
 *  <PDBx:details>pKK84-1 5247..5260 14bp</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="5" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:type>misc_binding</PDBx:type>
 *  <PDBx:details>SIT unique EcoRI-ClaI-HindIII-BamHI-PvuII</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="6" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:type>rep_origin</PDBx:type>
 *  <PDBx:details>ORI E. coli pMB1 (ColE1 and pBR322)</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="7" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:type>promoter</PDBx:type>
 *  <PDBx:details>PRO E. coli trp</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  <PDBx:pdbx_construct_feature id="8" construct_id="1">
 *  <PDBx:entry_id>111000111</PDBx:entry_id>
 *  <PDBx:type>CDS</PDBx:type>
 *  <PDBx:details>ANT E. coli beta-lactamase gene (bla) ampicillin resistance gene (apr/amp)</PDBx:details>
 *  </PDBx:pdbx_construct_feature>
 *  </PDBx:pdbx_construct_featureCategory>
 * </pre>
 */
public class Pdbx_construct_feature extends org.pdb.beans.Pdbx_construct_feature implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_construct_feature";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_construct_feature()
	{
	}

	/** Full constructor */
	public Pdbx_construct_feature(
		Datablock datablock,
		java.lang.String construct_id,
		java.lang.String details,
		java.lang.Integer end_seq,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.Integer start_seq,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.construct_id = construct_id;
		this.details = details;
		this.end_seq = end_seq;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.start_seq = start_seq;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_construct_feature");
		sb.append("\n");
		if (construct_id != null)
		{
			sb.append("construct_id = ");
			sb.append(construct_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (end_seq != null)
		{
			sb.append("end_seq = ");
			sb.append(end_seq);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (start_seq != null)
		{
			sb.append("start_seq = ");
			sb.append(start_seq);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		construct_id = null;
		details = null;
		end_seq = null;
		entry_id = null;
		id_ = null;
		start_seq = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_construct_feature)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_construct_feature>\n");
			if (construct_id != null) ow.write(indent + " <PDBx:construct_id>" + construct_id + "</PDBx:construct_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (end_seq != null) ow.write(indent + " <PDBx:end_seq>" + end_seq + "</PDBx:end_seq>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (start_seq != null) ow.write(indent + " <PDBx:start_seq>" + start_seq + "</PDBx:start_seq>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:pdbx_construct_feature>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
