package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Internal records to track the data processing cycle.
 *  <PDBx:pdbx_database_procCategory>
 *  <PDBx:pdbx_database_proc entry_id="BDL001" cycle_id="1">
 *  <PDBx:date_begin_cycle>1998-02-27</PDBx:date_begin_cycle>
 *  <PDBx:date_end_cycle>1998-02-27</PDBx:date_end_cycle>
 *  </PDBx:pdbx_database_proc>
 *  </PDBx:pdbx_database_procCategory>
 */
public class Pdbx_database_proc extends org.pdb.beans.Pdbx_database_proc implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_database_proc";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_database_proc()
	{
	}

	/** Full constructor */
	public Pdbx_database_proc(
		Datablock datablock,
		java.lang.String cycle_id,
		java.lang.String date_begin_cycle,
		java.lang.String date_end_cycle,
		java.lang.String details,
		java.lang.String entry_id)
	{
		this.datablock = datablock;
		this.cycle_id = cycle_id;
		this.date_begin_cycle = date_begin_cycle;
		this.date_end_cycle = date_end_cycle;
		this.details = details;
		this.entry_id = entry_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_database_proc");
		sb.append("\n");
		if (cycle_id != null)
		{
			sb.append("cycle_id = ");
			sb.append(cycle_id);
			sb.append('\n');
		}
		if (date_begin_cycle != null)
		{
			sb.append("date_begin_cycle = ");
			sb.append(date_begin_cycle);
			sb.append('\n');
		}
		if (date_end_cycle != null)
		{
			sb.append("date_end_cycle = ");
			sb.append(date_end_cycle);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		cycle_id = null;
		date_begin_cycle = null;
		date_end_cycle = null;
		details = null;
		entry_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_database_proc)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_database_proc>\n");
			if (cycle_id != null) ow.write(indent + " <PDBx:cycle_id>" + cycle_id + "</PDBx:cycle_id>\n");
			if (date_begin_cycle != null) ow.write(indent + " <PDBx:date_begin_cycle>" + date_begin_cycle + "</PDBx:date_begin_cycle>\n");
			if (date_end_cycle != null) ow.write(indent + " <PDBx:date_end_cycle>" + date_end_cycle + "</PDBx:date_end_cycle>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			ow.write(indent + "</PDBx:pdbx_database_proc>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
