package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  These are internal RCSB records to keep track of data processing
 *  and status of the entry.
 *  <PDBx:pdbx_database_statusCategory>
 *  <PDBx:pdbx_database_status entry_id="1ABC">
 *  <PDBx:status_code>REL</PDBx:status_code>
 *  <PDBx:deposit_site>RCSB</PDBx:deposit_site>
 *  <PDBx:process_site>RCSB</PDBx:process_site>
 *  </PDBx:pdbx_database_status>
 *  </PDBx:pdbx_database_statusCategory>
 */
public class Pdbx_database_status extends org.pdb.beans.Pdbx_database_status implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_database_status";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_database_status()
	{
	}

	/** Full constructor */
	public Pdbx_database_status(
		Datablock datablock,
		java.lang.String SG_entry,
		java.lang.String author_approval_type,
		java.lang.String author_release_status_code,
		java.lang.String date_author_approval,
		java.lang.String date_coordinates,
		java.lang.String date_deposition_form,
		java.lang.String date_hold_coordinates,
		java.lang.String date_hold_nmr_constraints,
		java.lang.String date_hold_struct_fact,
		java.lang.String date_manuscript,
		java.lang.String date_nmr_constraints,
		java.lang.String date_of_PDB_release,
		java.util.Date date_of_mr_release,
		java.util.Date date_of_sf_release,
		java.lang.String date_struct_fact,
		java.lang.String date_submitted,
		java.lang.String dep_release_code_coordinates,
		java.lang.String dep_release_code_nmr_constraints,
		java.lang.String dep_release_code_sequence,
		java.lang.String dep_release_code_struct_fact,
		java.lang.String deposit_site,
		java.lang.String entry_id,
		java.lang.String hold_for_publication,
		java.lang.String name_depositor,
		java.lang.String pdb_date_of_author_approval,
		java.lang.String process_site,
		java.lang.String rcsb_annotator,
		java.lang.String recvd_author_approval,
		java.lang.String recvd_coordinates,
		java.lang.String recvd_deposit_form,
		java.lang.String recvd_initial_deposition_date,
		java.lang.String recvd_internal_approval,
		java.lang.String recvd_manuscript,
		java.lang.String recvd_nmr_constraints,
		java.lang.String recvd_struct_fact,
		java.lang.String status_code,
		java.lang.String status_code_mr,
		java.lang.String status_code_sf)
	{
		this.datablock = datablock;
		this.SG_entry = SG_entry;
		this.author_approval_type = author_approval_type;
		this.author_release_status_code = author_release_status_code;
		this.date_author_approval = date_author_approval;
		this.date_coordinates = date_coordinates;
		this.date_deposition_form = date_deposition_form;
		this.date_hold_coordinates = date_hold_coordinates;
		this.date_hold_nmr_constraints = date_hold_nmr_constraints;
		this.date_hold_struct_fact = date_hold_struct_fact;
		this.date_manuscript = date_manuscript;
		this.date_nmr_constraints = date_nmr_constraints;
		this.date_of_PDB_release = date_of_PDB_release;
		this.date_of_mr_release = date_of_mr_release;
		this.date_of_sf_release = date_of_sf_release;
		this.date_struct_fact = date_struct_fact;
		this.date_submitted = date_submitted;
		this.dep_release_code_coordinates = dep_release_code_coordinates;
		this.dep_release_code_nmr_constraints = dep_release_code_nmr_constraints;
		this.dep_release_code_sequence = dep_release_code_sequence;
		this.dep_release_code_struct_fact = dep_release_code_struct_fact;
		this.deposit_site = deposit_site;
		this.entry_id = entry_id;
		this.hold_for_publication = hold_for_publication;
		this.name_depositor = name_depositor;
		this.pdb_date_of_author_approval = pdb_date_of_author_approval;
		this.process_site = process_site;
		this.rcsb_annotator = rcsb_annotator;
		this.recvd_author_approval = recvd_author_approval;
		this.recvd_coordinates = recvd_coordinates;
		this.recvd_deposit_form = recvd_deposit_form;
		this.recvd_initial_deposition_date = recvd_initial_deposition_date;
		this.recvd_internal_approval = recvd_internal_approval;
		this.recvd_manuscript = recvd_manuscript;
		this.recvd_nmr_constraints = recvd_nmr_constraints;
		this.recvd_struct_fact = recvd_struct_fact;
		this.status_code = status_code;
		this.status_code_mr = status_code_mr;
		this.status_code_sf = status_code_sf;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_database_status");
		sb.append("\n");
		if (SG_entry != null)
		{
			sb.append("SG_entry = ");
			sb.append(SG_entry);
			sb.append('\n');
		}
		if (author_approval_type != null)
		{
			sb.append("author_approval_type = ");
			sb.append(author_approval_type);
			sb.append('\n');
		}
		if (author_release_status_code != null)
		{
			sb.append("author_release_status_code = ");
			sb.append(author_release_status_code);
			sb.append('\n');
		}
		if (date_author_approval != null)
		{
			sb.append("date_author_approval = ");
			sb.append(date_author_approval);
			sb.append('\n');
		}
		if (date_coordinates != null)
		{
			sb.append("date_coordinates = ");
			sb.append(date_coordinates);
			sb.append('\n');
		}
		if (date_deposition_form != null)
		{
			sb.append("date_deposition_form = ");
			sb.append(date_deposition_form);
			sb.append('\n');
		}
		if (date_hold_coordinates != null)
		{
			sb.append("date_hold_coordinates = ");
			sb.append(date_hold_coordinates);
			sb.append('\n');
		}
		if (date_hold_nmr_constraints != null)
		{
			sb.append("date_hold_nmr_constraints = ");
			sb.append(date_hold_nmr_constraints);
			sb.append('\n');
		}
		if (date_hold_struct_fact != null)
		{
			sb.append("date_hold_struct_fact = ");
			sb.append(date_hold_struct_fact);
			sb.append('\n');
		}
		if (date_manuscript != null)
		{
			sb.append("date_manuscript = ");
			sb.append(date_manuscript);
			sb.append('\n');
		}
		if (date_nmr_constraints != null)
		{
			sb.append("date_nmr_constraints = ");
			sb.append(date_nmr_constraints);
			sb.append('\n');
		}
		if (date_of_PDB_release != null)
		{
			sb.append("date_of_PDB_release = ");
			sb.append(date_of_PDB_release);
			sb.append('\n');
		}
		if (date_of_mr_release != null)
		{
			sb.append("date_of_mr_release = ");
			sb.append(date_of_mr_release);
			sb.append('\n');
		}
		if (date_of_sf_release != null)
		{
			sb.append("date_of_sf_release = ");
			sb.append(date_of_sf_release);
			sb.append('\n');
		}
		if (date_struct_fact != null)
		{
			sb.append("date_struct_fact = ");
			sb.append(date_struct_fact);
			sb.append('\n');
		}
		if (date_submitted != null)
		{
			sb.append("date_submitted = ");
			sb.append(date_submitted);
			sb.append('\n');
		}
		if (dep_release_code_coordinates != null)
		{
			sb.append("dep_release_code_coordinates = ");
			sb.append(dep_release_code_coordinates);
			sb.append('\n');
		}
		if (dep_release_code_nmr_constraints != null)
		{
			sb.append("dep_release_code_nmr_constraints = ");
			sb.append(dep_release_code_nmr_constraints);
			sb.append('\n');
		}
		if (dep_release_code_sequence != null)
		{
			sb.append("dep_release_code_sequence = ");
			sb.append(dep_release_code_sequence);
			sb.append('\n');
		}
		if (dep_release_code_struct_fact != null)
		{
			sb.append("dep_release_code_struct_fact = ");
			sb.append(dep_release_code_struct_fact);
			sb.append('\n');
		}
		if (deposit_site != null)
		{
			sb.append("deposit_site = ");
			sb.append(deposit_site);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (hold_for_publication != null)
		{
			sb.append("hold_for_publication = ");
			sb.append(hold_for_publication);
			sb.append('\n');
		}
		if (name_depositor != null)
		{
			sb.append("name_depositor = ");
			sb.append(name_depositor);
			sb.append('\n');
		}
		if (pdb_date_of_author_approval != null)
		{
			sb.append("pdb_date_of_author_approval = ");
			sb.append(pdb_date_of_author_approval);
			sb.append('\n');
		}
		if (process_site != null)
		{
			sb.append("process_site = ");
			sb.append(process_site);
			sb.append('\n');
		}
		if (rcsb_annotator != null)
		{
			sb.append("rcsb_annotator = ");
			sb.append(rcsb_annotator);
			sb.append('\n');
		}
		if (recvd_author_approval != null)
		{
			sb.append("recvd_author_approval = ");
			sb.append(recvd_author_approval);
			sb.append('\n');
		}
		if (recvd_coordinates != null)
		{
			sb.append("recvd_coordinates = ");
			sb.append(recvd_coordinates);
			sb.append('\n');
		}
		if (recvd_deposit_form != null)
		{
			sb.append("recvd_deposit_form = ");
			sb.append(recvd_deposit_form);
			sb.append('\n');
		}
		if (recvd_initial_deposition_date != null)
		{
			sb.append("recvd_initial_deposition_date = ");
			sb.append(recvd_initial_deposition_date);
			sb.append('\n');
		}
		if (recvd_internal_approval != null)
		{
			sb.append("recvd_internal_approval = ");
			sb.append(recvd_internal_approval);
			sb.append('\n');
		}
		if (recvd_manuscript != null)
		{
			sb.append("recvd_manuscript = ");
			sb.append(recvd_manuscript);
			sb.append('\n');
		}
		if (recvd_nmr_constraints != null)
		{
			sb.append("recvd_nmr_constraints = ");
			sb.append(recvd_nmr_constraints);
			sb.append('\n');
		}
		if (recvd_struct_fact != null)
		{
			sb.append("recvd_struct_fact = ");
			sb.append(recvd_struct_fact);
			sb.append('\n');
		}
		if (status_code != null)
		{
			sb.append("status_code = ");
			sb.append(status_code);
			sb.append('\n');
		}
		if (status_code_mr != null)
		{
			sb.append("status_code_mr = ");
			sb.append(status_code_mr);
			sb.append('\n');
		}
		if (status_code_sf != null)
		{
			sb.append("status_code_sf = ");
			sb.append(status_code_sf);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		SG_entry = null;
		author_approval_type = null;
		author_release_status_code = null;
		date_author_approval = null;
		date_coordinates = null;
		date_deposition_form = null;
		date_hold_coordinates = null;
		date_hold_nmr_constraints = null;
		date_hold_struct_fact = null;
		date_manuscript = null;
		date_nmr_constraints = null;
		date_of_PDB_release = null;
		date_of_mr_release = null;
		date_of_sf_release = null;
		date_struct_fact = null;
		date_submitted = null;
		dep_release_code_coordinates = null;
		dep_release_code_nmr_constraints = null;
		dep_release_code_sequence = null;
		dep_release_code_struct_fact = null;
		deposit_site = null;
		entry_id = null;
		hold_for_publication = null;
		name_depositor = null;
		pdb_date_of_author_approval = null;
		process_site = null;
		rcsb_annotator = null;
		recvd_author_approval = null;
		recvd_coordinates = null;
		recvd_deposit_form = null;
		recvd_initial_deposition_date = null;
		recvd_internal_approval = null;
		recvd_manuscript = null;
		recvd_nmr_constraints = null;
		recvd_struct_fact = null;
		status_code = null;
		status_code_mr = null;
		status_code_sf = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_database_status)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_database_status>\n");
			if (SG_entry != null) ow.write(indent + " <PDBx:SG_entry>" + SG_entry + "</PDBx:SG_entry>\n");
			if (author_approval_type != null) ow.write(indent + " <PDBx:author_approval_type>" + author_approval_type + "</PDBx:author_approval_type>\n");
			if (author_release_status_code != null) ow.write(indent + " <PDBx:author_release_status_code>" + author_release_status_code + "</PDBx:author_release_status_code>\n");
			if (date_author_approval != null) ow.write(indent + " <PDBx:date_author_approval>" + date_author_approval + "</PDBx:date_author_approval>\n");
			if (date_coordinates != null) ow.write(indent + " <PDBx:date_coordinates>" + date_coordinates + "</PDBx:date_coordinates>\n");
			if (date_deposition_form != null) ow.write(indent + " <PDBx:date_deposition_form>" + date_deposition_form + "</PDBx:date_deposition_form>\n");
			if (date_hold_coordinates != null) ow.write(indent + " <PDBx:date_hold_coordinates>" + date_hold_coordinates + "</PDBx:date_hold_coordinates>\n");
			if (date_hold_nmr_constraints != null) ow.write(indent + " <PDBx:date_hold_nmr_constraints>" + date_hold_nmr_constraints + "</PDBx:date_hold_nmr_constraints>\n");
			if (date_hold_struct_fact != null) ow.write(indent + " <PDBx:date_hold_struct_fact>" + date_hold_struct_fact + "</PDBx:date_hold_struct_fact>\n");
			if (date_manuscript != null) ow.write(indent + " <PDBx:date_manuscript>" + date_manuscript + "</PDBx:date_manuscript>\n");
			if (date_nmr_constraints != null) ow.write(indent + " <PDBx:date_nmr_constraints>" + date_nmr_constraints + "</PDBx:date_nmr_constraints>\n");
			if (date_of_PDB_release != null) ow.write(indent + " <PDBx:date_of_PDB_release>" + date_of_PDB_release + "</PDBx:date_of_PDB_release>\n");
			if (date_of_mr_release != null) ow.write(indent + " <PDBx:date_of_mr_release>" + date_of_mr_release + "</PDBx:date_of_mr_release>\n");
			if (date_of_sf_release != null) ow.write(indent + " <PDBx:date_of_sf_release>" + date_of_sf_release + "</PDBx:date_of_sf_release>\n");
			if (date_struct_fact != null) ow.write(indent + " <PDBx:date_struct_fact>" + date_struct_fact + "</PDBx:date_struct_fact>\n");
			if (date_submitted != null) ow.write(indent + " <PDBx:date_submitted>" + date_submitted + "</PDBx:date_submitted>\n");
			if (dep_release_code_coordinates != null) ow.write(indent + " <PDBx:dep_release_code_coordinates>" + dep_release_code_coordinates + "</PDBx:dep_release_code_coordinates>\n");
			if (dep_release_code_nmr_constraints != null) ow.write(indent + " <PDBx:dep_release_code_nmr_constraints>" + dep_release_code_nmr_constraints + "</PDBx:dep_release_code_nmr_constraints>\n");
			if (dep_release_code_sequence != null) ow.write(indent + " <PDBx:dep_release_code_sequence>" + dep_release_code_sequence + "</PDBx:dep_release_code_sequence>\n");
			if (dep_release_code_struct_fact != null) ow.write(indent + " <PDBx:dep_release_code_struct_fact>" + dep_release_code_struct_fact + "</PDBx:dep_release_code_struct_fact>\n");
			if (deposit_site != null) ow.write(indent + " <PDBx:deposit_site>" + deposit_site + "</PDBx:deposit_site>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (hold_for_publication != null) ow.write(indent + " <PDBx:hold_for_publication>" + hold_for_publication + "</PDBx:hold_for_publication>\n");
			if (name_depositor != null) ow.write(indent + " <PDBx:name_depositor>" + name_depositor + "</PDBx:name_depositor>\n");
			if (pdb_date_of_author_approval != null) ow.write(indent + " <PDBx:pdb_date_of_author_approval>" + pdb_date_of_author_approval + "</PDBx:pdb_date_of_author_approval>\n");
			if (process_site != null) ow.write(indent + " <PDBx:process_site>" + process_site + "</PDBx:process_site>\n");
			if (rcsb_annotator != null) ow.write(indent + " <PDBx:rcsb_annotator>" + rcsb_annotator + "</PDBx:rcsb_annotator>\n");
			if (recvd_author_approval != null) ow.write(indent + " <PDBx:recvd_author_approval>" + recvd_author_approval + "</PDBx:recvd_author_approval>\n");
			if (recvd_coordinates != null) ow.write(indent + " <PDBx:recvd_coordinates>" + recvd_coordinates + "</PDBx:recvd_coordinates>\n");
			if (recvd_deposit_form != null) ow.write(indent + " <PDBx:recvd_deposit_form>" + recvd_deposit_form + "</PDBx:recvd_deposit_form>\n");
			if (recvd_initial_deposition_date != null) ow.write(indent + " <PDBx:recvd_initial_deposition_date>" + recvd_initial_deposition_date + "</PDBx:recvd_initial_deposition_date>\n");
			if (recvd_internal_approval != null) ow.write(indent + " <PDBx:recvd_internal_approval>" + recvd_internal_approval + "</PDBx:recvd_internal_approval>\n");
			if (recvd_manuscript != null) ow.write(indent + " <PDBx:recvd_manuscript>" + recvd_manuscript + "</PDBx:recvd_manuscript>\n");
			if (recvd_nmr_constraints != null) ow.write(indent + " <PDBx:recvd_nmr_constraints>" + recvd_nmr_constraints + "</PDBx:recvd_nmr_constraints>\n");
			if (recvd_struct_fact != null) ow.write(indent + " <PDBx:recvd_struct_fact>" + recvd_struct_fact + "</PDBx:recvd_struct_fact>\n");
			if (status_code != null) ow.write(indent + " <PDBx:status_code>" + status_code + "</PDBx:status_code>\n");
			if (status_code_mr != null) ow.write(indent + " <PDBx:status_code_mr>" + status_code_mr + "</PDBx:status_code_mr>\n");
			if (status_code_sf != null) ow.write(indent + " <PDBx:status_code_sf>" + status_code_sf + "</PDBx:status_code_sf>\n");
			ow.write(indent + "</PDBx:pdbx_database_status>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
