package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_DOMAIN category record information
 *  about domain definitions.
 *  
 *  A domain need not correspond to a completely polypeptide chain;
 *  it can be composed of one or more segments in a single chain,
 *  or by segments from more than one chain.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_domainCategory>
 *  <PDBx:pdbx_domain id="d1">
 *  <PDBx:details>Chains A, B</PDBx:details>
 *  </PDBx:pdbx_domain>
 *  <PDBx:pdbx_domain id="d2">
 *  <PDBx:details>Asym_id D Residues 1-134</PDBx:details>
 *  </PDBx:pdbx_domain>
 *  </PDBx:pdbx_domainCategory>
 * </pre>
 */
public class Pdbx_domain extends org.pdb.beans.Pdbx_domain implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_domain";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_domain()
	{
	}

	/** Full constructor */
	public Pdbx_domain(
		Datablock datablock,
		java.lang.String details,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.details = details;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_domain");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_domain)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_domain>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:pdbx_domain>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
