package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  The PDBX_ENTITY_ASSEMBLY category provides a chemical description
 *  of the biological assembly studied in terms of its constituent
 *  entities.
 *  A complex composed of one copy of entities 1 and 2.
 *  <PDBx:pdbx_entity_assemblyCategory>
 *  <PDBx:pdbx_entity_assembly id="1" entity_id="1">
 *  <PDBx:biol_id>1</PDBx:biol_id>
 *  <PDBx:num_copies>1</PDBx:num_copies>
 *  </PDBx:pdbx_entity_assembly>
 *  <PDBx:pdbx_entity_assembly id="1" entity_id="2">
 *  <PDBx:biol_id>1</PDBx:biol_id>
 *  <PDBx:num_copies>1</PDBx:num_copies>
 *  </PDBx:pdbx_entity_assembly>
 *  </PDBx:pdbx_entity_assemblyCategory>
 */
public class Pdbx_entity_assembly extends org.pdb.beans.Pdbx_entity_assembly implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_entity_assembly";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_entity_assembly()
	{
	}

	/** Full constructor */
	public Pdbx_entity_assembly(
		Datablock datablock,
		java.lang.String biol_id,
		java.lang.String entity_id,
		java.lang.String id_,
		java.lang.Integer num_copies)
	{
		this.datablock = datablock;
		this.biol_id = biol_id;
		this.entity_id = entity_id;
		this.id_ = id_;
		this.num_copies = num_copies;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_entity_assembly");
		sb.append("\n");
		if (biol_id != null)
		{
			sb.append("biol_id = ");
			sb.append(biol_id);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (num_copies != null)
		{
			sb.append("num_copies = ");
			sb.append(num_copies);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		biol_id = null;
		entity_id = null;
		id_ = null;
		num_copies = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_entity_assembly)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_entity_assembly>\n");
			if (biol_id != null) ow.write(indent + " <PDBx:biol_id>" + biol_id + "</PDBx:biol_id>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (num_copies != null) ow.write(indent + " <PDBx:num_copies>" + num_copies + "</PDBx:num_copies>\n");
			ow.write(indent + "</PDBx:pdbx_entity_assembly>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
