package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  The PDBX_ENTITY_NAME records additional name information for
 *  each entity.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_entity_nameCategory>
 *  <PDBx:pdbx_entity_name entity_id="1" name="PLASTOCYANIN" name_type="SWS-NAME"></PDBx:pdbx_entity_name>
 *  <PDBx:pdbx_entity_name entity_id="1" name="Electron transport" name_type="SWS-KEYWORD"></PDBx:pdbx_entity_name>
 *  </PDBx:pdbx_entity_nameCategory>
 * </pre>
 */
public class Pdbx_entity_name extends org.pdb.beans.Pdbx_entity_name implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_entity_name";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_entity_name()
	{
	}

	/** Full constructor */
	public Pdbx_entity_name(
		Datablock datablock,
		java.lang.String entity_id,
		java.lang.String name,
		java.lang.String name_type)
	{
		this.datablock = datablock;
		this.entity_id = entity_id;
		this.name = name;
		this.name_type = name_type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_entity_name");
		sb.append("\n");
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (name_type != null)
		{
			sb.append("name_type = ");
			sb.append(name_type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entity_id = null;
		name = null;
		name_type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_entity_name)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_entity_name>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (name_type != null) ow.write(indent + " <PDBx:name_type>" + name_type + "</PDBx:name_type>\n");
			ow.write(indent + "</PDBx:pdbx_entity_name>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
