package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  This category contains details for the recombination-based cloning steps
 *  used in the overall protein production process. It is assumed that these
 *  reactions will use commercially available kits.
 *  attribute clone_step_id in category pdbx_entity_src_gen_clone_recombination in this category
 *  must point at a defined  attribute step_id in category pdbx_entity_src_gen_clone.  The details in
 *  PDBX_ENTITY_SRC_GEN_CLONE_RECOMBINATION extend the details in PDBX_ENTITY_SRC_GEN_CLONE
 *  to cover recombination dependent cloning steps.
 */
public class Pdbx_entity_src_gen_clone_recombination extends org.pdb.beans.Pdbx_entity_src_gen_clone_recombination implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_entity_src_gen_clone_recombination";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_entity_src_gen_clone_recombination()
	{
	}

	/** Full constructor */
	public Pdbx_entity_src_gen_clone_recombination(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entity_id,
		java.lang.String entry_id,
		java.lang.String recombination_enzymes,
		java.lang.Integer step_id,
		java.lang.String system)
	{
		this.datablock = datablock;
		this.details = details;
		this.entity_id = entity_id;
		this.entry_id = entry_id;
		this.recombination_enzymes = recombination_enzymes;
		this.step_id = step_id;
		this.system = system;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_entity_src_gen_clone_recombination");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (recombination_enzymes != null)
		{
			sb.append("recombination_enzymes = ");
			sb.append(recombination_enzymes);
			sb.append('\n');
		}
		if (step_id != null)
		{
			sb.append("step_id = ");
			sb.append(step_id);
			sb.append('\n');
		}
		if (system != null)
		{
			sb.append("system = ");
			sb.append(system);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entity_id = null;
		entry_id = null;
		recombination_enzymes = null;
		step_id = null;
		system = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_entity_src_gen_clone_recombination)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_entity_src_gen_clone_recombination>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (recombination_enzymes != null) ow.write(indent + " <PDBx:recombination_enzymes>" + recombination_enzymes + "</PDBx:recombination_enzymes>\n");
			if (step_id != null) ow.write(indent + " <PDBx:step_id>" + step_id + "</PDBx:step_id>\n");
			if (system != null) ow.write(indent + " <PDBx:system>" + system + "</PDBx:system>\n");
			ow.write(indent + "</PDBx:pdbx_entity_src_gen_clone_recombination>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
