package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  This category contains details for the final purified protein product. Note
 *  that this category does not contain the amino acid sequence of the protein.
 *  The sequence will be found in the ENTITY_POLY_SEQ entry with matching
 *  entity_id.
 *  Only one PDBX_ENTITY_SRC_GEN_PURE category is allowed per entity, hence there is
 *  no step_id for this category.
 */
public class Pdbx_entity_src_gen_pure extends org.pdb.beans.Pdbx_entity_src_gen_pure implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_entity_src_gen_pure";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_entity_src_gen_pure()
	{
	}

	/** Full constructor */
	public Pdbx_entity_src_gen_pure(
		Datablock datablock,
		java.lang.String conc_assay_method,
		java.lang.String conc_details,
		java.lang.String conc_device_id,
		java.lang.String date,
		java.lang.String entity_id,
		java.lang.String entry_id,
		java.lang.String product_id,
		java.lang.Float protein_concentration,
		java.lang.Integer protein_oligomeric_state,
		java.lang.Float protein_purity,
		java.lang.Float protein_yield,
		java.lang.Integer step_id,
		java.lang.String storage_buffer_id,
		java.lang.Float storage_temperature,
		java.lang.String summary)
	{
		this.datablock = datablock;
		this.conc_assay_method = conc_assay_method;
		this.conc_details = conc_details;
		this.conc_device_id = conc_device_id;
		this.date = date;
		this.entity_id = entity_id;
		this.entry_id = entry_id;
		this.product_id = product_id;
		this.protein_concentration = protein_concentration;
		this.protein_oligomeric_state = protein_oligomeric_state;
		this.protein_purity = protein_purity;
		this.protein_yield = protein_yield;
		this.step_id = step_id;
		this.storage_buffer_id = storage_buffer_id;
		this.storage_temperature = storage_temperature;
		this.summary = summary;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_entity_src_gen_pure");
		sb.append("\n");
		if (conc_assay_method != null)
		{
			sb.append("conc_assay_method = ");
			sb.append(conc_assay_method);
			sb.append('\n');
		}
		if (conc_details != null)
		{
			sb.append("conc_details = ");
			sb.append(conc_details);
			sb.append('\n');
		}
		if (conc_device_id != null)
		{
			sb.append("conc_device_id = ");
			sb.append(conc_device_id);
			sb.append('\n');
		}
		if (date != null)
		{
			sb.append("date = ");
			sb.append(date);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (product_id != null)
		{
			sb.append("product_id = ");
			sb.append(product_id);
			sb.append('\n');
		}
		if (protein_concentration != null)
		{
			sb.append("protein_concentration = ");
			sb.append(protein_concentration);
			sb.append('\n');
		}
		if (protein_oligomeric_state != null)
		{
			sb.append("protein_oligomeric_state = ");
			sb.append(protein_oligomeric_state);
			sb.append('\n');
		}
		if (protein_purity != null)
		{
			sb.append("protein_purity = ");
			sb.append(protein_purity);
			sb.append('\n');
		}
		if (protein_yield != null)
		{
			sb.append("protein_yield = ");
			sb.append(protein_yield);
			sb.append('\n');
		}
		if (step_id != null)
		{
			sb.append("step_id = ");
			sb.append(step_id);
			sb.append('\n');
		}
		if (storage_buffer_id != null)
		{
			sb.append("storage_buffer_id = ");
			sb.append(storage_buffer_id);
			sb.append('\n');
		}
		if (storage_temperature != null)
		{
			sb.append("storage_temperature = ");
			sb.append(storage_temperature);
			sb.append('\n');
		}
		if (summary != null)
		{
			sb.append("summary = ");
			sb.append(summary);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		conc_assay_method = null;
		conc_details = null;
		conc_device_id = null;
		date = null;
		entity_id = null;
		entry_id = null;
		product_id = null;
		protein_concentration = null;
		protein_oligomeric_state = null;
		protein_purity = null;
		protein_yield = null;
		step_id = null;
		storage_buffer_id = null;
		storage_temperature = null;
		summary = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_entity_src_gen_pure)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_entity_src_gen_pure>\n");
			if (conc_assay_method != null) ow.write(indent + " <PDBx:conc_assay_method>" + conc_assay_method + "</PDBx:conc_assay_method>\n");
			if (conc_details != null) ow.write(indent + " <PDBx:conc_details>" + conc_details + "</PDBx:conc_details>\n");
			if (conc_device_id != null) ow.write(indent + " <PDBx:conc_device_id>" + conc_device_id + "</PDBx:conc_device_id>\n");
			if (date != null) ow.write(indent + " <PDBx:date>" + date + "</PDBx:date>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (product_id != null) ow.write(indent + " <PDBx:product_id>" + product_id + "</PDBx:product_id>\n");
			if (protein_concentration != null) ow.write(indent + " <PDBx:protein_concentration>" + protein_concentration + "</PDBx:protein_concentration>\n");
			if (protein_oligomeric_state != null) ow.write(indent + " <PDBx:protein_oligomeric_state>" + protein_oligomeric_state + "</PDBx:protein_oligomeric_state>\n");
			if (protein_purity != null) ow.write(indent + " <PDBx:protein_purity>" + protein_purity + "</PDBx:protein_purity>\n");
			if (protein_yield != null) ow.write(indent + " <PDBx:protein_yield>" + protein_yield + "</PDBx:protein_yield>\n");
			if (step_id != null) ow.write(indent + " <PDBx:step_id>" + step_id + "</PDBx:step_id>\n");
			if (storage_buffer_id != null) ow.write(indent + " <PDBx:storage_buffer_id>" + storage_buffer_id + "</PDBx:storage_buffer_id>\n");
			if (storage_temperature != null) ow.write(indent + " <PDBx:storage_temperature>" + storage_temperature + "</PDBx:storage_temperature>\n");
			if (summary != null) ow.write(indent + " <PDBx:summary>" + summary + "</PDBx:summary>\n");
			ow.write(indent + "</PDBx:pdbx_entity_src_gen_pure>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
