package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_EXPTL_CRYSTAL_CRYO_TREATMENT category
 *  record details cryogenic treatments applied to this crystal.
 *  
 * <pre>
 *  Example 1
 *  <PDBx:pdbx_exptl_crystal_cryo_treatmentCategory>
 *  <PDBx:pdbx_exptl_crystal_cryo_treatment crystal_id="4">
 *  <PDBx:final_solution_details>  25&#37; (v/v) glycerol in precipitant solution</PDBx:final_solution_details>
 *  <PDBx:soaking_details>  A series of 1 min soaks beginning at 5&#37; (v/v) glycerol in precipitant,
 *  transiting to 20&#37; (v/v) glycerol, and finally to 25&#37; glycerol</PDBx:soaking_details>
 *  <PDBx:cooling_details>  Direct immersion in liquid nitrogen</PDBx:cooling_details>
 *  </PDBx:pdbx_exptl_crystal_cryo_treatment>
 *  </PDBx:pdbx_exptl_crystal_cryo_treatmentCategory>
 * </pre>
 */
public class Pdbx_exptl_crystal_cryo_treatment extends org.pdb.beans.Pdbx_exptl_crystal_cryo_treatment implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_exptl_crystal_cryo_treatment";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_exptl_crystal_cryo_treatment()
	{
	}

	/** Full constructor */
	public Pdbx_exptl_crystal_cryo_treatment(
		Datablock datablock,
		java.lang.String annealing_details,
		java.lang.String cooling_details,
		java.lang.String crystal_id,
		java.lang.String final_solution_details,
		java.lang.String soaking_details)
	{
		this.datablock = datablock;
		this.annealing_details = annealing_details;
		this.cooling_details = cooling_details;
		this.crystal_id = crystal_id;
		this.final_solution_details = final_solution_details;
		this.soaking_details = soaking_details;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_exptl_crystal_cryo_treatment");
		sb.append("\n");
		if (annealing_details != null)
		{
			sb.append("annealing_details = ");
			sb.append(annealing_details);
			sb.append('\n');
		}
		if (cooling_details != null)
		{
			sb.append("cooling_details = ");
			sb.append(cooling_details);
			sb.append('\n');
		}
		if (crystal_id != null)
		{
			sb.append("crystal_id = ");
			sb.append(crystal_id);
			sb.append('\n');
		}
		if (final_solution_details != null)
		{
			sb.append("final_solution_details = ");
			sb.append(final_solution_details);
			sb.append('\n');
		}
		if (soaking_details != null)
		{
			sb.append("soaking_details = ");
			sb.append(soaking_details);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		annealing_details = null;
		cooling_details = null;
		crystal_id = null;
		final_solution_details = null;
		soaking_details = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_exptl_crystal_cryo_treatment)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_exptl_crystal_cryo_treatment>\n");
			if (annealing_details != null) ow.write(indent + " <PDBx:annealing_details>" + annealing_details + "</PDBx:annealing_details>\n");
			if (cooling_details != null) ow.write(indent + " <PDBx:cooling_details>" + cooling_details + "</PDBx:cooling_details>\n");
			if (crystal_id != null) ow.write(indent + " <PDBx:crystal_id>" + crystal_id + "</PDBx:crystal_id>\n");
			if (final_solution_details != null) ow.write(indent + " <PDBx:final_solution_details>" + final_solution_details + "</PDBx:final_solution_details>\n");
			if (soaking_details != null) ow.write(indent + " <PDBx:soaking_details>" + soaking_details + "</PDBx:soaking_details>\n");
			ow.write(indent + "</PDBx:pdbx_exptl_crystal_cryo_treatment>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
