package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_EXPTL_CRYSTAL_GROW_COMP category record
 *  details about the components of the solutions that were 'mixed'
 *  to produce the crystal.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_exptl_crystal_grow_compCategory>
 *  <PDBx:pdbx_exptl_crystal_grow_comp crystal_id="4" comp_id="1">
 *  <PDBx:sol_id>protein</PDBx:sol_id>
 *  <PDBx:comp_name>protein</PDBx:comp_name>
 *  <PDBx:conc>25.</PDBx:conc>
 *  <PDBx:conc_units>mg/ml</PDBx:conc_units>
 *  </PDBx:pdbx_exptl_crystal_grow_comp>
 *  <PDBx:pdbx_exptl_crystal_grow_comp crystal_id="4" comp_id="2">
 *  <PDBx:sol_id>protein</PDBx:sol_id>
 *  <PDBx:comp_name>Tris HCl</PDBx:comp_name>
 *  <PDBx:conc>20.</PDBx:conc>
 *  <PDBx:conc_units>millimolar</PDBx:conc_units>
 *  </PDBx:pdbx_exptl_crystal_grow_comp>
 *  <PDBx:pdbx_exptl_crystal_grow_comp crystal_id="4" comp_id="3">
 *  <PDBx:sol_id>protein</PDBx:sol_id>
 *  <PDBx:comp_name>NaCl</PDBx:comp_name>
 *  <PDBx:conc>0.2</PDBx:conc>
 *  <PDBx:conc_units>molar</PDBx:conc_units>
 *  </PDBx:pdbx_exptl_crystal_grow_comp>
 *  <PDBx:pdbx_exptl_crystal_grow_comp crystal_id="4" comp_id="1">
 *  <PDBx:sol_id>precipitant</PDBx:sol_id>
 *  <PDBx:comp_name>PEG 4000</PDBx:comp_name>
 *  <PDBx:conc>12.5</PDBx:conc>
 *  <PDBx:conc_units>percent_weight_by_volume</PDBx:conc_units>
 *  </PDBx:pdbx_exptl_crystal_grow_comp>
 *  <PDBx:pdbx_exptl_crystal_grow_comp crystal_id="4" comp_id="2">
 *  <PDBx:sol_id>precipitant</PDBx:sol_id>
 *  <PDBx:comp_name>MES</PDBx:comp_name>
 *  <PDBx:conc>0.1</PDBx:conc>
 *  <PDBx:conc_units>molar</PDBx:conc_units>
 *  </PDBx:pdbx_exptl_crystal_grow_comp>
 *  </PDBx:pdbx_exptl_crystal_grow_compCategory>
 * </pre>
 */
public class Pdbx_exptl_crystal_grow_comp extends org.pdb.beans.Pdbx_exptl_crystal_grow_comp implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_exptl_crystal_grow_comp";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_exptl_crystal_grow_comp()
	{
	}

	/** Full constructor */
	public Pdbx_exptl_crystal_grow_comp(
		Datablock datablock,
		java.lang.String comp_id,
		java.lang.String comp_name,
		java.lang.Float conc,
		java.lang.String conc_range,
		java.lang.String conc_units,
		java.lang.String crystal_id,
		java.lang.String sol_id)
	{
		this.datablock = datablock;
		this.comp_id = comp_id;
		this.comp_name = comp_name;
		this.conc = conc;
		this.conc_range = conc_range;
		this.conc_units = conc_units;
		this.crystal_id = crystal_id;
		this.sol_id = sol_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_exptl_crystal_grow_comp");
		sb.append("\n");
		if (comp_id != null)
		{
			sb.append("comp_id = ");
			sb.append(comp_id);
			sb.append('\n');
		}
		if (comp_name != null)
		{
			sb.append("comp_name = ");
			sb.append(comp_name);
			sb.append('\n');
		}
		if (conc != null)
		{
			sb.append("conc = ");
			sb.append(conc);
			sb.append('\n');
		}
		if (conc_range != null)
		{
			sb.append("conc_range = ");
			sb.append(conc_range);
			sb.append('\n');
		}
		if (conc_units != null)
		{
			sb.append("conc_units = ");
			sb.append(conc_units);
			sb.append('\n');
		}
		if (crystal_id != null)
		{
			sb.append("crystal_id = ");
			sb.append(crystal_id);
			sb.append('\n');
		}
		if (sol_id != null)
		{
			sb.append("sol_id = ");
			sb.append(sol_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		comp_id = null;
		comp_name = null;
		conc = null;
		conc_range = null;
		conc_units = null;
		crystal_id = null;
		sol_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_exptl_crystal_grow_comp)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_exptl_crystal_grow_comp>\n");
			if (comp_id != null) ow.write(indent + " <PDBx:comp_id>" + comp_id + "</PDBx:comp_id>\n");
			if (comp_name != null) ow.write(indent + " <PDBx:comp_name>" + comp_name + "</PDBx:comp_name>\n");
			if (conc != null) ow.write(indent + " <PDBx:conc>" + conc + "</PDBx:conc>\n");
			if (conc_range != null) ow.write(indent + " <PDBx:conc_range>" + conc_range + "</PDBx:conc_range>\n");
			if (conc_units != null) ow.write(indent + " <PDBx:conc_units>" + conc_units + "</PDBx:conc_units>\n");
			if (crystal_id != null) ow.write(indent + " <PDBx:crystal_id>" + crystal_id + "</PDBx:crystal_id>\n");
			if (sol_id != null) ow.write(indent + " <PDBx:sol_id>" + sol_id + "</PDBx:sol_id>\n");
			ow.write(indent + "</PDBx:pdbx_exptl_crystal_grow_comp>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
